/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.plan.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgLevelTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgAllParentVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.eunm.DataFromEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.service.DiscountRateSdkService;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.service.TpmSapDaySalesService;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmSapDaySalesVo;
import com.biz.crm.tpm.business.sales.plan.local.entity.SalesPlanEntity;
import com.biz.crm.tpm.business.sales.plan.local.mapper.SalesPlanMapper;
import com.biz.crm.tpm.business.sales.plan.local.repository.SalesPlanRepository;
import com.biz.crm.tpm.business.sales.plan.local.service.SalesPlanSyncService;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanConfirmDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanLogEventDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanReCalPlanAndReplyDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanSummaryDto;
import com.biz.crm.tpm.business.sales.plan.sdk.enums.ConfirmEunm;
import com.biz.crm.tpm.business.sales.plan.sdk.enums.SummaryDimensionEunm;
import com.biz.crm.tpm.business.sales.plan.sdk.event.SalesPlanLogEventListener;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SubSaleMonitorVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SalesPlanServiceImpl
implements SalesPlanService {
    private static final Logger log = LoggerFactory.getLogger(SalesPlanServiceImpl.class);
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private SalesPlanMapper salesPlanMapper;
    @Autowired(required=false)
    private SalesPlanRepository salesPlanRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private DiscountRateSdkService discountRateSdkService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private SalesPlanSyncService salesPlanSyncService;
    @Autowired
    private SalesOrgSubComOrgService salesOrgSubComOrgService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Autowired(required=false)
    private TpmSapDaySalesService tpmSapDaySalesService;

    public Page<SalesPlanVo> findByConditions(Pageable pageable, SalesPlanDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        dto = (SalesPlanDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new SalesPlanDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.salesPlanMapper.findByConditions((Page<SalesPlanVo>)page, dto);
    }

    public List<SalesPlanVo> findByConditions(SalesPlanDto dto) {
        if (dto == null) {
            return Lists.newArrayList();
        }
        List<SalesPlanEntity> salesPlans = this.salesPlanRepository.findByConditions(dto);
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(salesPlans, SalesPlanEntity.class, SalesPlanVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public SalesPlanVo findById(String id) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        SalesPlanEntity salesPlanEntity = this.salesPlanRepository.getById(id, DelFlagStatusEnum.NORMAL.getCode());
        Validate.notNull((Object)((Object)salesPlanEntity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        return (SalesPlanVo)this.nebulaToolkitService.copyObjectByBlankList((Object)salesPlanEntity, SalesPlanVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public SalesPlanVo update(SalesPlanDto dto) {
        this.updateValidate(dto);
        SalesPlanVo salesPlanVo = this.findById(dto.getId());
        if (ObjectUtils.isEmpty((Object)salesPlanVo)) {
            throw new RuntimeException("\u4fee\u6539\u6570\u636e\u5931\u8d25\uff0c\u539f\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        dto = this.convertOrg(Lists.newArrayList((Object[])new SalesPlanDto[]{dto})).get(0);
        SalesPlanDto oldVo = (SalesPlanDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)salesPlanVo, SalesPlanDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        SalesPlanEntity salesPlanEntity = (SalesPlanEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SalesPlanEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.salesPlanRepository.saveOrUpdate((Object)salesPlanEntity);
        SalesPlanLogEventDto logEventDto = new SalesPlanLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onUpdate = SalesPlanLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SalesPlanLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return (SalesPlanVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SalesPlanVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    private void updateValidate(SalesPlanDto dto) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        this.buildData(dto);
    }

    private void buildData(SalesPlanDto dto) {
        List salesOrgVos;
        ArrayList<String> salesOrgCodeList = new ArrayList<String>();
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dto.getSalesInstitutionCode())) {
            salesOrgCodeList.add(dto.getSalesInstitutionCode());
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dto.getSalesOrgRegionCode())) {
            salesOrgCodeList.add(dto.getSalesOrgRegionCode());
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dto.getSalesOrgProvinceCode())) {
            salesOrgCodeList.add(dto.getSalesOrgProvinceCode());
        }
        if (!CollectionUtils.isEmpty((Collection)(salesOrgVos = this.salesOrgVoService.findBySalesOrgCodes(salesOrgCodeList)))) {
            Map salesOrgMap = salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity(), (oldVo, newVo) -> newVo));
            if (salesOrgMap.containsKey(dto.getSalesInstitutionCode())) {
                dto.setSalesInstitutionErpCode(((SalesOrgVo)salesOrgMap.get(dto.getSalesInstitutionCode())).getErpCode());
            }
            if (salesOrgMap.containsKey(dto.getSalesOrgRegionCode())) {
                dto.setSalesOrgRegionErpCode(((SalesOrgVo)salesOrgMap.get(dto.getSalesOrgRegionCode())).getErpCode());
            }
            if (salesOrgMap.containsKey(dto.getSalesOrgProvinceCode())) {
                dto.setSalesOrgProvinceErpCode(((SalesOrgVo)salesOrgMap.get(dto.getSalesOrgProvinceCode())).getErpCode());
            }
        }
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
            String saleOrgErpCode;
            List subComOrgVos;
            BigDecimal vat = dto.getVat();
            BigDecimal vatRate = BigDecimal.ZERO;
            String salesInstitutionCode = dto.getSalesInstitutionCode();
            if (StringUtils.hasText((String)salesInstitutionCode) && !CollectionUtils.isEmpty((Collection)(subComOrgVos = this.salesOrgSubComOrgService.findBySaleOrgErpCode(saleOrgErpCode = salesInstitutionCode.substring(salesInstitutionCode.length() - 4, salesInstitutionCode.length()))))) {
                SalesOrgSubComOrgVo salesOrgSubComOrgVo = (SalesOrgSubComOrgVo)subComOrgVos.get(0);
                vatRate = salesOrgSubComOrgVo.getVatRate();
            }
            if (Objects.isNull(vatRate)) {
                vatRate = new BigDecimal(0.12);
            }
            dto.setTaxesAdditional(vat.multiply(vatRate).setScale(6, 0));
            log.info("\u589e\u503c\u7a0e1\uff0c{}", (Object)vat);
            log.info("\u589e\u503c\u7a0e2\uff0c{}", (Object)vat);
            log.info("\u589e\u503c\u7a0e\u7a0e\u73872\uff0c{}", (Object)vatRate);
            log.info("\u9644\u52a0\u7a0e\u91d12,{}", (Object)dto.getTaxesAdditional());
            dto.setSpecialDataStatus(ConfirmEunm.TOBECONFIRMED.getCode());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\uff01");
        }
        List salesPlanEntities = this.salesPlanRepository.listByIds(ids);
        if (!CollectionUtils.isEmpty((Collection)salesPlanEntities)) {
            salesPlanEntities.forEach(salesPlanEntity -> Validate.isTrue((!DataFromEnum.FOREIGN_SYSTEM.getCode().equals(salesPlanEntity.getDataFromCode()) ? 1 : 0) != 0, (String)"\u901a\u8fc7\u7cfb\u7edf\u63a5\u53e3\u540c\u6b65\u8fc7\u6765\u7684\u6570\u636e\u4e0d\u652f\u6301\u5220\u9664\uff01", (Object[])new Object[0]));
            this.salesPlanRepository.updateDelStatus(ids, DelFlagStatusEnum.DELETE.getCode());
        }
        List<SalesPlanEntity> mqUpdateList = salesPlanEntities.stream().filter(e -> org.apache.commons.lang3.StringUtils.equals((CharSequence)BusinessUnitEnum.SON_COMPANY.getCode(), (CharSequence)e.getBusinessUnitCode())).collect(Collectors.toList());
        this.sendMqMsg(mqUpdateList);
        salesPlanEntities.forEach(salesPlanEntity -> {
            SalesPlanLogEventDto logEventDto = new SalesPlanLogEventDto();
            logEventDto.setOriginal((SalesPlanDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)salesPlanEntity, SalesPlanDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            logEventDto.setNewest(null);
            SerializableBiConsumer & Serializable onDelete = SalesPlanLogEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SalesPlanLogEventListener.class, (SerializableBiConsumer)onDelete);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public SalesPlanVo create(SalesPlanDto dto) {
        this.createValidate(dto);
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto = this.convertOrg(Lists.newArrayList((Object[])new SalesPlanDto[]{dto})).get(0);
        SalesPlanEntity salesPlanEntity = (SalesPlanEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SalesPlanEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.salesPlanRepository.saveOrUpdate((Object)salesPlanEntity);
        dto.setId(salesPlanEntity.getId());
        SalesPlanLogEventDto logEventDto = new SalesPlanLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onCreate = SalesPlanLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SalesPlanLogEventListener.class, (SerializableBiConsumer)onCreate);
        return (SalesPlanVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SalesPlanVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void importSave(List<SalesPlanDto> importList) {
        if (CollectionUtils.isEmpty(importList)) {
            return;
        }
        importList.forEach(dto -> {
            this.createValidate((SalesPlanDto)dto);
            dto.setTenantCode(TenantUtils.getTenantCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setDataFromCode(DataFromEnum.IMPORT.getCode());
        });
        Collection salesGoalEntities = this.nebulaToolkitService.copyCollectionByWhiteList(importList, SalesPlanDto.class, SalesPlanEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.salesPlanRepository.saveBatch(salesGoalEntities);
        importList.forEach(dto -> {
            SalesPlanLogEventDto logEventDto = new SalesPlanLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = SalesPlanLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SalesPlanLogEventListener.class, (SerializableBiConsumer)onCreate);
        });
    }

    public List<SalesPlanVo> listByConditions(SalesPlanDto salesPlanDto) {
        List<SalesPlanEntity> salesPlanEntities = this.salesPlanMapper.listByConditions(salesPlanDto, 60000);
        if (CollectionUtils.isEmpty(salesPlanEntities)) {
            return Lists.newArrayList();
        }
        return new ArrayList<SalesPlanVo>(this.nebulaToolkitService.copyCollectionByWhiteList(salesPlanEntities, SalesPlanEntity.class, SalesPlanVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
    }

    public Map<String, BigDecimal> summaryRecoveryAmount(SalesPlanSummaryDto dto) {
        Map<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dto.getDimen()) || null != SummaryDimensionEunm.codeToEnum((String)dto.getDimen())) {
            return map;
        }
        if (CollectionUtils.isEmpty((Collection)dto.getFormatLsit()) || CollectionUtils.isEmpty((Collection)dto.getUnitLsit()) || CollectionUtils.isEmpty((Collection)dto.getMonthLsit())) {
            return map;
        }
        if (SummaryDimensionEunm.CUSTOMER.getCode().equals(dto.getDimen()) ? CollectionUtils.isEmpty((Collection)dto.getCusLsit()) : (SummaryDimensionEunm.PRODUCT.getCode().equals(dto.getDimen()) ? CollectionUtils.isEmpty((Collection)dto.getProLsit()) : SummaryDimensionEunm.CUSTOMER_PRODUCT.getCode().equals(dto.getDimen()) && (CollectionUtils.isEmpty((Collection)dto.getCusLsit()) || CollectionUtils.isEmpty((Collection)dto.getProLsit())))) {
            return map;
        }
        if (SummaryDimensionEunm.CUSTOMER.getCode().equals(dto.getDimen())) {
            List<SalesPlanEntity> list = this.salesPlanRepository.summaryRecoveryAmountCus(dto, TenantUtils.getTenantCode());
            if (CollectionUtils.isEmpty(list)) {
                return map;
            }
            map = list.stream().collect(Collectors.toMap(i -> i.getBusinessFormatCode() + i.getBusinessUnitCode() + i.getYearMonthLy() + i.getCustomerCode(), SalesPlanEntity::getRestoreQuantity));
        } else if (SummaryDimensionEunm.PRODUCT.getCode().equals(dto.getDimen())) {
            List<SalesPlanEntity> list = this.salesPlanRepository.summaryRecoveryAmountPro(dto, TenantUtils.getTenantCode());
            if (CollectionUtils.isEmpty(list)) {
                return map;
            }
            map = list.stream().collect(Collectors.toMap(i -> i.getBusinessFormatCode() + i.getBusinessUnitCode() + i.getYearMonthLy() + i.getCustomerCode(), SalesPlanEntity::getRestoreQuantity));
        } else if (SummaryDimensionEunm.CUSTOMER_PRODUCT.getCode().equals(dto.getDimen())) {
            List<SalesPlanEntity> list = this.salesPlanRepository.summaryRecoveryAmountCusAndPro(dto, TenantUtils.getTenantCode());
            if (CollectionUtils.isEmpty(list)) {
                return map;
            }
            map = list.stream().collect(Collectors.toMap(i -> i.getBusinessFormatCode() + i.getBusinessUnitCode() + i.getYearMonthLy() + i.getCustomerCode(), SalesPlanEntity::getRestoreQuantity));
        }
        return map;
    }

    public void manualCalPlanAndReply(SalesPlanReCalPlanAndReplyDto dto) {
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u8bf7\u9009\u62e9\u4e1a\u6001", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5355\u5143", (Object[])new Object[0]);
        if (!BusinessUnitEnum.isDefaultBusinessUnit((String)dto.getBusinessUnitCode())) {
            return;
        }
        Validate.notNull((Object)dto.getYearAndMonth(), (String)"\u8bf7\u9009\u62e9\u5e74\u6708", (Object[])new Object[0]);
        dto.setYearMonthLy(DateUtil.dateToStr((Date)dto.getYearAndMonth(), (SimpleDateFormat)DateUtil.date_yyyy_MM));
        Validate.notBlank((CharSequence)dto.getSalesOrgCode(), (String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSalesOrgName(), (String)"\u9500\u552e\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SalesOrgVo salesOrgVo = this.salesOrgVoService.findBySalesOrgCode(dto.getSalesOrgCode());
        Validate.isTrue((null != salesOrgVo && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)salesOrgVo.getSalesOrgLevel()) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u9500\u552e\u7ec4\u7ec7\u4fe1\u606f", (Object[])new Object[0]);
        if (SalesOrgLevelTypeEnum.MECHANISM.getCode().equals(salesOrgVo.getSalesOrgLevel())) {
            dto.setSalesInstitutionCode(salesOrgVo.getSalesOrgCode());
            dto.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
        } else if (SalesOrgLevelTypeEnum.DEPARTMENT.getCode().equals(salesOrgVo.getSalesOrgLevel())) {
            dto.setSalesOrgRegionCode(salesOrgVo.getSalesOrgCode());
            dto.setSalesOrgRegionName(salesOrgVo.getSalesOrgName());
            Validate.notBlank((CharSequence)salesOrgVo.getParentCode(), (String)"\u9500\u552e\u7ec4\u7ec7\u5c42\u7ea7\u4e3a\u9500\u552e\u90e8\u95e8\uff0c\u672a\u67e5\u5230\u4e0a\u7ea7\u9500\u552e\u673a\u6784", (Object[])new Object[0]);
            dto.setSalesInstitutionCode(salesOrgVo.getParentCode());
            dto.setSalesInstitutionName(salesOrgVo.getParentName());
        } else if (SalesOrgLevelTypeEnum.GROUP.getCode().equals(salesOrgVo.getSalesOrgLevel())) {
            dto.setSalesOrgProvinceCode(salesOrgVo.getSalesOrgCode());
            dto.setSalesOrgProvinceName(salesOrgVo.getSalesOrgName());
            Validate.notBlank((CharSequence)salesOrgVo.getParentCode(), (String)"\u9500\u552e\u7ec4\u7ec7\u5c42\u7ea7\u4e3a\u9500\u552e\u7ec4\uff0c\u672a\u67e5\u5230\u4e0a\u7ea7\u9500\u552e\u90e8\u95e8", (Object[])new Object[0]);
            dto.setSalesOrgRegionCode(salesOrgVo.getParentCode());
            dto.setSalesOrgRegionName(salesOrgVo.getParentName());
            SalesOrgVo salesOrgVo2 = this.salesOrgVoService.findBySalesOrgCode(salesOrgVo.getParentCode());
            Validate.notBlank((CharSequence)salesOrgVo.getParentCode(), (String)"\u9500\u552e\u7ec4\u7ec7\u5c42\u7ea7\u4e3a\u9500\u552e\u7ec4\uff0c\u672a\u67e5\u5230\u6700\u4e0a\u7ea7\u9500\u552e\u673a\u6784", (Object[])new Object[0]);
            dto.setSalesInstitutionCode(salesOrgVo.getParentCode());
            dto.setSalesInstitutionName(salesOrgVo.getParentName());
        }
        String key = "month_plan_lock:lock:calDiscount:" + dto.getBusinessFormatCode() + dto.getBusinessUnitCode() + dto.getYearMonthLy() + dto.getSalesInstitutionCode();
        Validate.isTrue((!this.redisLockService.isLock(key) ? 1 : 0) != 0, (String)"\u6b64\u7ef4\u5ea6\u7684\u9500\u552e\u8ba1\u5212\u6b63\u5728\u8ba1\u7b97\u5f53\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c", (Object[])new Object[0]);
        this.salesPlanSyncService.syncCalPlanAndReply(dto);
    }

    public void packageClass(List<SalesPlanEntity> updateList, List<SalesPlanLogEventDto> logList, SalesPlanEntity record, BigDecimal discount) {
        SalesPlanLogEventDto logDto = new SalesPlanLogEventDto();
        SalesPlanDto old = (SalesPlanDto)this.nebulaToolkitService.copyObjectByBlankList((Object)record, SalesPlanDto.class, null, null, new String[0]);
        logDto.setOriginal(old);
        this.calAfterDiscount(record, discount);
        old.setDiscountPlanAmount(record.getDiscountPlanAmount());
        old.setDiscountRestoreAmount(record.getDiscountRestoreAmount());
        old.setDiscountRate(record.getDiscountRate());
        logDto.setNewest(old);
        updateList.add(record);
        logList.add(logDto);
    }

    public void calAfterDiscount(SalesPlanEntity record, BigDecimal discount) {
        if (null != record.getPlanAmount()) {
            if (BigDecimal.ZERO.compareTo(record.getPlanAmount()) == 0) {
                record.setDiscountPlanAmount(BigDecimal.ZERO);
            } else {
                record.setDiscountPlanAmount(record.getPlanAmount().multiply(new BigDecimal(100).subtract(discount)).divide(new BigDecimal(100), 4, 4));
            }
        }
        if (null != record.getRestoreAmount()) {
            if (BigDecimal.ZERO.compareTo(record.getRestoreAmount()) == 0) {
                record.setDiscountRestoreAmount(BigDecimal.ZERO);
            } else {
                record.setDiscountRestoreAmount(record.getRestoreAmount().multiply(new BigDecimal(100).subtract(discount)).divide(new BigDecimal(100), 4, 4));
            }
        }
        record.setDiscountRate(discount);
    }

    private void createValidate(SalesPlanDto dto) {
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setDataFromCode(DataFromEnum.ADD.getCode());
        List<SalesPlanEntity> uniqueness = this.salesPlanRepository.uniqueness(dto);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(uniqueness), (String)"\u552f\u4e00\u6027\u9a8c\u8bc1\u4e0d\u901a\u8fc7,\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u91cd\u590d", (Object[])new Object[0]);
        this.buildData(dto);
    }

    public List<SalesPlanVo> findSalesPlanSumVo(SalesPlanDto queryDto) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)queryDto.getYearMonthLy()) && CollectionUtil.isEmpty((Collection)queryDto.getRegionCodes()) && CollectionUtil.isEmpty((Collection)queryDto.getCustomerRetailerCodeList())) {
            return Collections.emptyList();
        }
        queryDto.setTenantCode(TenantUtils.getTenantCode());
        return this.salesPlanMapper.findSalesPlanSumVo(queryDto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void confirmData(SalesPlanConfirmDto dto) {
        List list = new ArrayList();
        if (BooleanEnum.TRUE.getCapital().equals(dto.getAllCheck())) {
            Pageable pageable = Pageable.ofSize((int)1000);
            SalesPlanDto selectDto = new SalesPlanDto();
            selectDto.setSpecialDataStatus(ConfirmEunm.TOBECONFIRMED.getCode());
            selectDto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
            Page<SalesPlanVo> page = this.findByConditions(pageable, selectDto);
            Optional<Long> total = Optional.ofNullable(page).map(Page::getTotal);
            if (total.isPresent()) {
                list.addAll(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)page.getRecords(), SalesPlanVo.class, SalesPlanEntity.class, HashSet.class, ArrayList.class, new String[0]));
                while (page.hasNext()) {
                    pageable = pageable.next();
                    page = this.findByConditions(pageable, selectDto);
                    list.addAll(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)page.getRecords(), SalesPlanVo.class, SalesPlanEntity.class, HashSet.class, ArrayList.class, new String[0]));
                }
            }
        } else {
            Validate.notEmpty((Collection)dto.getIds(), (String)"\u8bf7\u9009\u62e9\u6570\u636e", (Object[])new Object[0]);
            list = this.salesPlanRepository.listByIds(dto.getIds());
        }
        Validate.notEmpty(list, (String)"\u672a\u627e\u5230\u6570\u636e", (Object[])new Object[0]);
        AbstractCrmUserIdentity userIdentity = this.loginUserService.getAbstractLoginUser();
        Validate.notNull((Object)userIdentity, (String)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u4fe1\u606f", (Object[])new Object[0]);
        for (SalesPlanEntity entity : list) {
            entity.setSpecialDataStatus(ConfirmEunm.COMPLETETHECONFIRMATION.getCode());
            entity.setConfirmedAccount(userIdentity.getAccount());
            entity.setConfirmedName(userIdentity.getRealName());
            entity.setConfirmedOpinion(dto.getConfirmedOpinion());
        }
        List<SalesPlanEntity> mqUpdateList = list.stream().filter(e -> org.apache.commons.lang3.StringUtils.equals((CharSequence)BusinessUnitEnum.SON_COMPANY.getCode(), (CharSequence)e.getBusinessUnitCode())).collect(Collectors.toList());
        this.sendMqMsg(mqUpdateList);
        this.salesPlanRepository.updateBatchById(list);
    }

    private void sendMqMsg(List<SalesPlanEntity> mqUpdateList) {
        if (CollectionUtils.isEmpty(mqUpdateList)) {
            log.error("\u786e\u8ba4\u9500\u552e\u8ba1\u5212\uff1a\u6ca1\u6709\u5206\u5b50\u5355\u5143\u9500\u552e\u8ba1\u5212\uff0c\u4e0d\u66f4\u65b0\uff01");
            return;
        }
        HashSet<String> salesOrgCodeSet = new HashSet<String>();
        ArrayList<SalesPlanEntity> updateList = new ArrayList<SalesPlanEntity>();
        for (SalesPlanEntity entity : mqUpdateList) {
            String salesOrgCode = this.getSalesOrgCode(entity);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)salesOrgCode) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entity.getYearMonthLy())) continue;
            salesOrgCodeSet.add(salesOrgCode);
            updateList.add(entity);
        }
        if (CollectionUtils.isEmpty(updateList)) {
            log.error("\u786e\u8ba4\u9500\u552e\u8ba1\u5212\uff1a\u9500\u552e\u7ec4\u7ec7\u3001\u5e74\u6708\u4e0d\u5168\uff0c\u4e0d\u66f4\u65b0\uff01");
            return;
        }
        List salesOrgAllParentVos = this.salesOrgVoService.findSalesOrgIncludeAllParentByCodes((List)Lists.newArrayList(salesOrgCodeSet));
        Map<String, SalesOrgAllParentVo> salesOrgMap = salesOrgAllParentVos.stream().collect(Collectors.toMap(SalesOrgAllParentVo::getCurrSalesOrgCode, v -> v, (v1, v2) -> v1));
        List salesInstitutionErpCodeList = salesOrgAllParentVos.stream().map(SalesOrgAllParentVo::getSalesInstitutionErpCode).distinct().collect(Collectors.toList());
        List list = this.salesOrgSubComOrgService.listBySalesOrgCodeList(salesInstitutionErpCodeList);
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.error("\u786e\u8ba4\u9500\u552e\u8ba1\u5212\uff1a\u5206\u5b50\u516c\u53f8\u4e0e\u9500\u552e\u673a\u6784\u67e5\u8be2\u8fd4\u56de\u7a7a\uff0c\u4e0d\u66f4\u65b0\uff01");
            return;
        }
        Map relationMap = list.stream().collect(Collectors.groupingBy(SalesOrgSubComOrgVo::getSalesOrgCode, Collectors.mapping(SalesOrgSubComOrgVo::getOrgCode, Collectors.toSet())));
        HashSet<String> keySet = new HashSet<String>();
        for (SalesPlanEntity entity : updateList) {
            String salesOrgCode = this.getSalesOrgCode(entity);
            if (!salesOrgMap.containsKey(salesOrgCode)) {
                log.error("\u786e\u8ba4\u9500\u552e\u8ba1\u5212\uff1a\u9500\u552e\u7ec4\u7ec7{}\u4e0d\u5b58\u5728\uff0c\u4e0d\u66f4\u65b0\uff01", (Object)salesOrgCode);
                continue;
            }
            SalesOrgAllParentVo salesOrgAllParentVo = salesOrgMap.get(salesOrgCode);
            if (!relationMap.containsKey(salesOrgAllParentVo.getSalesInstitutionErpCode())) {
                log.error("\u786e\u8ba4\u9500\u552e\u8ba1\u5212\uff1a\u9500\u552e\u673a\u6784[{}]\u5206\u5b50\u516c\u53f8\u4e0e\u9500\u552e\u673a\u6784\u5173\u7cfb\u4e0d\u5b58\u5728\uff0c\u4e0d\u66f4\u65b0\uff01", (Object)salesOrgAllParentVo.getSalesInstitutionErpCode());
                continue;
            }
            for (String orgCode : relationMap.get(salesOrgAllParentVo.getSalesInstitutionErpCode())) {
                String key = entity.getBusinessFormatCode() + entity.getBusinessUnitCode() + orgCode + entity.getYearMonthLy();
                keySet.add(key);
            }
        }
        if (CollectionUtils.isEmpty(keySet)) {
            log.error("\u786e\u8ba4\u9500\u552e\u8ba1\u5212\uff1a\u66f4\u65b0\u6761\u4ef6\u4e3a\u7a7a\uff0c\u4e0d\u66f4\u65b0\uff01");
            return;
        }
        MqMessageVo mqMessageVo = new MqMessageVo();
        mqMessageVo.setMsgBody(JSONObject.toJSONString(keySet));
        mqMessageVo.setTag("SALES_PLAN_CAL_BUDGET_FORECAST_TAG");
        this.rocketMqProducer.sendMqMsg(mqMessageVo);
    }

    private String getSalesOrgCode(SalesPlanEntity entity) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entity.getSalesInstitutionCode()) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entity.getSalesOrgRegionCode()) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entity.getSalesOrgProvinceCode())) {
            return null;
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entity.getSalesInstitutionCode())) {
            return entity.getSalesInstitutionCode();
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entity.getSalesOrgRegionCode())) {
            return entity.getSalesOrgRegionCode();
        }
        return entity.getSalesOrgProvinceCode();
    }

    public List<SalesPlanDto> convertOrg(List<SalesPlanDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        List filerList = list.stream().filter(e -> org.apache.commons.lang3.StringUtils.equals((CharSequence)BusinessUnitEnum.SON_COMPANY.getCode(), (CharSequence)e.getBusinessUnitCode())).collect(Collectors.toList());
        List salesInstitutionErpCodeList = filerList.stream().map(SalesPlanDto::getSalesInstitutionErpCode).filter(org.apache.commons.lang3.StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(salesInstitutionErpCodeList)) {
            return list;
        }
        List subComOrgVoList = this.salesOrgSubComOrgService.listBySalesOrgCodeList(salesInstitutionErpCodeList);
        if (CollectionUtils.isEmpty((Collection)subComOrgVoList)) {
            return list;
        }
        Map<String, String> map = subComOrgVoList.stream().filter(e -> org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)e.getOrgCode())).collect(Collectors.toMap(SalesOrgSubComOrgVo::getSalesOrgCode, SalesOrgSubComOrgVo::getOrgCode, (v1, v2) -> v1));
        if (CollectionUtils.isEmpty(map)) {
            return list;
        }
        List orgVos = this.orgVoService.findByOrgCodes((List)Lists.newArrayList(map.values()));
        Map<Object, Object> orgNameMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)orgVos)) {
            orgNameMap = orgVos.stream().collect(Collectors.toMap(OrgVo::getOrgCode, OrgVo::getOrgName, (v1, v2) -> v1));
        }
        for (SalesPlanDto salesPlanDto : list) {
            if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)BusinessUnitEnum.SON_COMPANY.getCode(), (CharSequence)salesPlanDto.getBusinessUnitCode()) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)salesPlanDto.getSalesInstitutionErpCode()) || !map.containsKey(salesPlanDto.getSalesInstitutionErpCode())) continue;
            salesPlanDto.setOrgCode(map.get(salesPlanDto.getSalesInstitutionErpCode()));
            salesPlanDto.setOrgName((String)orgNameMap.get(salesPlanDto.getOrgCode()));
        }
        return list;
    }

    public Page<SalesPlanVo> findForSalesVolumeMonitoring(Pageable pageable, SalesPlanDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new SalesPlanDto();
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.salesPlanMapper.findForSalesVolumeMonitoring((Page<SalesPlanVo>)page, dto);
    }

    public Page<SubSaleMonitorVo> subSaleMonitor(Pageable pageable, SalesPlanDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new SalesPlanDto();
        }
        dto.setBusinessUnitCode("DY00000009");
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<SalesPlanVo> salesPlanVoPage = this.salesPlanMapper.findForSalesVolumeMonitoring((Page<SalesPlanVo>)page, dto);
        List records = salesPlanVoPage.getRecords();
        Page resultPage = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (CollectionUtils.isEmpty((Collection)records)) {
            return resultPage;
        }
        ArrayList<SubSaleMonitorVo> list = new ArrayList<SubSaleMonitorVo>();
        ArrayList<TpmSapDaySalesDto> sapDtoList = new ArrayList<TpmSapDaySalesDto>();
        for (SalesPlanVo planVo : records) {
            SubSaleMonitorVo vo = (SubSaleMonitorVo)this.nebulaToolkitService.copyObjectByBlankList((Object)planVo, SubSaleMonitorVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            TpmSapDaySalesDto sapDto = new TpmSapDaySalesDto();
            sapDto.setSpartCode(planVo.getBusinessFormatCode());
            sapDto.setYearMonthLy(planVo.getYearMonthLy().replace("-", ""));
            sapDto.setSalesOrgCode(planVo.getSalesInstitutionErpCode());
            sapDto.setMaterialCode(planVo.getProductCode());
            sapDto.setDealerCode(planVo.getCustomerCode().substring(0, 10));
            sapDtoList.add(sapDto);
            vo.setTheoryGrossProfit(vo.getTheoryIncome().subtract(vo.getTheoryCost()));
            vo.setUniqueKey(sapDto.getDealerCode() + sapDto.getSalesOrgCode() + sapDto.getYearMonthLy() + sapDto.getMaterialCode() + sapDto.getSpartCode());
            list.add(vo);
        }
        List sapVoList = this.tpmSapDaySalesService.findListForSubSaleMonitor(sapDtoList);
        if (!CollectionUtils.isEmpty((Collection)sapVoList)) {
            Map sapMap = sapVoList.stream().collect(Collectors.toMap(e -> e.getUniqueKey(), Function.identity(), (o, n) -> n));
            for (SubSaleMonitorVo vo : list) {
                if (!sapMap.containsKey(vo.getUniqueKey())) continue;
                TpmSapDaySalesVo sapVo = (TpmSapDaySalesVo)sapMap.get(vo.getUniqueKey());
                vo.setDeliveryOrderNum(sapVo.getDeliveryOrderNum());
                vo.setIncomeTaxIncluded(sapVo.getIncomeTaxIncluded());
                vo.setInvoiceAmt(sapVo.getInvoiceAmt());
                vo.setCostTaxIncluded(sapVo.getCostTaxIncluded());
                vo.setActualTheoryGrossProfit(vo.getIncomeTaxIncluded().subtract(vo.getCostTaxIncluded()));
                if (vo.getPlanQuantity().compareTo(BigDecimal.ZERO) != 0) {
                    vo.setSaleReachRate(new BigDecimal(vo.getDeliveryOrderNum()).divide(vo.getPlanQuantity(), 2, RoundingMode.HALF_UP));
                }
                vo.setSaleDiff(new BigDecimal(vo.getDeliveryOrderNum()).subtract(vo.getPlanQuantity()));
                vo.setDiscountBeforeSaleDiff(vo.getIncomeTaxIncluded().subtract(vo.getTheoryIncome()));
                vo.setDiscountAfterSaleDiff(vo.getInvoiceAmt().subtract(vo.getDiscountedIncome()));
                vo.setTheoryCostDiff(vo.getCostTaxIncluded().subtract(vo.getTheoryCost()));
                vo.setTheoryGrossMarginDiff(vo.getActualTheoryGrossProfit().subtract(vo.getTheoryGrossProfit()));
            }
        }
        resultPage.setTotal(salesPlanVoPage.getTotal());
        resultPage.setCountId(salesPlanVoPage.getCountId());
        resultPage.setCurrent(salesPlanVoPage.getCurrent());
        resultPage.setSize(salesPlanVoPage.getSize());
        resultPage.setPages(salesPlanVoPage.getPages());
        resultPage.setRecords(list);
        return resultPage;
    }

    public List<SalesPlanVo> sumReplayReimburse(SalesPlanDto dto) {
        return this.salesPlanRepository.sumReplayReimburse(dto);
    }

    public List<SalesPlanVo> sumReplayRestore(SalesPlanDto dto) {
        return this.salesPlanRepository.sumReplayRestore(dto);
    }

    public List<SalesPlanVo> sumReplayPlan(SalesPlanDto dto) {
        return this.salesPlanRepository.sumReplayPlan(dto);
    }

    public BigDecimal findSaleAmount(SalesPlanDto dto) {
        return this.salesPlanMapper.findSaleAmount(dto);
    }

    public List<SalesPlanVo> findForSaleAndFeeMonitoring(List<SalesPlanDto> dtos) {
        if (CollectionUtils.isEmpty(dtos)) {
            return Lists.newArrayList();
        }
        return this.salesPlanMapper.findForSaleAndFeeMonitoring(dtos);
    }

    public void setSalesOrgCode(SalesPlanEntity entity) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entity.getSalesOrgProvinceCode())) {
            entity.setSalesOrgCode(entity.getSalesOrgProvinceCode());
            entity.setSalesOrgName(entity.getSalesOrgProvinceName());
        } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entity.getSalesOrgRegionCode())) {
            entity.setSalesOrgCode(entity.getSalesOrgRegionCode());
            entity.setSalesOrgName(entity.getSalesOrgRegionName());
        } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entity.getSalesInstitutionCode())) {
            entity.setSalesOrgCode(entity.getSalesInstitutionCode());
            entity.setSalesOrgName(entity.getSalesInstitutionName());
        }
    }
}

