/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.plan.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRatePlanCalDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.enums.DiscountRateVersionEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.service.DiscountRateSdkService;
import com.biz.crm.tpm.business.sales.plan.local.entity.SalesPlanEntity;
import com.biz.crm.tpm.business.sales.plan.local.repository.SalesPlanRepository;
import com.biz.crm.tpm.business.sales.plan.local.service.SalesPlanSyncService;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanLogEventDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanReCalPlanAndReplyDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="SalesPlanSyncService")
public class SalesPlanSyncServiceImpl
implements SalesPlanSyncService {
    private static final Logger log = LoggerFactory.getLogger(SalesPlanSyncServiceImpl.class);
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private SalesPlanRepository salesPlanRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private DiscountRateSdkService discountRateSdkService;

    @Override
    @Async
    public void syncCalPlanAndReply(SalesPlanReCalPlanAndReplyDto dto) {
        String lockKey = "month_plan_lock:lock:calDiscount:" + dto.getBusinessFormatCode() + dto.getBusinessUnitCode() + DateUtil.dateToStr((Date)dto.getYearAndMonth(), (SimpleDateFormat)DateUtil.date_yyyy_MM) + dto.getSalesInstitutionCode();
        boolean hasLock = false;
        try {
            Page<SalesPlanEntity> pageResult;
            hasLock = this.redisLockService.tryLock(lockKey, TimeUnit.SECONDS, 1800L);
            if (!hasLock) {
                throw new RuntimeException("\u6b64\u7ef4\u5ea6\u7684\u9500\u552e\u8ba1\u5212\u6b63\u5728\u8ba1\u7b97\u5f53\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
            }
            Page page = new Page(1L, 500L);
            while (!CollectionUtils.isEmpty((Collection)(pageResult = this.salesPlanRepository.findSalesPlanByConditions((Page<SalesPlanEntity>)page, dto)).getRecords())) {
                log.info("\u624b\u52a8\u8ba1\u7b97\u6298\u540e\u8ba1\u5212\u91cf\u548c\u56de\u590d\u91cf,pageNum:{},\u603b\u6761\u6570:{}", (Object)pageResult.getCurrent(), (Object)pageResult.getTotal());
                HashSet<String> cusProCodeSet = new HashSet<String>();
                HashSet<String> cusCodeSet = new HashSet<String>();
                for (SalesPlanEntity record : pageResult.getRecords()) {
                    if (StringUtils.isNotBlank((CharSequence)record.getCustomerCode()) && StringUtils.isNotBlank((CharSequence)record.getProductCode())) {
                        cusProCodeSet.add(record.getCustomerCode() + record.getProductCode());
                        cusCodeSet.add(record.getCustomerCode());
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)record.getCustomerCode())) {
                        cusCodeSet.add(record.getCustomerCode());
                        log.info("\u624b\u52a8\u8ba1\u7b97\u6298\u540e\u8ba1\u5212\u91cf\u548c\u56de\u590d\u91cf,\u53ea\u6709\u5ba2\u6237\u7f16\u7801\u3002\u9500\u552e\u8ba1\u5212id:{}", (Object)record.getId());
                        continue;
                    }
                    log.info("\u624b\u52a8\u8ba1\u7b97\u6298\u540e\u8ba1\u5212\u91cf\u548c\u56de\u590d\u91cf,\u65e0\u5ba2\u6237\u548c\u4ea7\u54c1\u7f16\u7801\u3002\u9500\u552e\u8ba1\u5212id:{}", (Object)record.getId());
                }
                log.info("\u624b\u52a8\u8ba1\u7b97\u6298\u540e\u8ba1\u5212\u91cf\u548c\u56de\u590d\u91cf,pageNum:{},cusProCodeSet.size:{}", (Object)pageResult.getCurrent(), (Object)cusProCodeSet.size());
                if (cusProCodeSet.isEmpty() && cusCodeSet.isEmpty()) continue;
                Map<Object, Object> ratesMap1 = new HashMap();
                if (!cusProCodeSet.isEmpty()) {
                    DiscountRatePlanCalDto planCalDto1 = new DiscountRatePlanCalDto();
                    planCalDto1.setBusinessFormatCode(dto.getBusinessFormatCode());
                    planCalDto1.setBusinessUnitCode(dto.getBusinessUnitCode());
                    planCalDto1.setYearAndMonth(dto.getYearAndMonth());
                    planCalDto1.setTenantCode(TenantUtils.getTenantCode());
                    planCalDto1.setCusProCodes(new ArrayList(cusProCodeSet));
                    List rates1 = this.discountRateSdkService.findRateByPlanConditions(planCalDto1);
                    if (!CollectionUtils.isEmpty((Collection)rates1)) {
                        ratesMap1 = rates1.stream().collect(Collectors.groupingBy(i -> i.getCustomerCode() + i.getProductCode(), Collectors.toMap(DiscountRateDto::getRateVersion, Function.identity())));
                    }
                }
                Map<Object, Object> ratesMap2 = new HashMap();
                if (!cusCodeSet.isEmpty()) {
                    DiscountRatePlanCalDto planCalDto2 = new DiscountRatePlanCalDto();
                    planCalDto2.setBusinessFormatCode(dto.getBusinessFormatCode());
                    planCalDto2.setBusinessUnitCode(dto.getBusinessUnitCode());
                    planCalDto2.setYearAndMonth(dto.getYearAndMonth());
                    planCalDto2.setTenantCode(TenantUtils.getTenantCode());
                    planCalDto2.setCusCodes(new ArrayList(cusCodeSet));
                    List rates2 = this.discountRateSdkService.findRateByPlanConditions(planCalDto2);
                    if (!CollectionUtils.isEmpty((Collection)rates2)) {
                        ratesMap2 = rates2.stream().collect(Collectors.groupingBy(DiscountRateDto::getCustomerCode, Collectors.toMap(DiscountRateDto::getRateVersion, Function.identity())));
                    }
                }
                ArrayList<SalesPlanEntity> updateList = new ArrayList<SalesPlanEntity>();
                ArrayList<SalesPlanLogEventDto> logList = new ArrayList<SalesPlanLogEventDto>();
                for (SalesPlanEntity record : pageResult.getRecords()) {
                    if (StringUtils.isBlank((CharSequence)record.getCustomerCode())) continue;
                    if (StringUtils.isNotBlank((CharSequence)record.getProductCode())) {
                        Map map;
                        String key = record.getCustomerCode() + record.getProductCode();
                        if (ratesMap1.containsKey(key)) {
                            map = (Map)ratesMap1.get(key);
                            if (map.containsKey(DiscountRateVersionEnum.CORRECTION.getCode())) {
                                this.packageClass(updateList, logList, record, ((DiscountRateDto)map.get(DiscountRateVersionEnum.CORRECTION.getCode())).getPlanRate());
                                continue;
                            }
                            if (!map.containsKey(DiscountRateVersionEnum.PLAN.getCode())) continue;
                            this.packageClass(updateList, logList, record, ((DiscountRateDto)map.get(DiscountRateVersionEnum.PLAN.getCode())).getPlanRate());
                            continue;
                        }
                        if (ratesMap2.containsKey(record.getCustomerCode())) {
                            map = (Map)ratesMap2.get(record.getCustomerCode());
                            if (map.containsKey(DiscountRateVersionEnum.CORRECTION.getCode())) {
                                this.packageClass(updateList, logList, record, ((DiscountRateDto)map.get(DiscountRateVersionEnum.CORRECTION.getCode())).getPlanRate());
                                continue;
                            }
                            if (!map.containsKey(DiscountRateVersionEnum.PLAN.getCode())) continue;
                            this.packageClass(updateList, logList, record, ((DiscountRateDto)map.get(DiscountRateVersionEnum.PLAN.getCode())).getPlanRate());
                            continue;
                        }
                        this.packageClass(updateList, logList, record, BigDecimal.ZERO);
                        continue;
                    }
                    if (ratesMap2.containsKey(record.getCustomerCode())) {
                        Map map = (Map)ratesMap2.get(record.getCustomerCode());
                        if (map.containsKey(DiscountRateVersionEnum.CORRECTION.getCode())) {
                            this.packageClass(updateList, logList, record, ((DiscountRateDto)map.get(DiscountRateVersionEnum.CORRECTION.getCode())).getPlanRate());
                            continue;
                        }
                        if (!map.containsKey(DiscountRateVersionEnum.PLAN.getCode())) continue;
                        this.packageClass(updateList, logList, record, ((DiscountRateDto)map.get(DiscountRateVersionEnum.PLAN.getCode())).getPlanRate());
                        continue;
                    }
                    this.packageClass(updateList, logList, record, BigDecimal.ZERO);
                }
                if (!CollectionUtils.isEmpty(updateList)) {
                    this.salesPlanRepository.updateBatchById(updateList);
                }
                page.setCurrent(page.getCurrent() + 1L);
            }
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u65b9\u6cd5\u8ba1\u7b97\u6298\u540e\u91d1\u989d\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw e;
        }
        finally {
            if (hasLock) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    public void packageClass(List<SalesPlanEntity> updateList, List<SalesPlanLogEventDto> logList, SalesPlanEntity record, BigDecimal discount) {
        SalesPlanLogEventDto logDto = new SalesPlanLogEventDto();
        SalesPlanDto old = (SalesPlanDto)this.nebulaToolkitService.copyObjectByBlankList((Object)record, SalesPlanDto.class, null, null, new String[0]);
        logDto.setOriginal(old);
        this.calAfterDiscount(record, discount);
        old.setDiscountPlanAmount(record.getDiscountPlanAmount());
        old.setDiscountRestoreAmount(record.getDiscountRestoreAmount());
        old.setDiscountRate(record.getDiscountRate());
        logDto.setNewest(old);
        updateList.add(record);
        logList.add(logDto);
    }

    public void calAfterDiscount(SalesPlanEntity record, BigDecimal discount) {
        if (null != record.getPlanAmount()) {
            if (BigDecimal.ZERO.compareTo(record.getPlanAmount()) == 0) {
                record.setDiscountPlanAmount(BigDecimal.ZERO);
            } else {
                record.setDiscountPlanAmount(record.getPlanAmount().multiply(new BigDecimal(1).subtract(discount)).setScale(2, 4));
            }
        }
        if (null != record.getRestoreAmount()) {
            if (BigDecimal.ZERO.compareTo(record.getRestoreAmount()) == 0) {
                record.setDiscountRestoreAmount(BigDecimal.ZERO);
            } else {
                record.setDiscountRestoreAmount(record.getRestoreAmount().multiply(new BigDecimal(1).subtract(discount)).setScale(2, 4));
            }
        }
        record.setShippingDiscountRate(discount);
    }
}

