/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.plan.local.service.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.DataFromEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanHeadImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SalesPlanHeadImportsProcess
implements ImportProcess<SalesPlanHeadImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(SalesPlanHeadImportsProcess.class);
    @Resource
    private ProductVoService productVoService;
    @Resource
    private SalesOrgVoService salesOrgVoService;
    @Resource
    private CustomerVoService customerVoService;
    @Resource
    private SalesPlanService salesPlanService;
    @Resource
    private DictToolkitService dictToolkitService;
    @Resource
    private NebulaToolkitService nebulaToolkitService;
    private Map<String, String> mdmBusinessFormatMap = new HashMap<String, String>();
    private Map<String, String> mdmBusinessUnitMap = new HashMap<String, String>();
    private Map<String, CustomerVo> customerVoMap = new HashMap<String, CustomerVo>();
    private Map<String, ProductVo> productVoMap = new HashMap<String, ProductVo>();
    private Map<String, SalesOrgVo> salesOrgVoMap = new HashMap<String, SalesOrgVo>();

    public Map<Integer, String> execute(LinkedHashMap<Integer, SalesPlanHeadImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        try {
            Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            List<SalesPlanDto> importList = this.validate(data, errMap);
            if (errMap.isEmpty()) {
                this.salesPlanService.importSave(importList);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            errMap.put(1, errMap.getOrDefault(1, "") + " | " + e.getMessage());
        }
        return errMap;
    }

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    private List<SalesPlanDto> validate(LinkedHashMap<Integer, SalesPlanHeadImportsVo> data, Map<Integer, String> errMap) {
        ArrayList<SalesPlanHeadImportsVo> salesPlanHeadImportsVos = new ArrayList<SalesPlanHeadImportsVo>(data.values());
        this.buildBaseMap(salesPlanHeadImportsVos);
        int index = 1;
        for (SalesPlanHeadImportsVo importsVo : salesPlanHeadImportsVos) {
            this.validateNull(importsVo, errMap, ++index);
            this.buildBaseData(importsVo, errMap, index);
            this.buildDecimal(importsVo, errMap, index);
        }
        Collection salesPlanDtoList = this.nebulaToolkitService.copyCollectionByWhiteList(salesPlanHeadImportsVos, SalesPlanHeadImportsVo.class, SalesPlanDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new ArrayList<SalesPlanDto>(salesPlanDtoList);
    }

    private void validateNull(SalesPlanHeadImportsVo importsVo, Map<Integer, String> errMap, int index) {
        String errorInfo;
        if (StringUtils.isEmpty((CharSequence)importsVo.getVersionNumber())) {
            this.validateIsTrue(false, "\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        } else {
            this.validateIsTrue(DateUtil.isValidDateNotLine((String)importsVo.getVersionNumber()), "\u7248\u672c\u53f7\u683c\u5f0f\u6709\u8bef\uff0c\u4f8b20230823");
        }
        if (StringUtils.isEmpty((CharSequence)importsVo.getBusinessFormatCode())) {
            this.validateIsTrue(false, "\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)importsVo.getBusinessUnitCode())) {
            this.validateIsTrue(false, "\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)importsVo.getYearMonthLy())) {
            this.validateIsTrue(false, "\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)importsVo.getCustomerCode())) {
            this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)importsVo.getProductCode())) {
            this.validateIsTrue(false, "\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)importsVo.getPlanQuantityStr())) {
            this.validateIsTrue(false, "\u8ba1\u5212\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)importsVo.getPlanAmountStr())) {
            this.validateIsTrue(false, "\u6298\u524d\u8ba1\u5212\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)importsVo.getDiscountPlanAmountStr())) {
            this.validateIsTrue(false, "\u6298\u540e\u8ba1\u5212\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)importsVo.getRestoreQuantityStr())) {
            this.validateIsTrue(false, "\u56de\u590d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)importsVo.getRestoreAmountStr())) {
            this.validateIsTrue(false, "\u6298\u524d\u56de\u590d\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)importsVo.getDiscountRestoreAmountStr())) {
            this.validateIsTrue(false, "\u6298\u540e\u56de\u590d\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if ((errorInfo = this.validateGetErrorInfo()) != null) {
            if (errMap.containsKey(index)) {
                errMap.put(index, errMap.getOrDefault(index, "") + "," + errorInfo);
            } else {
                errMap.put(index, errorInfo);
            }
        }
    }

    public void testValidate(List<SalesPlanHeadImportsVo> salesPlanHeadImportsVos) {
        HashMap errMap = new HashMap();
        int index = 0;
        this.buildBaseMap(salesPlanHeadImportsVos);
        salesPlanHeadImportsVos.forEach(importsVo -> {
            this.buildBaseData((SalesPlanHeadImportsVo)importsVo, errMap, index);
            this.buildDecimal((SalesPlanHeadImportsVo)importsVo, errMap, index);
        });
    }

    private void buildDecimal(SalesPlanHeadImportsVo importsVo, Map<Integer, String> errMap, int index) {
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getPlanQuantityStr())) {
                importsVo.setPlanQuantity(new BigDecimal(importsVo.getPlanQuantityStr()));
            }
        }
        catch (Exception e) {
            this.validateIsTrue(false, "\u6298\u524d\u8ba1\u5212\u91cf" + importsVo.getPlanQuantityStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getPlanAmountStr())) {
                importsVo.setPlanQuantity(new BigDecimal(importsVo.getPlanAmountStr()));
            }
        }
        catch (Exception e) {
            this.validateIsTrue(false, "\u6298\u524d\u8ba1\u5212\u91d1\u989d" + importsVo.getPlanAmountStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getDiscountPlanAmountStr())) {
                importsVo.setDiscountPlanAmount(new BigDecimal(importsVo.getDiscountPlanAmountStr()));
            }
        }
        catch (Exception e) {
            this.validateIsTrue(false, "\u6298\u540e\u8ba1\u5212\u91d1\u989d" + importsVo.getDiscountPlanAmountStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getRestoreQuantityStr())) {
                importsVo.setRestoreQuantity(new BigDecimal(importsVo.getRestoreQuantityStr()));
            }
        }
        catch (Exception e) {
            this.validateIsTrue(false, "\u56de\u590d\u6570\u91cf" + importsVo.getRestoreQuantityStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getRestoreAmountStr())) {
                importsVo.setRestoreAmount(new BigDecimal(importsVo.getRestoreAmountStr()));
            }
        }
        catch (Exception e) {
            this.validateIsTrue(false, "\u6298\u524d\u56de\u590d\u91d1\u989d" + importsVo.getRestoreAmountStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getDiscountPlanAmountStr())) {
                importsVo.setDiscountPlanAmount(new BigDecimal(importsVo.getDiscountPlanAmountStr()));
            }
        }
        catch (Exception e) {
            this.validateIsTrue(false, "\u6298\u540e\u56de\u590d\u91d1\u989d" + importsVo.getDiscountPlanAmountStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        String errorInfo = this.validateGetErrorInfo();
        if (errorInfo != null) {
            if (errMap.containsKey(index)) {
                errMap.put(index, errMap.get(index) + "," + errorInfo);
            } else {
                errMap.put(index, errorInfo);
            }
        }
    }

    private void buildBaseData(SalesPlanHeadImportsVo importsVo, Map<Integer, String> errMap, int index) {
        String errorInfo;
        importsVo.setDataFromCode(DataFromEnum.IMPORT.getCode());
        if (!StringUtils.isEmpty((CharSequence)importsVo.getBusinessFormatCode())) {
            if (!this.mdmBusinessFormatMap.containsKey(importsVo.getBusinessFormatCode())) {
                this.validateIsTrue(false, "\u4e1a\u6001 + importsVo.getBusinessFormatCode() + \u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            } else {
                importsVo.setBusinessFormatCode(this.mdmBusinessFormatMap.get(importsVo.getBusinessFormatCode()));
            }
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getBusinessUnitCode())) {
            if (!this.mdmBusinessUnitMap.containsKey(importsVo.getBusinessUnitCode())) {
                this.validateIsTrue(false, "\u4e1a\u52a1\u5355\u5143" + importsVo.getBusinessUnitCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            } else {
                importsVo.setBusinessUnitCode(this.mdmBusinessUnitMap.get(importsVo.getBusinessUnitCode()));
            }
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getYearMonthLy())) {
            try {
                DateUtil.parseDate((String)importsVo.getYearMonthLy(), (String)"yyyy-MM");
            }
            catch (Exception ignored) {
                this.validateIsTrue(false, "\u5e74\u6708" + importsVo.getYearMonthLy() + "\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u8be5\u4e3a" + "yyyy-MM");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getSalesInstitutionCode())) {
            if (!this.salesOrgVoMap.containsKey(importsVo.getSalesInstitutionCode())) {
                this.validateIsTrue(false, "\u9500\u552e\u673a\u6784" + importsVo.getSalesInstitutionCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            } else {
                importsVo.setSalesInstitutionName(this.salesOrgVoMap.get(importsVo.getSalesInstitutionCode()).getSalesOrgName());
                importsVo.setSalesInstitutionErpCode(this.salesOrgVoMap.get(importsVo.getSalesInstitutionCode()).getErpCode());
            }
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getSalesOrgRegionCode())) {
            if (!this.salesOrgVoMap.containsKey(importsVo.getSalesOrgRegionCode())) {
                this.validateIsTrue(false, "\u9500\u552e\u7ec4\u7ec7\uff08\u5927\u533a\uff09" + importsVo.getSalesOrgRegionCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            } else {
                importsVo.setSalesOrgRegionName(this.salesOrgVoMap.get(importsVo.getSalesOrgRegionCode()).getSalesOrgName());
                importsVo.setSalesOrgRegionErpCode(this.salesOrgVoMap.get(importsVo.getSalesOrgRegionCode()).getErpCode());
            }
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getSalesOrgProvinceCode())) {
            if (!this.salesOrgVoMap.containsKey(importsVo.getSalesOrgProvinceCode())) {
                this.validateIsTrue(false, "\u9500\u552e\u7ec4\uff08\u7701\u533a\uff09" + importsVo.getSalesOrgProvinceCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            } else {
                importsVo.setSalesOrgProvinceName(this.salesOrgVoMap.get(importsVo.getSalesOrgProvinceCode()).getSalesOrgName());
                importsVo.setSalesOrgProvinceErpCode(this.salesOrgVoMap.get(importsVo.getSalesOrgProvinceCode()).getErpCode());
            }
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getCustomerCode())) {
            if (this.customerVoMap.containsKey(importsVo.getCustomerCode())) {
                importsVo.setCustomerName(this.customerVoMap.get(importsVo.getCustomerCode()).getCustomerName());
            } else {
                this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801" + importsVo.getCustomerCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getProductCode())) {
            if (this.productVoMap.containsKey(importsVo.getProductCode())) {
                importsVo.setProductName(this.productVoMap.get(importsVo.getProductCode()).getProductName());
                importsVo.setTaxRate(this.productVoMap.get(importsVo.getProductCode()).getRate());
            } else {
                this.validateIsTrue(false, "\u4ea7\u54c1\u7f16\u7801" + importsVo.getProductCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if ((errorInfo = this.validateGetErrorInfo()) != null) {
            if (errMap.containsKey(index)) {
                errMap.put(index, errMap.get(index) + "," + errorInfo);
            } else {
                errMap.put(index, errorInfo);
            }
        }
    }

    private void buildBaseMap(List<SalesPlanHeadImportsVo> salesPlanHeadImportsVos) {
        List productVoList;
        List customerVos;
        List salesOrgVos;
        this.mdmBusinessFormatMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_format");
        this.mdmBusinessUnitMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_unit");
        Set salesOrgCodeSet = salesPlanHeadImportsVos.stream().map(SalesPlanHeadImportsVo::getSalesInstitutionCode).filter(Objects::nonNull).collect(Collectors.toSet());
        salesOrgCodeSet.addAll(salesPlanHeadImportsVos.stream().map(SalesPlanHeadImportsVo::getSalesOrgRegionCode).filter(Objects::nonNull).collect(Collectors.toSet()));
        salesOrgCodeSet.addAll(salesPlanHeadImportsVos.stream().map(SalesPlanHeadImportsVo::getSalesOrgProvinceCode).filter(Objects::nonNull).collect(Collectors.toSet()));
        Set customerCodeSet = salesPlanHeadImportsVos.stream().map(SalesPlanHeadImportsVo::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set productCodeSet = salesPlanHeadImportsVos.stream().map(SalesPlanHeadImportsVo::getProductCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set yearMonthSet = salesPlanHeadImportsVos.stream().map(SalesPlanHeadImportsVo::getYearMonthLy).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(salesOrgCodeSet) && !CollectionUtils.isEmpty((Collection)(salesOrgVos = this.salesOrgVoService.findBySalesOrgCodes(new ArrayList(salesOrgCodeSet))))) {
            this.salesOrgVoMap = salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
        }
        if (!CollectionUtils.isEmpty(customerCodeSet) && !CollectionUtils.isEmpty((Collection)(customerVos = this.customerVoService.findBaseByCustomerCodes(new ArrayList(customerCodeSet))))) {
            this.customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        }
        if (!CollectionUtils.isEmpty(productCodeSet) && !CollectionUtils.isEmpty((Collection)(productVoList = this.productVoService.findByCodes(new ArrayList(productCodeSet))))) {
            this.productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
        }
    }

    public Class<SalesPlanHeadImportsVo> findCrmExcelVoClass() {
        return SalesPlanHeadImportsVo.class;
    }

    public String getBusinessCode() {
        return "TPM_SALES_PLAN_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u9500\u552e\u8ba1\u5212\u5bfc\u5165";
    }

    public String getTemplateCode() {
        return "TPM_SALES_PLAN_HEAD_IMPORT";
    }

    public String getTemplateName() {
        return "TPM\u9500\u552e\u8ba1\u5212\u4e3b\u4f53\u5bfc\u5165";
    }
}

