/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.plan.local.service.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.enums.ProductLevelEnum;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.DataFromEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionInformationQueryData;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.enmus.MenuCodeEnum;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionDimensionInformationService;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionDimensionInformationVo;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.eunm.BudgetAmountTypeEnum;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.service.ProfitGoalDiscountService;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.vo.ProfitGoalDiscountVo;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanSubCompanyImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class SalesPlanSubCompanyImportsProcess
implements ImportProcess<SalesPlanSubCompanyImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(SalesPlanSubCompanyImportsProcess.class);
    @Resource
    private OrgVoService orgVoService;
    @Resource
    private ProductVoService productVoService;
    @Resource
    private SalesOrgVoService salesOrgVoService;
    @Resource
    private CustomerChannelVoService customerChannelVoService;
    @Resource
    private MdmTerminalChannelVoService mdmTerminalChannelVoService;
    @Resource
    private ProductBrandService productBrandService;
    @Resource
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Resource
    private CustomerVoService customerVoService;
    @Resource
    private TerminalVoService terminalVoService;
    @Resource
    private SalesPlanService salesPlanService;
    @Resource
    private DictDataVoService dictDataVoService;
    @Resource
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ProfitGoalDiscountService profitGoalDiscountService;
    @Autowired(required=false)
    private DimensionDimensionInformationService dimensionDimensionInformationService;
    @Autowired
    private SalesOrgSubComOrgService salesOrgSubComOrgService;

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, SalesPlanSubCompanyImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        HashMap dictMapMap = Maps.newHashMap();
        HashMap<String, CustomerVo> customerVoMap = new HashMap<String, CustomerVo>();
        HashMap<String, TerminalVo> terminalVoMap = new HashMap<String, TerminalVo>();
        HashMap<String, ProductVo> productVoMap = new HashMap<String, ProductVo>();
        HashMap<String, SalesOrgVo> salesOrgVoMap = new HashMap<String, SalesOrgVo>();
        HashMap<String, CustomerChannelVo> customerChannelVoMap = new HashMap<String, CustomerChannelVo>();
        HashMap<String, MdmTerminalChannelVo> terminalChannelVoMap = new HashMap<String, MdmTerminalChannelVo>();
        HashMap<String, ProductBrandVo> productBrandVoMap = new HashMap<String, ProductBrandVo>();
        HashMap<String, ProductLevelVo> productCategoryVoMap = new HashMap<String, ProductLevelVo>();
        HashMap<String, ProductLevelVo> productItemVoMap = new HashMap<String, ProductLevelVo>();
        HashMap<String, ProfitGoalDiscountVo> profitGoalDiscountVoMap = new HashMap<String, ProfitGoalDiscountVo>();
        HashMap<String, OrgVo> orgVoMap = new HashMap<String, OrgVo>();
        HashMap<String, String> salesOrgErpMap = new HashMap<String, String>();
        HashMap<String, String> erpOrgMap = new HashMap<String, String>();
        HashMap<String, ProfitGoalDiscountVo> outDiscountRatioMap = new HashMap<String, ProfitGoalDiscountVo>();
        List importList = this.validate(outDiscountRatioMap, data, dictMapMap, customerVoMap, terminalVoMap, productVoMap, salesOrgVoMap, customerChannelVoMap, terminalChannelVoMap, productBrandVoMap, productCategoryVoMap, productItemVoMap, profitGoalDiscountVoMap, orgVoMap, salesOrgErpMap, erpOrgMap, errMap);
        if (errMap.isEmpty()) {
            importList = this.salesPlanService.convertOrg(importList);
            this.salesPlanService.importSave(importList);
        }
        return errMap;
    }

    private List<SalesPlanDto> validate(Map<String, ProfitGoalDiscountVo> outDiscountRatioMap, LinkedHashMap<Integer, SalesPlanSubCompanyImportsVo> data, Map<String, Map<String, String>> dictMapMap, Map<String, CustomerVo> customerVoMap, Map<String, TerminalVo> terminalVoMap, Map<String, ProductVo> productVoMap, Map<String, SalesOrgVo> salesOrgVoMap, Map<String, CustomerChannelVo> customerChannelVoMap, Map<String, MdmTerminalChannelVo> terminalChannelVoMap, Map<String, ProductBrandVo> productBrandVoMap, Map<String, ProductLevelVo> productCategoryVoMap, Map<String, ProductLevelVo> productItemVoMap, Map<String, ProfitGoalDiscountVo> profitGoalDiscountVoMap, Map<String, OrgVo> orgVoMap, Map<String, String> salesOrgErpMap, Map<String, String> erpOrgMap, Map<Integer, String> errMap) {
        try {
            this.buildBaseMap(outDiscountRatioMap, data, dictMapMap, customerVoMap, terminalVoMap, productVoMap, salesOrgVoMap, customerChannelVoMap, terminalChannelVoMap, productBrandVoMap, productCategoryVoMap, productItemVoMap, profitGoalDiscountVoMap, orgVoMap, salesOrgErpMap, erpOrgMap, errMap);
            if (!errMap.isEmpty()) {
                return new ArrayList<SalesPlanDto>();
            }
            for (Map.Entry<Integer, SalesPlanSubCompanyImportsVo> row : data.entrySet()) {
                int rowNum = row.getKey();
                this.buildBaseData(row.getValue(), dictMapMap, customerVoMap, terminalVoMap, productVoMap, salesOrgVoMap, customerChannelVoMap, terminalChannelVoMap, productBrandVoMap, productCategoryVoMap, productItemVoMap, profitGoalDiscountVoMap, orgVoMap, salesOrgErpMap, erpOrgMap);
                this.buildDecimal(row.getValue(), outDiscountRatioMap, salesOrgErpMap, erpOrgMap);
                String errInfo = this.validateGetErrorInfo();
                if (errInfo != null) {
                    errMap.put(rowNum, errInfo);
                    continue;
                }
                this.calculateData(row.getValue());
            }
            this.buildCustomer(data, customerVoMap, errMap);
            if (!errMap.isEmpty()) {
                return new ArrayList<SalesPlanDto>();
            }
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException || e instanceof NullPointerException || e instanceof IndexOutOfBoundsException) {
                throw e;
            }
            log.error("\u9500\u552e\u8ba1\u5212(\u5206\u5b50\u516c\u53f8)\u5bfc\u5165,\u9519\u8bef\u4fe1\u606f={}", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        Collection salesPlanDtoList = this.nebulaToolkitService.copyCollectionByWhiteList(data.values(), SalesPlanSubCompanyImportsVo.class, SalesPlanDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new ArrayList<SalesPlanDto>(salesPlanDtoList);
    }

    private void buildCustomer(LinkedHashMap<Integer, SalesPlanSubCompanyImportsVo> data, Map<String, CustomerVo> customerVoMap, Map<Integer, String> errMap) {
        List customerVos;
        HashSet customerCodeSet = Sets.newHashSet();
        data.values().forEach(item -> customerCodeSet.add(item.getCustomerCode() + item.getSalesInstitutionErpCode() + item.getCustomerChannelCode() + item.getBusinessFormatCode()));
        if (!CollectionUtils.isEmpty((Collection)customerCodeSet) && !CollectionUtils.isEmpty((Collection)(customerVos = this.customerVoService.findBaseByCustomerCodes(new ArrayList(customerCodeSet))))) {
            customerVoMap.putAll(customerVos.stream().collect(Collectors.toMap(CustomerVo::getErpCode, Function.identity())));
        }
        for (Map.Entry<Integer, SalesPlanSubCompanyImportsVo> row : data.entrySet()) {
            String errInfo;
            int rowNum = row.getKey();
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)row.getValue().getCustomerCode())) {
                if (customerVoMap.containsKey(row.getValue().getCustomerCode())) {
                    CustomerVo customerVo = customerVoMap.get(row.getValue().getCustomerCode());
                    row.getValue().setCustomerName(customerVo.getCustomerName());
                    row.getValue().setCustomerCode(customerVo.getCustomerCode());
                    row.getValue().setErpCode(customerVo.getErpCode());
                } else {
                    throw new IllegalArgumentException("\u5ba2\u6237\u7f16\u7801" + row.getValue().getCustomerCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            }
            if ((errInfo = this.validateGetErrorInfo()) == null) continue;
            errMap.put(rowNum, errInfo);
        }
    }

    private void baseCheck(SalesPlanSubCompanyImportsVo importsVo) {
        this.validateIsTrue(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)importsVo.getBusinessFormatCode()), "\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateIsTrue(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)importsVo.getBusinessUnitCode()), "\u4e1a\u52a1\u5355\u5143\u80fd\u4e3a\u7a7a");
        this.validateIsTrue(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)importsVo.getYearMonthLy()), "\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateIsTrue(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)importsVo.getGroupCode()), "\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateIsTrue(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)importsVo.getSalesInstitutionCode()), "\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateIsTrue(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)importsVo.getCustomerChannelCode()), "\u5ba2\u6237\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateIsTrue(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)importsVo.getCustomerChannelName()), "\u5ba2\u6237\u6e20\u9053\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateIsTrue(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)importsVo.getCustomerCode()), "\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateIsTrue(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)importsVo.getCustomerName()), "\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateIsTrue(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)importsVo.getUnitCode()), "\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateIsTrue(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)importsVo.getUnitName()), "\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateIsTrue(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)importsVo.getPlanQuantityStr()), "\u8ba1\u5212\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateIsTrue(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)importsVo.getCifPriceStr()), "\u5230\u5cb8\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateIsTrue(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)importsVo.getStandardSupplyPriceStr()), "\u6807\u51c6\u4f9b\u8d27\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void calculateData(SalesPlanSubCompanyImportsVo importsVo) {
        String saleOrgErpCode;
        List subComOrgVos;
        BigDecimal beforeDiscount = importsVo.getPlanQuantity().multiply(importsVo.getStandardSupplyPrice()).setScale(6, 4);
        importsVo.setTheoryIncome(beforeDiscount);
        BigDecimal theoryCost = importsVo.getPlanQuantity().multiply(importsVo.getCifPrice()).setScale(6, 4);
        importsVo.setTheoryCost(theoryCost);
        BigDecimal discountRate = importsVo.getDiscountRate();
        BigDecimal shippingDiscountRate = importsVo.getShippingDiscountRate();
        BigDecimal discountedIncome = beforeDiscount.multiply(BigDecimal.ONE.subtract(shippingDiscountRate)).setScale(6, 4);
        importsVo.setDiscountedIncome(discountedIncome);
        BigDecimal discountedCost = theoryCost.multiply(BigDecimal.ONE.subtract(discountRate)).setScale(6, 4);
        importsVo.setDiscountedCost(discountedCost);
        BigDecimal bigDecimal1 = beforeDiscount.divide(BigDecimal.ONE.add(importsVo.getTaxRate()), 6, 4).multiply(importsVo.getTaxRate()).setScale(6, 4);
        BigDecimal bigDecimal2 = beforeDiscount.multiply(shippingDiscountRate).divide(BigDecimal.ONE.add(importsVo.getTaxRate()), 6, 4).multiply(importsVo.getTaxRate()).setScale(6, 4);
        BigDecimal bigDecimal3 = theoryCost.divide(BigDecimal.ONE.add(importsVo.getTaxRate()), 6, 4).multiply(importsVo.getTaxRate()).setScale(6, 4);
        BigDecimal bigDecimal4 = theoryCost.multiply(discountRate).divide(BigDecimal.ONE.add(importsVo.getTaxRate()), 6, 4).multiply(importsVo.getTaxRate()).setScale(6, 4);
        BigDecimal vat = bigDecimal1.subtract(bigDecimal2).subtract(bigDecimal3).add(bigDecimal4);
        importsVo.setVat(vat);
        BigDecimal vatRate = BigDecimal.ZERO;
        String salesInstitutionCode = importsVo.getSalesInstitutionCode();
        if (StringUtils.hasText((String)salesInstitutionCode) && !CollectionUtils.isEmpty((Collection)(subComOrgVos = this.salesOrgSubComOrgService.findBySaleOrgErpCode(saleOrgErpCode = salesInstitutionCode.substring(salesInstitutionCode.length() - 4, salesInstitutionCode.length()))))) {
            SalesOrgSubComOrgVo salesOrgSubComOrgVo = (SalesOrgSubComOrgVo)subComOrgVos.get(0);
            vatRate = salesOrgSubComOrgVo.getVatRate();
        }
        if (Objects.isNull(vatRate)) {
            vatRate = new BigDecimal(0.12);
        }
        importsVo.setTaxesAdditional(vat.multiply(vatRate).setScale(6, 0));
        log.info("\u589e\u503c\u7a0e1\uff0c{}", (Object)vat);
        log.info("\u589e\u503c\u7a0e\u7a0e\u73871\uff0c{}", (Object)vatRate);
        log.info("\u9644\u52a0\u7a0e\u91d11,{}", (Object)importsVo.getTaxesAdditional());
        BigDecimal taxesFee = vat.add(importsVo.getTaxesAdditional());
        importsVo.setTaxesFee(taxesFee);
    }

    public void testValidate(List<SalesPlanSubCompanyImportsVo> list) {
        HashMap mdmBusinessFormatMap = new HashMap();
        HashMap mdmBusinessUnitMap = new HashMap();
        HashMap tpmGroupCodeMap = new HashMap();
        HashMap customerVoMap = new HashMap();
        HashMap terminalVoMap = new HashMap();
        HashMap productVoMap = new HashMap();
        HashMap salesOrgVoMap = new HashMap();
        HashMap customerChannelVoMap = new HashMap();
        HashMap terminalChannelVoMap = new HashMap();
        HashMap productBrandVoMap = new HashMap();
        HashMap productCategoryVoMap = new HashMap();
        HashMap productItemVoMap = new HashMap();
        HashMap profitGoalDiscountVoMap = new HashMap();
        HashMap orgVoMap = new HashMap();
        HashMap salesOrgErpMap = new HashMap();
        HashMap erpOrgMap = new HashMap();
        HashMap outDiscountRatioMap = new HashMap();
        Validate.notEmpty(list, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        LinkedHashMap<Integer, SalesPlanSubCompanyImportsVo> data = new LinkedHashMap<Integer, SalesPlanSubCompanyImportsVo>();
        data.put(1, list.get(0));
    }

    private void buildDimension(Map<String, List<DimensionDimensionInformationVo>> dimensionMap, SalesPlanSubCompanyImportsVo importsVo, Class<SalesPlanSubCompanyImportsVo> clazz) {
        List<Object> dimensionVoList = new ArrayList();
        if (!dimensionMap.containsKey(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + MenuCodeEnum.SALES_PLAN.getCode() + importsVo.getSalesOrgRegionCode())) {
            DimensionInformationQueryData dto = new DimensionInformationQueryData();
            dto.setBusinessFormatCode(importsVo.getBusinessFormatCode());
            dto.setBusinessUnitCode(importsVo.getBusinessUnitCode());
            dto.setMenu(MenuCodeEnum.SALES_PLAN.getCode());
            dimensionVoList = this.dimensionDimensionInformationService.findDetailsByCodes(dto);
            dimensionMap.put(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + MenuCodeEnum.SALES_PLAN.getCode() + importsVo.getSalesInstitutionCode(), dimensionVoList);
        } else {
            dimensionVoList = dimensionMap.get(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + MenuCodeEnum.SALES_PLAN.getCode() + importsVo.getSalesOrgRegionCode());
        }
        if (CollectionUtils.isEmpty(dimensionVoList)) {
            throw new IllegalArgumentException("\u672a\u7ef4\u62a4\u5bf9\u5e94\u7ef4\u5ea6\u914d\u7f6e\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        dimensionVoList.forEach(informationVo -> {
            try {
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)informationVo.getFieldCoding())) {
                    return;
                }
                Field field = clazz.getDeclaredField(informationVo.getFieldCoding());
                field.setAccessible(true);
                Object o = field.get(importsVo);
                if (ObjectUtils.isEmpty((Object)o)) {
                    throw new IllegalArgumentException(informationVo.getFieldName() + "\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        });
        importsVo.setTypeCoding(((DimensionDimensionInformationVo)dimensionVoList.get(0)).getTypeCoding());
    }

    private void buildDecimal(SalesPlanSubCompanyImportsVo importsVo, Map<String, ProfitGoalDiscountVo> outDiscountRatioMap, Map<String, String> salesOrgErpMap, Map<String, String> erpOrgMap) {
        try {
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getDiscountRateStr())) {
                importsVo.setDiscountRate(new BigDecimal(importsVo.getDiscountRateStr()));
            }
        }
        catch (Exception e) {
            this.validateIsTrue(false, "\u8fdb\u8d27\u6298\u6263\u7387" + importsVo.getDiscountRateStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getShippingDiscountRateStr())) {
                importsVo.setShippingDiscountRate(new BigDecimal(importsVo.getShippingDiscountRateStr()));
            } else {
                String erpCode = salesOrgErpMap.get(importsVo.getSalesInstitutionCode());
                String orgCode = erpOrgMap.get(erpCode);
                if (outDiscountRatioMap.containsKey(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + importsVo.getYearMonthLy() + orgCode)) {
                    ProfitGoalDiscountVo profitGoalDiscountVo = outDiscountRatioMap.get(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + importsVo.getYearMonthLy() + orgCode);
                    importsVo.setDiscountRate(profitGoalDiscountVo.getPurchaseDiscountRatio());
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getShippingDiscountRateStr())) {
                        importsVo.setShippingDiscountRate(profitGoalDiscountVo.getDeliveryDiscountRatio());
                    }
                }
            }
        }
        catch (Exception e) {
            this.validateIsTrue(false, "\u51fa\u8d27\u6298\u6263\u7387" + importsVo.getShippingDiscountRateStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getPlanQuantityStr())) {
                importsVo.setPlanQuantity(new BigDecimal(importsVo.getPlanQuantityStr()));
            }
        }
        catch (Exception e) {
            this.validateIsTrue(false, "\u8ba1\u5212\u91cf" + importsVo.getPlanQuantityStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getStandardSupplyPriceStr())) {
                importsVo.setStandardSupplyPrice(new BigDecimal(importsVo.getStandardSupplyPriceStr()));
            }
        }
        catch (Exception e) {
            this.validateIsTrue(false, "\u6807\u51c6\u4f9b\u8d27\u4ef7" + importsVo.getStandardSupplyPriceStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getCifPriceStr())) {
                importsVo.setCifPrice(new BigDecimal(importsVo.getCifPriceStr()));
            }
        }
        catch (Exception e) {
            this.validateIsTrue(false, "\u5230\u5cb8\u4ef7" + importsVo.getCifPriceStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    private void buildBaseData(SalesPlanSubCompanyImportsVo importsVo, Map<String, Map<String, String>> dictMapMap, Map<String, CustomerVo> customerVoMap, Map<String, TerminalVo> terminalVoMap, Map<String, ProductVo> productVoMap, Map<String, SalesOrgVo> salesOrgVoMap, Map<String, CustomerChannelVo> customerChannelVoMap, Map<String, MdmTerminalChannelVo> terminalChannelVoMap, Map<String, ProductBrandVo> productBrandVoMap, Map<String, ProductLevelVo> productCategoryVoMap, Map<String, ProductLevelVo> productItemVoMap, Map<String, ProfitGoalDiscountVo> profitGoalDiscountVoMap, Map<String, OrgVo> orgVoMap, Map<String, String> salesOrgErpMap, Map<String, String> erpOrgMap) {
        String insCode;
        String yearMonthLy;
        Map<String, String> mdmBusinessFormatMap = dictMapMap.getOrDefault("mdm_business_format", Maps.newHashMap());
        Map<String, String> mdmBusinessUnitMap = dictMapMap.getOrDefault("mdm_business_unit", Maps.newHashMap());
        Map<String, String> tpmGroupCodeMap = dictMapMap.getOrDefault("tpm_group_code", Maps.newHashMap());
        importsVo.setDataFromCode(DataFromEnum.IMPORT.getCode());
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getBusinessFormatCode())) {
            if (!mdmBusinessFormatMap.containsKey(importsVo.getBusinessFormatCode())) {
                this.validateIsTrue(false, "\u4e1a\u6001" + importsVo.getBusinessFormatCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            } else {
                importsVo.setBusinessFormatCode(mdmBusinessFormatMap.get(importsVo.getBusinessFormatCode()));
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getBusinessUnitCode())) {
            if (!mdmBusinessUnitMap.containsKey(importsVo.getBusinessUnitCode())) {
                this.validateIsTrue(false, "\u4e1a\u52a1\u5355\u5143" + importsVo.getBusinessUnitCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            } else {
                importsVo.setBusinessUnitCode(mdmBusinessUnitMap.get(importsVo.getBusinessUnitCode()));
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(yearMonthLy = importsVo.getYearMonthLy()))) {
            if (yearMonthLy.length() != 7) {
                this.validateIsTrue(false, "\u5e74\u6708" + yearMonthLy + "\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u8be5\u4e3a" + "yyyy-MM");
            }
            try {
                DateUtil.date_yyyy_MM.setLenient(false);
                DateUtil.date_yyyy_MM.parse(yearMonthLy);
            }
            catch (Exception ignored) {
                this.validateIsTrue(false, "\u5e74\u6708" + yearMonthLy + "\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u8be5\u4e3a" + "yyyy-MM");
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getGroupCode())) {
            if (!tpmGroupCodeMap.containsKey(importsVo.getGroupCode())) {
                this.validateIsTrue(false, "\u5206\u7ec4" + importsVo.getGroupCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            } else {
                importsVo.setGroupCode(tpmGroupCodeMap.get(importsVo.getGroupCode()));
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getCustomerChannelCode())) {
            if (!customerChannelVoMap.containsKey(importsVo.getCustomerChannelCode())) {
                this.validateIsTrue(false, "\u5ba2\u6237\u6e20\u9053" + importsVo.getCustomerChannelCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            } else {
                importsVo.setCustomerChannelName(customerChannelVoMap.get(importsVo.getCustomerChannelCode()).getCustomerChannelName());
                importsVo.setCustomerChannelLevelCode(customerChannelVoMap.get(importsVo.getCustomerChannelCode()).getCustomerChannelType());
            }
        }
        if (!salesOrgVoMap.containsKey(insCode = importsVo.getCustomerChannelCode() + importsVo.getBusinessFormatCode() + importsVo.getSalesInstitutionCode())) {
            this.validateIsTrue(false, "\u9500\u552e\u673a\u6784" + importsVo.getSalesInstitutionCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        } else {
            importsVo.setSalesInstitutionName(salesOrgVoMap.get(insCode).getSalesOrgName());
            importsVo.setSalesInstitutionErpCode(salesOrgVoMap.get(insCode).getErpCode());
            importsVo.setSalesInstitutionCode(insCode);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getSalesOrgRegionCode())) {
            String regionCode = insCode + importsVo.getSalesOrgRegionCode();
            if (!salesOrgVoMap.containsKey(regionCode)) {
                this.validateIsTrue(false, "\u9500\u552e\u7ec4\u7ec7\uff08\u5927\u533a\uff09" + importsVo.getSalesOrgRegionCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            } else {
                importsVo.setSalesOrgRegionName(salesOrgVoMap.get(regionCode).getSalesOrgName());
                importsVo.setSalesOrgRegionErpCode(salesOrgVoMap.get(regionCode).getErpCode());
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getSalesOrgProvinceCode())) {
                    String provinceCode = regionCode + importsVo.getSalesOrgProvinceCode();
                    if (!salesOrgVoMap.containsKey(provinceCode)) {
                        this.validateIsTrue(false, "\u9500\u552e\u7ec4\uff08\u7701\u533a\uff09" + importsVo.getSalesOrgProvinceCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                    } else {
                        importsVo.setSalesOrgProvinceName(salesOrgVoMap.get(provinceCode).getSalesOrgName());
                        importsVo.setSalesOrgProvinceErpCode(salesOrgVoMap.get(provinceCode).getErpCode());
                    }
                }
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getTerminalChannelCode())) {
            if (!terminalChannelVoMap.containsKey(importsVo.getTerminalChannelCode())) {
                this.validateIsTrue(false, "\u7ec8\u7aef\u6e20\u9053" + importsVo.getTerminalChannelCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            } else {
                importsVo.setTerminalChannelName(terminalChannelVoMap.get(importsVo.getTerminalChannelCode()).getTerminalChannelName());
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getSystemCode())) {
            // empty if block
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getTerminalCode())) {
            if (terminalVoMap.containsKey(importsVo.getTerminalCode())) {
                importsVo.setTerminalName(terminalVoMap.get(importsVo.getTerminalCode()).getTerminalName());
            } else {
                this.validateIsTrue(false, "\u95e8\u5e97\u7f16\u7801" + importsVo.getTerminalCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getProductBrandCode())) {
            if (productBrandVoMap.containsKey(importsVo.getProductBrandCode())) {
                importsVo.setProductBrandName(productBrandVoMap.get(importsVo.getProductBrandCode()).getProductBrandName());
            } else {
                this.validateIsTrue(false, "\u4ea7\u54c1\u54c1\u724c" + importsVo.getProductBrandCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getProductCategoryCode())) {
            if (productCategoryVoMap.containsKey(importsVo.getProductCategoryCode())) {
                importsVo.setProductCategoryName(productCategoryVoMap.get(importsVo.getProductCategoryCode()).getProductLevelName());
            } else {
                this.validateIsTrue(false, "\u4ea7\u54c1\u54c1\u7c7b" + importsVo.getProductCategoryCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getProductItemCode())) {
            if (productItemVoMap.containsKey(importsVo.getProductItemCode())) {
                importsVo.setProductItemName(productItemVoMap.get(importsVo.getProductItemCode()).getProductLevelName());
            } else {
                this.validateIsTrue(false, "\u4ea7\u54c1\u54c1\u9879" + importsVo.getProductItemCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getProductCode())) {
            if (productVoMap.containsKey(importsVo.getProductCode())) {
                ProductVo productVo = productVoMap.get(importsVo.getProductCode());
                importsVo.setProductName(productVo.getProductName());
                importsVo.setTaxRate(productVo.getRate());
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getProductBrandCode())) {
                    importsVo.setProductBrandCode(productVo.getProductBrandCode());
                    importsVo.setProductBrandName(productVo.getProductBrandName());
                }
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getProductCategoryCode())) {
                    importsVo.setProductCategoryCode(productVo.getProductCategoryCode());
                    importsVo.setProductCategoryName(productVo.getProductCategoryName());
                }
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getProductItemCode())) {
                    importsVo.setProductItemCode(productVo.getProductLevelCode());
                    importsVo.setProductItemName(productVo.getProductLevelName());
                }
            } else {
                this.validateIsTrue(false, "\u4ea7\u54c1\u7f16\u7801" + importsVo.getProductCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getYearMonthLy())) {
            String erpCode = salesOrgErpMap.get(importsVo.getSalesInstitutionCode());
            String orgCode = erpOrgMap.get(erpCode);
            if (profitGoalDiscountVoMap.containsKey(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + importsVo.getYearMonthLy() + orgCode)) {
                ProfitGoalDiscountVo profitGoalDiscountVo = profitGoalDiscountVoMap.get(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + importsVo.getYearMonthLy() + orgCode);
                importsVo.setDiscountRate(profitGoalDiscountVo.getPurchaseDiscountRatio());
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getShippingDiscountRateStr())) {
                    importsVo.setShippingDiscountRate(profitGoalDiscountVo.getDeliveryDiscountRatio());
                }
            } else {
                this.validateIsTrue(false, "\u4e1a\u6001[" + importsVo.getBusinessFormatCode() + "]\u4e1a\u52a1\u5355\u5143[" + importsVo.getBusinessUnitCode() + "]\u5e74\u6708[" + importsVo.getYearMonthLy() + "]\u9500\u552e\u516c\u53f8\u4ee3\u7801\u7f16\u7801[" + orgCode + "]\u672a\u67e5\u627e\u5230\u6298\u6263\u7387\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importsVo.getUnitCode())) {
            // empty if block
        }
        this.validateAndConvertDictData(dictMapMap, "sales_plan_attributes_subsidiary", importsVo.getAttributesSubsidiary(), arg_0 -> ((SalesPlanSubCompanyImportsVo)importsVo).setAttributesSubsidiary(arg_0), "\u5c5e\u6027");
        this.validateAndConvertDictData(dictMapMap, "channel_segmentation_subsidiary_companies", importsVo.getChannelSegmentationSubsidiary(), arg_0 -> ((SalesPlanSubCompanyImportsVo)importsVo).setChannelSegmentationSubsidiary(arg_0), "\u6e20\u9053\u7ec6\u5206");
        this.validateAndConvertDictData(dictMapMap, "sales_plan_business_model_subsidiary_companies", importsVo.getBusinessModelSubsidiary(), arg_0 -> ((SalesPlanSubCompanyImportsVo)importsVo).setBusinessModelSubsidiary(arg_0), "\u7ecf\u8425\u6a21\u5f0f");
    }

    public void validateAndConvertDictData(Map<String, Map<String, String>> dictMap, String dictTypeCode, String dictValue, Consumer<String> setMethod, String desc) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dictValue)) {
            return;
        }
        Map<String, String> dictDataMap = dictMap.get(dictTypeCode);
        if (null == dictDataMap) {
            return;
        }
        String dictCode = dictDataMap.get(dictValue);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dictCode)) {
            this.validateIsTrue(false, desc + "[" + dictValue + "]\u6709\u8bef");
        }
        setMethod.accept(dictCode);
    }

    private void buildBaseMap(Map<String, ProfitGoalDiscountVo> outDiscountRatioMap, LinkedHashMap<Integer, SalesPlanSubCompanyImportsVo> data, Map<String, Map<String, String>> dictMapMap, Map<String, CustomerVo> customerVoMap, Map<String, TerminalVo> terminalVoMap, Map<String, ProductVo> productVoMap, Map<String, SalesOrgVo> salesOrgVoMap, Map<String, CustomerChannelVo> customerChannelVoMap, Map<String, MdmTerminalChannelVo> terminalChannelVoMap, Map<String, ProductBrandVo> productBrandVoMap, Map<String, ProductLevelVo> productCategoryVoMap, Map<String, ProductLevelVo> productItemVoMap, Map<String, ProfitGoalDiscountVo> profitGoalDiscountVoMap, Map<String, OrgVo> orgVoMap, Map<String, String> salesOrgErpMap, Map<String, String> erpOrgMap, Map<Integer, String> errMap) {
        List profitGoalDiscountVoList;
        List productVoList;
        List productLevelVos;
        List productBrandVos;
        List terminalVos;
        List mdmTerminalChannelVos;
        List customerChannelVos;
        List salesOrgVos;
        ArrayList dictCodeList = Lists.newArrayList((Object[])new String[]{"mdm_business_format", "mdm_business_unit", "tpm_group_code"});
        dictCodeList.add("sales_plan_attributes_subsidiary");
        dictCodeList.add("channel_segmentation_subsidiary_companies");
        dictCodeList.add("sales_plan_business_model_subsidiary_companies");
        Map dictMap = this.dictDataVoService.findByDictTypeCodeList((List)dictCodeList);
        dictMapMap.putAll(!CollectionUtils.isEmpty((Map)dictMap) ? dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> ((List)item.getValue()).stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode, (o, n) -> n)), (o, n) -> n)) : new HashMap());
        Map<String, String> mdmBusinessFormatMap = dictMapMap.getOrDefault("mdm_business_format", Maps.newHashMap());
        HashSet<String> salesOrgCodeSet = new HashSet<String>();
        HashSet salesOrgRegionCodeSet = new HashSet();
        HashSet salesOrgProvinceCodeSet = new HashSet();
        HashSet<String> customerChannelCodeSet = new HashSet<String>();
        HashSet<String> terminalChannelCodeSet = new HashSet<String>();
        HashSet<String> systemCodeSet = new HashSet<String>();
        HashSet<String> terminalCodeSet = new HashSet<String>();
        HashSet<String> productBrandCodeSet = new HashSet<String>();
        HashSet<String> productCategoryCodeSet = new HashSet<String>();
        HashSet<String> productItemCodeSet = new HashSet<String>();
        HashSet<String> productCodeSet = new HashSet<String>();
        HashSet<String> unitCodeSet = new HashSet<String>();
        HashSet<String> yearMonthSet = new HashSet<String>();
        for (Map.Entry<Integer, SalesPlanSubCompanyImportsVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            SalesPlanSubCompanyImportsVo importsVo = row.getValue();
            this.baseCheck(importsVo);
            String businessFormatCode = mdmBusinessFormatMap.get(importsVo.getBusinessFormatCode());
            this.validateIsTrue(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)businessFormatCode), "\u4e1a\u6001\u3010" + businessFormatCode + "\u3011\u586b\u5199\u6709\u8bef");
            String errInfo = this.validateGetErrorInfo();
            if (errInfo != null) {
                errMap.put(rowNum, errInfo);
                continue;
            }
            String insCode = importsVo.getCustomerChannelCode() + businessFormatCode + importsVo.getSalesInstitutionCode();
            salesOrgCodeSet.add(insCode);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)importsVo.getSalesOrgRegionCode())) {
                String regionCode = insCode + importsVo.getSalesOrgRegionCode();
                salesOrgCodeSet.add(regionCode);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)importsVo.getSalesOrgProvinceCode())) {
                    String provinceCode = regionCode + importsVo.getSalesOrgProvinceCode();
                    salesOrgCodeSet.add(provinceCode);
                }
            }
            customerChannelCodeSet.add(importsVo.getCustomerChannelCode());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)importsVo.getTerminalChannelCode())) {
                terminalChannelCodeSet.add(importsVo.getTerminalChannelCode());
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)importsVo.getSystemCode())) {
                systemCodeSet.add(importsVo.getSystemCode());
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)importsVo.getTerminalCode())) {
                terminalCodeSet.add(importsVo.getTerminalCode());
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)importsVo.getProductBrandCode())) {
                productBrandCodeSet.add(importsVo.getProductBrandCode());
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)importsVo.getProductCategoryCode())) {
                productCategoryCodeSet.add(importsVo.getProductCategoryCode());
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)importsVo.getProductItemCode())) {
                productItemCodeSet.add(importsVo.getProductItemCode());
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)importsVo.getProductCode())) {
                productCodeSet.add(importsVo.getProductCode());
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)importsVo.getUnitCode())) {
                unitCodeSet.add(importsVo.getUnitCode());
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)importsVo.getYearMonthLy())) {
                yearMonthSet.add(importsVo.getYearMonthLy());
            }
            if (errMap.isEmpty()) continue;
            return;
        }
        salesOrgCodeSet.addAll(salesOrgRegionCodeSet);
        salesOrgCodeSet.addAll(salesOrgProvinceCodeSet);
        if (!CollectionUtils.isEmpty(salesOrgCodeSet) && !CollectionUtils.isEmpty((Collection)(salesOrgVos = this.salesOrgVoService.findBySalesOrgCodes(new ArrayList(salesOrgCodeSet))))) {
            List orgVos;
            salesOrgErpMap.putAll(salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, SalesOrgVo::getErpCode)));
            salesOrgVoMap.putAll(salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity())));
            List erpCodeList = salesOrgVos.stream().map(SalesOrgVo::getErpCode).filter(Objects::nonNull).collect(Collectors.toList());
            List salesOrgSubComOrgVos = this.salesOrgSubComOrgService.listBySalesOrgCodeList(erpCodeList);
            erpOrgMap.putAll(salesOrgSubComOrgVos.stream().collect(Collectors.toMap(SalesOrgSubComOrgVo::getSalesOrgCode, SalesOrgSubComOrgVo::getOrgCode, (v1, v2) -> v2)));
            if (!CollectionUtils.isEmpty(erpOrgMap) && !CollectionUtils.isEmpty((Collection)(orgVos = this.orgVoService.findByOrgCodes((List)Lists.newArrayList(erpOrgMap.values()))))) {
                orgVoMap.putAll(orgVos.stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity(), (v1, v2) -> v2)));
            }
        }
        if (!CollectionUtils.isEmpty(customerChannelCodeSet) && !CollectionUtils.isEmpty((Collection)(customerChannelVos = this.customerChannelVoService.findByCodes(new ArrayList(customerChannelCodeSet))))) {
            customerChannelVoMap.putAll(customerChannelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity())));
        }
        if (!CollectionUtils.isEmpty(terminalChannelCodeSet) && !CollectionUtils.isEmpty((Collection)(mdmTerminalChannelVos = this.mdmTerminalChannelVoService.listByCodes(new ArrayList(terminalChannelCodeSet))))) {
            terminalChannelVoMap.putAll(mdmTerminalChannelVos.stream().collect(Collectors.toMap(MdmTerminalChannelVo::getTerminalChannelCode, Function.identity())));
        }
        if (!CollectionUtils.isEmpty(terminalCodeSet) && !CollectionUtils.isEmpty((Collection)(terminalVos = this.terminalVoService.findDetailsByIdsOrTerminalCodes(null, new ArrayList(terminalCodeSet))))) {
            terminalVoMap.putAll(terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity())));
        }
        if (!CollectionUtils.isEmpty(productBrandCodeSet) && !CollectionUtils.isEmpty((Collection)(productBrandVos = this.productBrandService.listByCodes(new ArrayList(productBrandCodeSet))))) {
            productBrandVoMap.putAll(productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode, Function.identity())));
        }
        if (!CollectionUtils.isEmpty(productCategoryCodeSet) && !CollectionUtils.isEmpty((Collection)(productLevelVos = this.productLevelVoSdkService.findListByCodes(new ArrayList(productCategoryCodeSet))))) {
            productCategoryVoMap.putAll(productLevelVos.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, Function.identity())));
        }
        if (!CollectionUtils.isEmpty(productItemCodeSet) && !CollectionUtils.isEmpty((Collection)(productLevelVos = this.productLevelVoSdkService.findListByCodes(new ArrayList(productItemCodeSet))))) {
            productItemVoMap.putAll(productLevelVos.stream().filter(a -> ProductLevelEnum.items.equals((Object)a.getProductLevelType()) && a.getParentCode() != null).collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, Function.identity())));
        }
        if (!CollectionUtils.isEmpty(productCodeSet) && !CollectionUtils.isEmpty((Collection)(productVoList = this.productVoService.findDetailsByIdsOrProductCodes((List)Lists.newArrayList(), new ArrayList(productCodeSet))))) {
            productVoMap.putAll(productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity())));
        }
        if (!CollectionUtils.isEmpty(yearMonthSet) && !CollectionUtils.isEmpty((Collection)(profitGoalDiscountVoList = this.profitGoalDiscountService.findListByYearMonthList(new ArrayList(yearMonthSet))))) {
            profitGoalDiscountVoMap.putAll(profitGoalDiscountVoList.stream().filter(vo -> BudgetAmountTypeEnum.DISCOUNT_RATIO.getCode().equals(vo.getTypeCode())).collect(Collectors.toMap(vo -> vo.getBusinessFormatCode() + vo.getBusinessUnitCode() + vo.getYearMonthLy() + vo.getOrgCode(), Function.identity())));
            outDiscountRatioMap.putAll(profitGoalDiscountVoList.stream().filter(vo -> BudgetAmountTypeEnum.OUT_DISCOUNT_RATIO.getCode().equals(vo.getTypeCode())).collect(Collectors.toMap(vo -> vo.getBusinessFormatCode() + vo.getBusinessUnitCode() + vo.getYearMonthLy() + vo.getOrgCode(), Function.identity())));
        }
    }

    public String getBusinessCode() {
        return "TPM_SALES_PLAN_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u9500\u552e\u8ba1\u5212\u5bfc\u5165";
    }

    public Class<SalesPlanSubCompanyImportsVo> findCrmExcelVoClass() {
        return SalesPlanSubCompanyImportsVo.class;
    }

    public String getTemplateCode() {
        return "TPM_SALES_PLAN_SUB_COMPANY_IMPORT";
    }

    public String getTemplateName() {
        return "TPM\u9500\u552e\u8ba1\u5212\u5bfc\u5165(\u5206\u5b50\u516c\u53f8)";
    }
}

