/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.plan.local.service.xxjob;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.dto.CowMasterGuestMonthPlanDto;
import com.biz.crm.tpm.business.sales.plan.local.service.SalesPlanCowMasterGuestService;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanLogEventDto;
import com.biz.crm.tpm.business.sales.plan.sdk.event.SalesPlanJobEventListener;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutoPullMonthPlanXxJob {
    private static final Logger log = LoggerFactory.getLogger(AutoPullMonthPlanXxJob.class);
    @Autowired(required=false)
    private SalesPlanCowMasterGuestService salesPlanCowMasterGuestService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @DynamicTaskService(cornExpression="0 0 2 28 1/1 ?", taskDesc="\uff08\u5782\u76f4\u8ba1\u5212\u91cf\uff09\u62c9\u53d6\u4e0b\u6708\u9500\u552e\u8ba1\u5212\u5e76\u66f4\u65b0\u4e0b\u6708\u6708\u5ea6\u9884\u7b97")
    public void planAutoSyncXxlJob() {
        log.info("=====>    \uff08\u5782\u76f4\uff09\u62c9\u53d6\u4e0b\u6708\u9500\u552e\u8ba1\u5212\u5e76\u66f4\u65b0\u4e0b\u6708\u6708\u5ea6\u9884\u7b97 [{}] start    <=====", (Object)DateUtil.dateStrNowAll());
        this.loginUserService.refreshAuthentication(null);
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(new Date());
        calendar.add(2, 1);
        Date time = calendar.getTime();
        String nextYearMonth = DateUtil.format((Date)time, (String)"yyyy-MM");
        this.handle(nextYearMonth);
        log.info("=====>    \uff08\u5782\u76f4\uff09\u62c9\u53d6\u4e0b\u6708\u9500\u552e\u8ba1\u5212\u5e76\u66f4\u65b0\u4e0b\u6708\u6708\u5ea6\u9884\u7b97 [{}] end    <=====", (Object)DateUtil.dateStrNowAll());
    }

    public void handle(String yearMonth) {
        CowMasterGuestMonthPlanDto cowMasterGuestMonthPlanDto = new CowMasterGuestMonthPlanDto();
        cowMasterGuestMonthPlanDto.setYear(yearMonth.split("-")[0]);
        cowMasterGuestMonthPlanDto.setMonths(yearMonth.split("-")[1]);
        this.salesPlanCowMasterGuestService.pullMonthPlanList(cowMasterGuestMonthPlanDto);
        this.publish(yearMonth);
    }

    public void publish(String yearMonth) {
        SerializableBiConsumer & Serializable onPlan = SalesPlanJobEventListener::onPlan;
        SalesPlanLogEventDto eventDto = new SalesPlanLogEventDto();
        SalesPlanDto planDto = new SalesPlanDto();
        planDto.setYearMonthLy(yearMonth);
        eventDto.setNewest(planDto);
        this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, SalesPlanJobEventListener.class, (SerializableBiConsumer)onPlan);
    }
}

