package com.biz.crm.tpm.business.sales.plan.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

/**
 * @author huojia
 * @date 2022年10月26日 14:10
 */
@Data
@ApiModel(value = "SalesPlanDto", description = "TPM-销售计划")
public class SalesPlanDto extends TenantFlagOpDto {

    /**
     * 维度配置编码（模板编码）
     */
    @ApiModelProperty("维度配置编码（模板编码）")
    private String typeCoding;

    /**
     * 版本号[数据字典:tpm_sales_plan_version]
     */
    @ApiModelProperty(name = "版本号[数据字典:tpm_sales_plan_version]", notes = "")
    private String versionNumber;

    /**
     * 数据来源[数据字典:tpm_data_from]
     */
    @ApiModelProperty(value = "数据来源[数据字典:tpm_data_from]", notes = "")
    private String dataFromCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @ApiModelProperty(value = "业务单元", notes = "")
    private String businessUnitCode;
    private List<String> businessUnitCodeList;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    private String yearMonthLy;
    private String yearMonthLyBegin;
    private String yearMonthLyEnd;

    /**
     * 年
     */
    @ApiModelProperty(value = "年", notes = "")
    private String yearLy;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @ApiModelProperty(value = "分组[数据字典:tpm_group_code]", notes = "")
    private String groupCode;

    /**
     * 单据号
     */
    @ApiModelProperty(name = "单据号", notes = "")
    private String orderNo;

    /**
     * 零售商编码
     */
    @ApiModelProperty(name = "customerRetailerCode", notes = "零售商编码")
    private String customerRetailerCode;

    @ApiModelProperty(name = "customerRetailerCodeList", notes = "零售商编码集合")
    private List<String> customerRetailerCodeList;

    /**
     * 零售商名称
     */
    @ApiModelProperty(name = "customerRetailerName", notes = "零售商名称")
    private String customerRetailerName;

    /**
     * 分仓编码
     */
    @ApiModelProperty("分仓编码")
    private String pointsWarehouseCode;

    /**
     * 分仓名称
     */
    @ApiModelProperty("分仓名称")
    private String pointsWarehouseName;

    @ApiModelProperty("HR组织编码")
    private String orgCode;

    @ApiModelProperty("HR组织名称")
    private String orgName;

    /**
     * 销售组织编码
     */
    @CrmExcelColumn(value = "销售组织编码")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @CrmExcelColumn(value = "销售组织名称")
    private String salesOrgName;

    /**
     * 销售机构编码
     */
    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    private String salesInstitutionCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty(name = "salesInstitutionName", value = "销售机构名称", notes = "销售机构名称")
    private String salesInstitutionName;

    /**
     * 销售组织层级
     */
    @ApiModelProperty(value = "销售组织层级", notes = "")
    private String salesOrgLevelCode;

    /**
     * 销售组织编码（大区）
     */
    @ApiModelProperty(value = "销售组织编码（大区）", notes = "")
    private String salesOrgRegionCode;
    private List<String> salesOrgRegionCodeList;

    /**
     * 销售组织名称（大区）
     */
    @ApiModelProperty(value = "销售组织名称（大区）", notes = "")
    private String salesOrgRegionName;

    /**
     * 销售组织编码（省区）
     */
    @ApiModelProperty(value = "销售组织编码（省区）", notes = "")
    private String salesOrgProvinceCode;

    /**
     * 销售组织名称（省区）
     */
    @ApiModelProperty(value = "销售组织名称（省区）", notes = "")
    private String salesOrgProvinceName;

    /**
     * 订单类型
     */
    @ApiModelProperty(value = "订单类型", notes = "")
    private String orderType;

    /**
     * 客户渠道编码
     */
    @ApiModelProperty(value = "客户渠道编码", notes = "")
    private String customerChannelCode;

    /**
     * 客户渠道名称
     */
    @ApiModelProperty(value = "客户渠道名称", notes = "")
    private String customerChannelName;

    /**
     * 客户渠道层级
     */
    @ApiModelProperty(value = "客户渠道层级", notes = "")
    private String customerChannelLevelCode;

    /**
     * 门店渠道层级
     */
    @ApiModelProperty(value = "门店渠道层级", notes = "")
    private String terminalChannelLevelCode;

    /**
     * 门店渠道编码
     */
    @ApiModelProperty(value = "门店渠道编码", notes = "")
    private String terminalChannelCode;

    /**
     * 门店渠道名称
     */
    @ApiModelProperty(value = "门店渠道名称", notes = "")
    private String terminalChannelName;

    /**
     * 系统编码
     */
    @ApiModelProperty(value = "系统编码", notes = "")
    private String systemCode;

    /**
     * 系统名称
     */
    @ApiModelProperty(value = "系统名称", notes = "")
    private String systemName;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码", notes = "")
    private String customerCode;

    /**
     * 客户编码（列表）
     */
    @ApiModelProperty(value = "客户编码（列表）", notes = "")
    private List<String> customerCodeList;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称", notes = "")
    private String customerName;

    /**
     * 客户MDG编码
     */
    @ApiModelProperty(name = "客户MDG编码", notes = "")
    private String erpCode;

    /**
     * 客户类型
     */
    @ApiModelProperty(value = "客户类型", notes = "")
    private String customerType;

    /**
     * 门店编码
     */
    @ApiModelProperty(value = "门店编码", notes = "")
    private String terminalCode;

    private List<String> terminalCodes;

    /**
     * 门店名称
     */
    @ApiModelProperty(value = "门店名称", notes = "")
    private String terminalName;

    /**
     * 区域编码
     */
    @ApiModelProperty(value = "区域编码", notes = "")
    private String regionCode;

    private List<String> regionCodes;

    /**
     * 区域名称
     */
    @ApiModelProperty(value = "区域名称", notes = "")
    private String regionName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码", notes = "")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称", notes = "")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码", notes = "")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称", notes = "")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @ApiModelProperty(value = "品项编码", notes = "")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty(value = "品项名称", notes = "")
    private String productItemName;

    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码", notes = "")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(value = "产品名称", notes = "")
    private String productName;

    /**
     * 单位编码
     */
    @ApiModelProperty(value = "单位编码", notes = "")
    private String unitCode;

    /**
     * 单位名称
     */
    @ApiModelProperty(value = "单位名称", notes = "")
    private String unitName;

    /**
     * 单价
     */
    @ApiModelProperty(value = "单价", notes = "")
    private BigDecimal price;

    /**
     * 吨位
     */
    @ApiModelProperty(value = "吨位", notes = "")
    private BigDecimal tonnage;

    /**
     * 计划量
     */
    @ApiModelProperty(value = "计划量", notes = "")
    private BigDecimal planQuantity;

    /**
     * 计划金额
     */
    @ApiModelProperty(value = "计划金额", notes = "")
    private BigDecimal planAmount;

    /**
     * 计划折后金额
     */
    @ApiModelProperty(value = "计划折后金额", notes = "")
    private BigDecimal discountPlanAmount;

    /**
     * 标准供货价
     */
    @ApiModelProperty(value = "标准供货价", notes = "")
    private BigDecimal standardSupplyPrice;

    /**
     * 理论收入
     */
    @ApiModelProperty(value = "理论收入", notes = "")
    private BigDecimal theoryIncome;

    /**
     * 到岸价
     */
    @ApiModelProperty(value = "到岸价", notes = "")
    private BigDecimal cifPrice;

    /**
     * 理论成本
     */
    @ApiModelProperty(value = "理论成本", notes = "")
    private BigDecimal theoryCost;

    /**
     * 折前金额
     */
    @ApiModelProperty(value = "折前金额", notes = "")
    private BigDecimal amount;

    /**
     * 折后金额
     */
    @ApiModelProperty(value = "折后金额", notes = "")
    private BigDecimal discountAmount;

    /**
     * 回复数量
     */
    @ApiModelProperty(value = "回复数量", notes = "")
    private BigDecimal restoreQuantity;

    /**
     * 回复金额
     */
    @ApiModelProperty(value = "回复金额", notes = "")
    private BigDecimal restoreAmount;

    /**
     * 折后回复金额
     */
    @ApiModelProperty(value = "折后回复金额", notes = "")
    private BigDecimal discountRestoreAmount;

    /**
     * 税率
     */
    @ApiModelProperty(name = "税率")
    private BigDecimal taxRate;

    /**
     * 折扣率
     */
    @ApiModelProperty(name = "折扣率")
    private BigDecimal discountRate;

    //    3、【属性】填写内容验证：数据字典sales_plan_attributes_subsidiary；
    @ApiModelProperty(name = "属性-分子")
    private String attributesSubsidiary;

    //    4、【渠道细分】填写内容验证：数据字典channel_segmentation_subsidiary_companies；
    @ApiModelProperty(name = "渠道细分-分子")
    private String channelSegmentationSubsidiary;

    //    5、【经营模式】填写内容验证：数据字典sales_plan_business_model_subsidiary_companies；
    @ApiModelProperty(name = "经营模式-分子")
    private String businessModelSubsidiary;

    /**
     * onlyKey
     */
    @ApiModelProperty(name = "onlyKey", notes = "唯一键(拼接的维度信息)")
    private String onlyKey;

    /*排除数据*/

    /**
     * 包含销售组织
     */
    private List<String> salesOrgCodeList;

    /**
     * 包含销售产品
     */
    private List<String> salesProductCodeList;

    /**
     * 非包含产品编码
     */
    private List<String> excludeProductCodeList;

    /**
     * 非包含品类编码
     */
    private List<String> excludeProductCategoryCodeList;

    /**
     * 非包含客户编码
     */
    private List<String> excludeCustomerCodeList;

    /**
     * 非包含终端编码
     */
    private List<String> excludeTerminalCodeList;


    /**
     * 以下是新加字段
     */

    @ApiModelProperty("出货折扣率（0.00%）")
    private BigDecimal shippingDiscountRate;

    @ApiModelProperty("折后收入（元）")
    private BigDecimal discountedIncome;

    @ApiModelProperty("折后成本（元）")
    private BigDecimal discountedCost;

    @ApiModelProperty("增值税（元）")
    private BigDecimal vat;

    @ApiModelProperty("税金附加（元）")
    private BigDecimal taxesAdditional;

    @ApiModelProperty("税费（元）")
    private BigDecimal taxesFee;

    /**
     * 销售机构erp编码
     */
    @ApiModelProperty(value = "销售机构编码", notes = "销售机构erp编码")
    private String salesInstitutionErpCode;

    /**
     * 销售组织erp编码（大区）
     */
    @ApiModelProperty(value = "销售组织erp编码（大区）", notes = "")
    private String salesOrgRegionErpCode;

    /**
     * 销售组织erp编码（省区）
     */
    @ApiModelProperty(value = "销售组织erp编码（省区）", notes = "")
    private String salesOrgProvinceErpCode;

    /**
     * 数据状态
     */
    @ApiModelProperty(name = "specialDataStatus", value = "数据状态", notes = "数据状态")
    private String specialDataStatus;

    /**
     * 确认人账号
     */
    @ApiModelProperty(name = "confirmedAccount", value = "确认人账号", notes = "确认人账号")
    private String confirmedAccount;

    /**
     * 确认人姓名
     */
    @ApiModelProperty(name = "confirmedName", value = "确认人姓名", notes = "确认人姓名")
    private String confirmedName;

    /**
     * 确认意见
     */
    @ApiModelProperty(name = "confirmedOpinion", value = "确认意见", notes = "确认意见")
    private String confirmedOpinion;

}
