package com.biz.crm.tpm.business.sales.plan.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author chenlong
 * @date 2022年10月26日 14:10
 */
@Data
@ApiModel(value = "SalesPlanReCalPlanAndReplyDto", description = "TPM-销售计划重新计算计划量和回复量dto")
public class SalesPlanReCalPlanAndReplyDto {

    /**
     * 业态
     */
    @ApiModelProperty(name = "businessFormatCode", value = "业态", notes = "业态")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @ApiModelProperty(name = "businessUnitCode", value = "业务单元", notes = "业务单元")
    private String businessUnitCode;

    /**
     * 年月
     */
    @ApiModelProperty(name = "yearAndMonth", value = "年月", notes = "年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date yearAndMonth;


    /**
     * 年月
     */
    @ApiModelProperty(name = "yearMonthLy", value = "年月", notes = "年月")
    private String yearMonthLy;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(name = "salesOrgCode", value = "销售组织编码", notes = "销售组织编码")
    private String salesOrgCode;

    /**
     * 销售部门名称（大区）
     */
    @ApiModelProperty(name = "salesOrgName", value = "销售组织编码", notes = "销售组织编码")
    private String salesOrgName;

    /**
     * 销售机构编码
     */
    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码",hidden = true)
    private String salesInstitutionCode;


    /**
     * 销售机构名称
     */
    @ApiModelProperty(name = "salesInstitutionName", value = "销售机构名称", notes = "销售机构名称",hidden = true)
    private String salesInstitutionName;

    /**
     * 销售组织编码（大区）
     */
    @ApiModelProperty(name = "salesOrgRegionCode", value = "销售组织编码（大区）", notes = "销售组织编码（大区）",hidden = true)
    private String salesOrgRegionCode;

    /**
     * 销售组织名称（大区）
     */
    @ApiModelProperty(name = "salesOrgRegionName", value = "销售组织名称（大区）", notes = "销售组织名称（大区）",hidden = true)
    private String salesOrgRegionName;

    /**
     * 销售组织编码（省区）
     */
    @ApiModelProperty(name = "salesOrgProvinceCode", value = "销售组织编码（省区）", notes = "销售组织编码（省区）",hidden = true)
    private String salesOrgProvinceCode;

    /**
     * 销售组织名称（省区）
     */
    @ApiModelProperty(name = "salesOrgProvinceName", value = "销售组织名称（省区）", notes = "销售组织名称（省区）",hidden = true)
    private String salesOrgProvinceName;



}
