package com.biz.crm.tpm.business.sales.plan.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author chenlong
 * @date 2022年10月26日 14:10
 */
@Data
@ApiModel(value = "SalesPlanSummaryDto", description = "TPM-销售计划汇总dto")
public class SalesPlanSummaryDto extends TenantFlagOpDto {

    /**
     * 业态列表
     */
    @ApiModelProperty("业态列表")
    private List<String> formatLsit;

    /**
     * 业务单元列表
     */
    @ApiModelProperty("业务单元列表")
    private List<String> unitLsit;

    /**
     * 客户列表
     */
    @ApiModelProperty("客户列表")
    private List<List<String>> cusLsit;

    /**
     * 产品列表
     */
    @ApiModelProperty("产品列表")
    private List<List<String>> proLsit;

    /**
     * 年月列表
     */
    @ApiModelProperty("年月列表")
    private List<String> monthLsit;

    /**
     * 统计维度 枚举【SummaryDimensionEunm】
     */
    @ApiModelProperty("统计维度")
    private String dimen;

}
