package com.biz.crm.tpm.business.sales.plan.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * @author: chenlong
 * @date: 2023/1/17 11:21
 * @description: 分子数据确认枚举
 */
public enum ConfirmEunm {

    /**
     * 已确认
     */
    COMPLETETHECONFIRMATION("Completetheconfirmation", "已确认"),
    /**
     * 待确认
     */
    TOBECONFIRMED("tobeconfirmed", "待确认"),
    ;

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    ConfirmEunm(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }

    public static ConfirmEunm codeToEnum(String code) {
        ConfirmEunm customerEnum = null;
        ConfirmEunm[] var2 = values();

        for (ConfirmEunm rateCustomerEnum : var2) {
            if (rateCustomerEnum.code.equals(code)) {
                customerEnum = rateCustomerEnum;
            }
        }
        return customerEnum;
    }
}
