package com.biz.crm.tpm.business.sales.plan.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * @author: chenlong
 * @date: 2023/1/17 11:21
 * @description:
 */
public enum SummaryDimensionEunm {

    /**
     * 客户编码
     */
    CUSTOMER("customer", "客户编码"),
    /**
     * 客户+产品编码
     */
    CUSTOMER_PRODUCT("customer_product", "客户+产品编码"),
    /**
     * 产品编码
     */
    PRODUCT("product", "产品编码"),
    ;

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    SummaryDimensionEunm(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }

    public static SummaryDimensionEunm codeToEnum(String code) {
        SummaryDimensionEunm customerEnum = null;
        SummaryDimensionEunm[] var2 = values();

        for (SummaryDimensionEunm rateCustomerEnum : var2) {
            if (rateCustomerEnum.code.equals(code)) {
                customerEnum = rateCustomerEnum;
            }
        }
        return customerEnum;
    }
}
