package com.biz.crm.tpm.business.sales.plan.sdk.event;

import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @author huojia
 * @date 2022年10月26日 14:15
 */
public interface SalesPlanLogEventListener extends NebulaEvent {
    /**
     * 创建预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onCreate(SalesPlanLogEventDto dto);

    /**
     * 删除预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onDelete(SalesPlanLogEventDto dto);

    /**
     * 修改预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onUpdate(SalesPlanLogEventDto dto);

    /**
     * 启用预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onEnable(SalesPlanLogEventDto dto);

    /**
     * 禁用预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onDisable(SalesPlanLogEventDto dto);
}
