package com.biz.crm.tpm.business.sales.plan.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanConfirmDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanReCalPlanAndReplyDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanSummaryDto;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SubSaleMonitorVo;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author huojia
 * @date 2022年10月26日 14:20
 */
public interface SalesPlanService {

    /**
     * 分页查询
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo>
     * @author huojia
     * @date 2022/10/26 14:33
     **/
    Page<SalesPlanVo> findByConditions(Pageable pageable, SalesPlanDto dto);

    /**
     * 条件查询
     *
     * @param dto 条件对象
     * @return 销售计划列表
     */
    List<SalesPlanVo> findByConditions(SalesPlanDto dto);

    /**
     * 根据主键查询
     *
     * @param id
     * @return com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo
     * @author huojia
     * @date 2022/10/26 14:33
     **/
    SalesPlanVo findById(String id);

    /**
     * 修改
     *
     * @param dto
     * @return com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo
     * @author huojia
     * @date 2022/10/26 14:33
     **/
    SalesPlanVo update(SalesPlanDto dto);

    /**
     * 批量删除
     *
     * @param ids
     * @author huojia
     * @date 2022/10/26 14:34
     **/
    void delete(List<String> ids);

    /**
     * 新增数据
     *
     * @param dto
     * @return com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo
     * @author huojia
     * @date 2022/10/26 14:37
     **/
    SalesPlanVo create(SalesPlanDto dto);

    /**
     * 批量导入
     *
     * @param importList
     * @author huojia
     * @date 2022/10/28 14:34
     **/
    void importSave(List<SalesPlanDto> importList);

    /**
     * 根据条件查询销量计划
     *
     * @param salesPlanDto
     * @return java.util.List<com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo>
     * @author huojia
     * @date 2022/11/4 17:40
     **/
    List<SalesPlanVo> listByConditions(SalesPlanDto salesPlanDto);

    /**
     * 根据维度统计回复量
     *
     * @param dto 查询实体
     * @return 统计数据map
     */
    Map<String, BigDecimal> summaryRecoveryAmount(SalesPlanSummaryDto dto);

    /**
     * 根据选择的维度手动计算折后计划量和回复量
     *
     * @param dto 查询实体
     */
    void manualCalPlanAndReply(SalesPlanReCalPlanAndReplyDto dto);


    List<SalesPlanVo> findSalesPlanSumVo(SalesPlanDto queryDto);

    /**
     * 数据确认
     *
     * @param dto 查询实体
     */
    void confirmData(SalesPlanConfirmDto dto);

    /**
     * 分子销售组织转HR组织
     *
     * @param list
     */
    List<SalesPlanDto> convertOrg(List<SalesPlanDto> list);

    /**
     * 销量监控（品项）
     * @param pageable
     * @param dto2
     * @return
     */
    Page<SalesPlanVo> findForSalesVolumeMonitoring(Pageable pageable, SalesPlanDto dto2);

    /**
     * 分子销量监控
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<SubSaleMonitorVo> subSaleMonitor(Pageable pageable, SalesPlanDto dto);

    /**
     * 销管资金池预算项目计算回复量
     *
     * @param dto
     * @return
     */
    List<SalesPlanVo> sumReplayReimburse(SalesPlanDto dto);

    /**
     * 其他预留项目预算项目计算回复量
     *
     * @param dto
     * @return
     */
    List<SalesPlanVo> sumReplayRestore(SalesPlanDto dto);

    /**
     * 其他预留项目预算项目计算计划量
     *
     * @param dto
     * @return
     */
    List<SalesPlanVo> sumReplayPlan(SalesPlanDto dto);

    /**
     * 查询销量
     * @param dto
     * @return
     */
    BigDecimal findSaleAmount(SalesPlanDto dto);

    List<SalesPlanVo> findForSaleAndFeeMonitoring(List<SalesPlanDto> dtos);
}
