package com.biz.crm.tpm.business.sales.plan.sdk.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月28日 11:39
 */
@Data
@CrmExcelImport
@EqualsAndHashCode(callSuper = true)
public class SalesPlanHeadImportsVo extends CrmExcelVo {

    /**
     * 版本号[数据字典:tpm_sales_plan_version]
     */
    @ApiModelProperty(name = "版本号", notes = "")
    @CrmExcelColumn(value = "版本号")
    private String versionNumber;

    /**
     * 业态
     */
    @CrmExcelColumn(value = "业态")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @CrmExcelColumn(value = "业务单元")
    private String businessUnitCode;

    /**
     * 年月
     */
    @CrmExcelColumn(value = "年月")
    private String yearMonthLy;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @CrmExcelColumn(value = "分组[数据字典:tpm_group_code]")
    private String groupCode;

    /**
     * 销售机构编码
     */
    @CrmExcelColumn(value = "销售机构编码")
    private String salesInstitutionCode;

    /**
     * 销售机构名称
     */
    @CrmExcelColumn(value = "销售机构名称")
    private String salesInstitutionName;

    /**
     * 销售组织编码（大区）
     */
    @CrmExcelColumn(value = "销售组织编码（大区）")
    private String salesOrgRegionCode;

    /**
     * 销售组织名称（大区）
     */
    @CrmExcelColumn(value = "销售组织编码（大区）")
    private String salesOrgRegionName;

    /**
     * 销售组编码（省区）
     */
    @CrmExcelColumn(value = "销售组编码（省区）")
    private String salesOrgProvinceCode;

    /**
     * 销售组名称（省区）
     */
    @CrmExcelColumn(value = "销售组名称（省区）")
    private String salesOrgProvinceName;

    /**
     * 客户编码
     */
    @CrmExcelColumn(value = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmExcelColumn(value = "客户名称")
    private String customerName;

    /**
     * 产品编码
     */
    @CrmExcelColumn(value = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn(value = "产品名称")
    private String productName;

    /**
     * 计划量
     */
    @CrmExcelColumn(value = "计划数量")
    private String planQuantityStr;

    /**
     * 计划金额
     */
    @CrmExcelColumn(value = "折前计划金额")
    private String planAmountStr;

    /**
     * 计划折后金额
     */
    @CrmExcelColumn(value = "折后计划金额")
    private String discountPlanAmountStr;

    /**
     * 回复数量
     */
    @CrmExcelColumn(value = "回复数量")
    private String restoreQuantityStr;

    /**
     * 折前回复金额
     */
    @CrmExcelColumn(value = "折前回复金额")
    private String restoreAmountStr;

    /**
     * 折后回复金额
     */
    @CrmExcelColumn(value = "折后回复金额")
    private String discountRestoreAmountStr;

    /*数据库字段*/

    /**
     * 销售机构erp编码
     */
    @ExcelIgnore
    private String salesInstitutionErpCode;

    /**
     * 销售组织erp编码（大区）
     */
    @ExcelIgnore
    private String salesOrgRegionErpCode;

    /**
     * 销售组织erp编码（省区）
     */
    @ExcelIgnore
    private String salesOrgProvinceErpCode;

    /**
     * 计划金额
     */
    @ExcelIgnore
    private BigDecimal planAmount;

    /**
     * 折后回复金额
     */
    @ExcelIgnore
    private BigDecimal discountRestoreAmount;

    /**
     * 客户类型
     */
    @ExcelIgnore
    private String customerType;

    /**
     * 客户渠道层级
     */
    @ExcelIgnore
    private String customerChannelLevelCode;

    /**
     * 门店渠道层级
     */
    @ExcelIgnore
    private String terminalChannelLevelCode;

    /**
     * 销售组织层级编码
     */
    @ExcelIgnore
    private String salesOrgLevelCode;

    /**
     * 数据来源[数据字典:tpm_data_from]
     */
    @ExcelIgnore
    private String dataFromCode;

    /**
     * 维度配置编码（模板编码）
     */
    @ExcelIgnore
    private String typeCoding;

    /**
     * 单价
     */
    @ExcelIgnore
    private BigDecimal price;

    /**
     * 吨位
     */
    @ExcelIgnore
    private BigDecimal tonnage;

    /**
     * 计划量
     */
    @ExcelIgnore
    private BigDecimal planQuantity;

    /**
     * 标准供货价
     */
    @ExcelIgnore
    private BigDecimal standardSupplyPrice;

    /**
     * 理论收入
     */
    @ExcelIgnore
    private BigDecimal theoryIncome;

    /**
     * 到岸价
     */
    @ExcelIgnore
    private BigDecimal cifPrice;

    /**
     * 理论成本
     */
    @ExcelIgnore
    private BigDecimal theoryCost;

    /**
     * 折前金额
     */
    @ExcelIgnore
    private BigDecimal amount;

    /**
     * 折后金额
     */
    @ExcelIgnore
    private BigDecimal discountAmount;

    /**
     * 回复数量
     */
    @ExcelIgnore
    private BigDecimal restoreQuantity;

    /**
     * 回复金额
     */
    @ExcelIgnore
    private BigDecimal restoreAmount;


    /**
     * 税率
     */
    @ExcelIgnore
    private BigDecimal taxRate;

    /**
     * 折扣率
     */
    @ExcelIgnore
    private BigDecimal discountRate;

    /**
     * 计划折后金额
     */
    @ExcelIgnore
    private BigDecimal discountPlanAmount;
}
