package com.biz.crm.tpm.business.sales.plan.sdk.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月28日 11:39
 */
@Data
@CrmExcelImport
@EqualsAndHashCode(callSuper = true)
public class SalesPlanImportsVo extends CrmExcelVo {
    @CrmExcelColumn(value = "版本")
    private String versionNumber;
    /**
     * 业态[数据字典:mdm_business_format]
     */
    @CrmExcelColumn(value = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @CrmExcelColumn(value = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    /**
     * 年月
     */
    @CrmExcelColumn(value = "年月")
    private String yearMonthLy;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @CrmExcelColumn(value = "分组[数据字典:tpm_group_code]")
    private String groupCode;

    /**
     * 销售组织编码
     */
    @CrmExcelColumn(value = "销售组织编码")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @CrmExcelColumn(value = "销售组织名称")
    private String salesOrgName;

    /**
     * 门店渠道编码
     */
    @CrmExcelColumn(value = "门店渠道编码")
    private String terminalChannelCode;

    /**
     * 门店渠道名称
     */
    @CrmExcelColumn(value = "门店渠道名称")
    private String terminalChannelName;

    /**
     * 客户渠道编码
     */
    @CrmExcelColumn(value = "客户渠道编码")
    private String customerChannelCode;

    /**
     * 客户渠道名称
     */
    @CrmExcelColumn(value = "客户渠道名称")
    private String customerChannelName;

    /**
     * 系统编码
     */
    @CrmExcelColumn(value = "系统编码")
    private String systemCode;

    /**
     * 系统名称
     */
    @CrmExcelColumn(value = "系统名称")
    private String systemName;

    /**
     * 客户编码
     */
    @CrmExcelColumn(value = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmExcelColumn(value = "客户名称")
    private String customerName;

    /**
     * 门店编码
     */
    @CrmExcelColumn(value = "门店编码")
    private String terminalCode;

    /**
     * 门店名称
     */
    @CrmExcelColumn(value = "门店名称")
    private String terminalName;

    /**
     * 品牌编码
     */
    @CrmExcelColumn(value = "品牌编码")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @CrmExcelColumn(value = "品牌名称")
    private String productBrandName;

    /**
     * 品类编码
     */
    @CrmExcelColumn(value = "品类编码")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @CrmExcelColumn(value = "品类名称")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @CrmExcelColumn(value = "品项编码")
    private String productItemCode;

    /**
     * 品项名称
     */
    @CrmExcelColumn(value = "品项名称")
    private String productItemName;

    /**
     * 产品编码
     */
    @CrmExcelColumn(value = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn(value = "产品名称")
    private String productName;

    /**
     * 单位编码
     */
    @CrmExcelColumn(value = "单位编码")
    private String unitCode;

    /**
     * 单位名称
     */
    @CrmExcelColumn(value = "单位名称")
    private String unitName;

    /**
     * 单价
     */
    @CrmExcelColumn(value = "单价")
    private String priceStr;

    /**
     * 吨位
     */
    @CrmExcelColumn(value = "吨位")
    private String tonnageStr;

    /**
     * 计划量
     */
    @CrmExcelColumn(value = "计划量")
    private String planQuantityStr;

    /**
     * 标准供货价
     */
    @CrmExcelColumn(value = "标准供货价")
    private String standardSupplyPriceStr;

    /**
     * 理论收入
     */
    @CrmExcelColumn(value = "理论收入")
    private String theoryIncomeStr;

    /**
     * 到岸价
     */
    @CrmExcelColumn(value = "到岸价")
    private String cifPriceStr;

    /**
     * 理论成本
     */
    @CrmExcelColumn(value = "理论成本")
    private String theoryCostStr;

    /**
     * 折前金额
     */
    @CrmExcelColumn(value = "折前金额")
    private String amountStr;

    /**
     * 折后金额
     */
    @CrmExcelColumn(value = "折后金额")
    private String discountAmountStr;

    /**
     * 回复数量
     */
    @CrmExcelColumn(value = "回复数量")
    private String restoreQuantityStr;

    /**
     * 回复金额
     */
    @CrmExcelColumn(value = "回复金额")
    private String restoreAmountStr;

    /*数据库字段*/

    /**
     * 客户类型
     */
    @ExcelIgnore
    private String customerType;

    /**
     * 客户渠道层级
     */
    @ExcelIgnore
    private String customerChannelLevelCode;

    /**
     * 门店渠道层级
     */
    @ExcelIgnore
    private String terminalChannelLevelCode;

    /**
     * 销售组织层级编码
     */
    @ExcelIgnore
    private String salesOrgLevelCode;

    /**
     * 数据来源[数据字典:tpm_data_from]
     */
    @ExcelIgnore
    private String dataFromCode;

    /**
     * 维度配置编码（模板编码）
     */
    @ExcelIgnore
    private String typeCoding;

    /**
     * 单价
     */
    @ExcelIgnore
    private BigDecimal price;

    /**
     * 吨位
     */
    @ExcelIgnore
    private BigDecimal tonnage;

    /**
     * 计划量
     */
    @ExcelIgnore
    private BigDecimal planQuantity;

    /**
     * 标准供货价
     */
    @ExcelIgnore
    private BigDecimal standardSupplyPrice;

    /**
     * 理论收入
     */
    @ExcelIgnore
    private BigDecimal theoryIncome;

    /**
     * 到岸价
     */
    @ExcelIgnore
    private BigDecimal cifPrice;

    /**
     * 理论成本
     */
    @ExcelIgnore
    private BigDecimal theoryCost;

    /**
     * 折前金额
     */
    @ExcelIgnore
    private BigDecimal amount;

    /**
     * 折后金额
     */
    @ExcelIgnore
    private BigDecimal discountAmount;

    /**
     * 回复数量
     */
    @ExcelIgnore
    private BigDecimal restoreQuantity;

    /**
     * 回复金额
     */
    @ExcelIgnore
    private BigDecimal restoreAmount;


    /**
     * 税率
     */
    @ExcelIgnore
    private BigDecimal taxRate;

    /**
     * 折扣率
     */
    @ExcelIgnore
    private BigDecimal discountRate;
}
