package com.biz.crm.tpm.business.sales.plan.sdk.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @author 黄龙  销售计划导入(分子公司)
 * @date 2022年10月28日 11:39
 */
@Data
@CrmExcelImport
@EqualsAndHashCode(callSuper = true)
public class SalesPlanSubCompanyImportsVo extends CrmExcelVo {

    /**
     * 版本号[数据字典:tpm_sales_plan_version]
     */
    @CrmExcelColumn(value = "版本号[数据字典:tpm_sales_plan_version")
    private String versionNumber;
    /**
     * 业态[数据字典:mdm_business_format]
     */
    @CrmExcelColumn(value = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @CrmExcelColumn(value = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    /**
     * 年月
     */
    @CrmExcelColumn(value = "年月")
    private String yearMonthLy;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @CrmExcelColumn(value = "分组[数据字典:tpm_group_code]")
    private String groupCode;

    @CrmExcelColumn(value = "销售机构编码")
    private String salesInstitutionCode;

    @CrmExcelColumn(value = "销售机构名称")
    private String salesInstitutionName;

    /**
     * 此处一直到销售组都是新的字段
     */
    @CrmExcelColumn(value = "销售部门编码(大区)")
    private String salesOrgRegionCode;

    @CrmExcelColumn(value = "销售部门名称(大区)")
    private String salesOrgRegionName;

    @CrmExcelColumn(value = "销售组编码")
    private String salesOrgProvinceCode;

    @CrmExcelColumn(value = "销售组名称(省区)")
    private String salesOrgProvinceName;

//    @CrmExcelColumn(value = "销售组编码")
//    private String salesGroupCode;
//
//    @CrmExcelColumn(value = "销售组名称")
//    private String salesGroupName;

    /**
     * 门店渠道编码
     */
    @CrmExcelColumn(value = "门店渠道编码")
    private String terminalChannelCode;

    /**
     * 门店渠道名称
     */
    @CrmExcelColumn(value = "门店渠道名称")
    private String terminalChannelName;

    /**
     * 客户渠道编码
     */
    @CrmExcelColumn(value = "客户渠道编码")
    private String customerChannelCode;

    /**
     * 客户渠道名称
     */
    @CrmExcelColumn(value = "客户渠道名称")
    private String customerChannelName;

    /**
     * 系统编码
     */
    @CrmExcelColumn(value = "系统编码")
    private String systemCode;

    /**
     * 系统名称
     */
    @CrmExcelColumn(value = "系统名称")
    private String systemName;

    /**
     * 客户编码
     */
    @CrmExcelColumn(value = "客户编码")
    private String customerCode;

    /**
     * 客户MDG编码
     */
    @ExcelIgnore
    private String erpCode;

    /**
     * 客户名称
     */
    @CrmExcelColumn(value = "客户名称")
    private String customerName;

    /**
     * 门店编码
     */
    @CrmExcelColumn(value = "门店编码")
    private String terminalCode;

    /**
     * 门店名称
     */
    @CrmExcelColumn(value = "门店名称")
    private String terminalName;

    /**
     * 品牌编码
     */
    @CrmExcelColumn(value = "品牌编码")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @CrmExcelColumn(value = "品牌名称")
    private String productBrandName;

    /**
     * 品类编码
     */
    @CrmExcelColumn(value = "品类编码")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @CrmExcelColumn(value = "品类名称")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @CrmExcelColumn(value = "品项编码")
    private String productItemCode;

    /**
     * 品项名称
     */
    @CrmExcelColumn(value = "品项名称")
    private String productItemName;

    /**
     * 产品编码
     */
    @CrmExcelColumn(value = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn(value = "产品名称")
    private String productName;

    /**
     * 单位编码
     */
    @CrmExcelColumn(value = "单位编码")
    private String unitCode;

    /**
     * 单位名称
     */
    @CrmExcelColumn(value = "单位名称")
    private String unitName;

    /**
     * 计划量
     */
    @CrmExcelColumn(value = "计划量")
    private String planQuantityStr;

    /**
     * 到岸价
     */
    @CrmExcelColumn(value = "到岸价")
    private String cifPriceStr;

    /**
     * 标准供货价
     */
    @CrmExcelColumn(value = "标准供货价(元)")
    private String standardSupplyPriceStr;


    @CrmExcelColumn(value = "出货折扣率（0.00%）")
    private String shippingDiscountRateStr;

    //【进货折扣率】、【属性】、【渠道细分】、【经营模式】；
    @CrmExcelColumn(value = "进货折扣率")
    private String discountRateStr;

    @CrmExcelColumn(value = "属性")
    private String attributesSubsidiary;

    @CrmExcelColumn(value = "渠道细分")
    private String channelSegmentationSubsidiary;

    @CrmExcelColumn(value = "经营模式")
    private String businessModelSubsidiary;

    /*数据库字段*/

    /**
     * 销售机构erp编码
     */
    @ExcelIgnore
    private String salesInstitutionErpCode;

    /**
     * 销售组织erp编码（大区）
     */
    @ExcelIgnore
    private String salesOrgRegionErpCode;

    /**
     * 销售组织erp编码（省区）
     */
    @ExcelIgnore
    private String salesOrgProvinceErpCode;

    @ExcelIgnore
    @ApiModelProperty("折后收入（元）")
    private BigDecimal discountedIncome=BigDecimal.ZERO;

    @ExcelIgnore
    @ApiModelProperty("折后成本（元）")
    private BigDecimal discountedCost=BigDecimal.ZERO;

    @ExcelIgnore
    @ApiModelProperty("增值税（元）")
    private BigDecimal vat=BigDecimal.ZERO;

    @ExcelIgnore
    @ApiModelProperty("税金附加（元）")
    private BigDecimal taxesAdditional=BigDecimal.ZERO;

    @ExcelIgnore
    @ApiModelProperty("税费（元）")
    private BigDecimal taxesFee=BigDecimal.ZERO;
    /**
     * 客户类型
     */
    @ExcelIgnore
    private String customerType;

    /**
     * 客户渠道层级
     */
    @ExcelIgnore
    private String customerChannelLevelCode;

    /**
     * 门店渠道层级
     */
    @ExcelIgnore
    private String terminalChannelLevelCode;

    /**
     * 销售组织层级编码
     */
    @ExcelIgnore
    private String salesOrgLevelCode;

    /**
     * 数据来源[数据字典:tpm_data_from]
     */
    @ExcelIgnore
    private String dataFromCode;

    /**
     * 维度配置编码（模板编码）
     */
    @ExcelIgnore
    private String typeCoding;

    /**
     * 单价
     */
    @ExcelIgnore
    private BigDecimal price=BigDecimal.ZERO;

    /**
     * 吨位
     */
    @ExcelIgnore
    private BigDecimal tonnage=BigDecimal.ZERO;

    /**
     * 计划量
     */
    @ExcelIgnore
    private BigDecimal planQuantity=BigDecimal.ZERO;

    /**
     * 标准供货价
     */
    @ExcelIgnore
    private BigDecimal standardSupplyPrice=BigDecimal.ZERO;

    /**
     * 理论收入
     */
    @ExcelIgnore
    private BigDecimal theoryIncome=BigDecimal.ZERO;

    /**
     * 到岸价
     */
    @ExcelIgnore
    private BigDecimal cifPrice=BigDecimal.ZERO;

    /**
     * 理论成本
     */
    @ExcelIgnore
    private BigDecimal theoryCost=BigDecimal.ZERO;

    /**
     * 折前金额
     */
    @ExcelIgnore
    private BigDecimal amount=BigDecimal.ZERO;

    /**
     * 折后金额
     */
    @ExcelIgnore
    private BigDecimal discountAmount=BigDecimal.ZERO;

    /**
     * 回复数量
     */
    @ExcelIgnore
    private BigDecimal restoreQuantity=BigDecimal.ZERO;

    /**
     * 回复金额
     */
    @ExcelIgnore
    private BigDecimal restoreAmount=BigDecimal.ZERO;


    /**
     * 税率
     */
    @ExcelIgnore
    private BigDecimal taxRate=BigDecimal.ZERO;

    @ExcelIgnore
    private BigDecimal shippingDiscountRate=BigDecimal.ZERO;

    @ExcelIgnore
    private BigDecimal discountRate=BigDecimal.ZERO;


}
