package com.biz.crm.tpm.business.sales.plan.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author: yaoyongming
 * @date: 2023/8/24 17:26
 */
@Data
@ApiModel(value = "SubSaleMonitorVo", description = "分子销量监控")
public class SubSaleMonitorVo {

    /**
     * 唯一标识
     */
    private String uniqueKey;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty("业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty("业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    @ApiModelProperty("HR组织编码")
    private String orgCode;

    @ApiModelProperty("HR组织名称")
    private String orgName;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    private String salesInstitutionCode;

    /**
     * 销售机构名字
     */
    @ApiModelProperty("销售机构名字")
    private String salesInstitutionName;

    /**
     * 销售组织层级
     */
    @ApiModelProperty("销售组织层级")
    private String salesOrgLevelCode;

    /**
     * 销售组织编码（大区）
     */
    @ApiModelProperty("销售组织编码（大区）")
    private String salesOrgRegionCode;

    /**
     * 销售组织名称（大区）
     */
    @ApiModelProperty("销售组织名称（大区）")
    private String salesOrgRegionName;

    /**
     * 销售组织编码（省区）
     */
    @ApiModelProperty("销售组织编码（省区）")
    private String salesOrgProvinceCode;

    /**
     * 销售组织名称（省区）
     */
    @ApiModelProperty("销售组织名称（省区）")
    private String salesOrgProvinceName;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String customerCode;

    /**
     * 客户MDG编码
     */
    @ApiModelProperty(name = "客户MDG编码")
    private String erpCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String customerName;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    private String productItemName;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    private String productName;

    /**
     * 年月
     */
    @ApiModelProperty("年月")
    private String yearMonthLy;

    @ApiModelProperty("计划数量")
    private BigDecimal planQuantity;

    @ApiModelProperty("理论收入")
    private BigDecimal theoryIncome;

    @ApiModelProperty("折后收入")
    private BigDecimal discountedIncome;

    @ApiModelProperty("理论成本")
    private BigDecimal theoryCost;

    /**
     * 交货单数量
     */
    @ApiModelProperty("交货单数量")
    private Integer deliveryOrderNum;

    /**
     * 理论收入(折前含税)
     */
    @ApiModelProperty("理论收入(折前含税)")
    private BigDecimal incomeTaxIncluded;

    /**
     * 实际收入(折后含税)
     */
    @ApiModelProperty("实际收入(折后含税)")
    private BigDecimal invoiceAmt;

    /**
     * 理论成本(折前含税)
     */
    @ApiModelProperty("理论成本(折前含税)")
    private BigDecimal costTaxIncluded;

    @ApiModelProperty("品项预算理论毛利")
    private BigDecimal theoryGrossProfit;


    /**
     * 实际理论毛利
     */
    @ApiModelProperty(name = "actualTheoryGrossProfit", value = "实际理论毛利", notes = "实际理论毛利")
    private BigDecimal actualTheoryGrossProfit;

    @ApiModelProperty("品项销量达成率")
    private BigDecimal saleReachRate;

    @ApiModelProperty("品项销量偏差")
    private BigDecimal saleDiff;

    @ApiModelProperty("品项折前销售偏差")
    private BigDecimal discountBeforeSaleDiff;

    @ApiModelProperty("品项折后销售偏差")
    private BigDecimal discountAfterSaleDiff;

    @ApiModelProperty("品项理论成本偏差")
    private BigDecimal theoryCostDiff;

    @ApiModelProperty("品项理论毛利偏差")
    private BigDecimal theoryGrossMarginDiff;
}
