/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.volume.channel.local.service.imports;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.tpm.business.sales.volume.channel.sdk.dto.TpmSalesVolumeChannelDto;
import com.biz.crm.tpm.business.sales.volume.channel.sdk.service.TpmSalesVolumeChannelService;
import com.biz.crm.tpm.business.sales.volume.channel.sdk.vo.imports.TpmSalesVolumeChannelImportsVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TpmSalesVolumeChannelImportsProcess
implements ImportProcess<TpmSalesVolumeChannelImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(TpmSalesVolumeChannelImportsProcess.class);
    @Autowired(required=false)
    private TpmSalesVolumeChannelService tpmSalesVolumeChannelService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    public Map<Integer, String> execute(LinkedHashMap<Integer, TpmSalesVolumeChannelImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<TpmSalesVolumeChannelDto> importList = this.validate(data);
        this.tpmSalesVolumeChannelService.importSave(importList);
        return null;
    }

    private List<TpmSalesVolumeChannelDto> validate(LinkedHashMap<Integer, TpmSalesVolumeChannelImportsVo> data) {
        Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"mdm_estore_platform"}));
        Validate.isTrue((mapDict.size() == 1 ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u3010\u5e73\u53f0\u3011\u6570\u636e\u5b57\u5178", (Object[])new Object[0]);
        Map<String, String> platformMap = this.findValuesToCodesMap(mapDict, "mdm_estore_platform");
        ArrayList<TpmSalesVolumeChannelImportsVo> importsVos = new ArrayList<TpmSalesVolumeChannelImportsVo>(data.values());
        ArrayList<TpmSalesVolumeChannelDto> list = new ArrayList<TpmSalesVolumeChannelDto>();
        LinkedList<String> verifyCodes = new LinkedList<String>();
        for (TpmSalesVolumeChannelImportsVo importsVo : importsVos) {
            Validate.notNull((Object)importsVo, (String)"\u5bfc\u5165\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            String platformName = importsVo.getPlatformName();
            Validate.notBlank((CharSequence)platformName, (String)"\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u5e73\u53f0\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((boolean)platformMap.containsKey(platformName), (String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u5e73\u53f0\u540d\u79f0", (Object[])new Object[0]);
            String salesVolumeChannel = importsVo.getSalesVolumeChannel();
            Validate.notBlank((CharSequence)salesVolumeChannel, (String)"\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u9500\u91cf\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            String statisticsOfSales = importsVo.getStatisticsOfSales();
            Validate.notNull((Object)statisticsOfSales, (String)"\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u662f\u5426\u53ef\u4ee5\u7edf\u8ba1\u9500\u552e\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            statisticsOfSales = "\u662f".equalsIgnoreCase(statisticsOfSales) ? "1" : "0";
            String code = platformName.concat(salesVolumeChannel);
            Validate.isTrue((!verifyCodes.contains(code) ? 1 : 0) != 0, (String)("\u5bfc\u5165\u6570\u636e\u5e73\u53f0\u4e3a\uff1a" + platformName + "\u9500\u91cf\u6e20\u9053\u4e3a\uff1a" + salesVolumeChannel + "\u7684\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01"), (Object[])new Object[0]);
            verifyCodes.add(code);
            TpmSalesVolumeChannelDto channelDto = new TpmSalesVolumeChannelDto();
            channelDto.setPlatformName(platformName);
            channelDto.setPlatformCode(platformMap.get(platformName));
            channelDto.setSalesVolumeChannel(salesVolumeChannel);
            channelDto.setStatisticsOfSales(statisticsOfSales);
            list.add(channelDto);
        }
        List salesVolumeChannelCodeList = this.generateCodeService.generateCode("SVC", list.size(), Integer.valueOf(5), 2L, TimeUnit.DAYS);
        for (int i = 0; i < list.size(); ++i) {
            ((TpmSalesVolumeChannelDto)list.get(i)).setSalesVolumeChannelCode((String)salesVolumeChannelCodeList.get(i));
        }
        return list;
    }

    private Map<String, String> findValuesToCodesMap(Map<String, List<DictDataVo>> mapDict, String dictTypeCode) {
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(vos), (String)"\u672a\u627e\u5230\u3010\u5e73\u53f0\u3011\u6570\u636e\u5b57\u5178", (Object[])new Object[0]);
        return vos.stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode, (e1, e2) -> e1));
    }

    public Class<TpmSalesVolumeChannelImportsVo> findCrmExcelVoClass() {
        return TpmSalesVolumeChannelImportsVo.class;
    }

    public String getTemplateCode() {
        return "TPM_SALES_VOLUME_CHANNEL_IMPORT";
    }

    public String getTemplateName() {
        return "TPM\u9500\u91cf\u6e20\u9053\u5bfc\u5165";
    }
}

