/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.volume.channel.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.tpm.business.sales.volume.channel.local.entity.TpmSalesVolumeChannel;
import com.biz.crm.tpm.business.sales.volume.channel.local.repository.TpmSalesVolumeChannelRepository;
import com.biz.crm.tpm.business.sales.volume.channel.local.service.SalesVolumeChannelTransService;
import com.biz.crm.tpm.business.sales.volume.channel.sdk.dto.TpmDataListDto;
import com.biz.crm.tpm.business.sales.volume.channel.sdk.dto.TpmSalesVolumeChannelDto;
import com.biz.crm.tpm.business.sales.volume.channel.sdk.dto.log.SalesVolumeChannelLogEventDto;
import com.biz.crm.tpm.business.sales.volume.channel.sdk.event.log.SalesVolumeChannelEventListener;
import com.biz.crm.tpm.business.sales.volume.channel.sdk.service.TpmSalesVolumeChannelService;
import com.biz.crm.tpm.business.sales.volume.channel.sdk.vo.TpmSalesVolumeChannelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tpmSalesVolumeChannelService")
public class TpmSalesVolumeChannelServiceImpl
implements TpmSalesVolumeChannelService {
    @Autowired(required=false)
    private TpmSalesVolumeChannelRepository tpmSalesVolumeChannelRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SalesVolumeChannelTransService salesVolumeChannelTransService;

    public TpmSalesVolumeChannelVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        TpmSalesVolumeChannel activityContractConfig = (TpmSalesVolumeChannel)((Object)this.tpmSalesVolumeChannelRepository.getById((Serializable)((Object)id)));
        if (ObjectUtils.isEmpty((Object)((Object)activityContractConfig))) {
            return null;
        }
        return (TpmSalesVolumeChannelVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityContractConfig, TpmSalesVolumeChannelVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List businessPolicyList1 = this.tpmSalesVolumeChannelRepository.listByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)businessPolicyList1) ? 1 : 0) != 0, (String)"\u8981\u5220\u9664\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList<TpmSalesVolumeChannel> tpmSalesVolumeChannelList = new ArrayList<TpmSalesVolumeChannel>();
        businessPolicyList1.forEach(item -> {
            TpmSalesVolumeChannel tpmSalesVolumeChannel = new TpmSalesVolumeChannel();
            tpmSalesVolumeChannel.setId(item.getId());
            tpmSalesVolumeChannel.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            tpmSalesVolumeChannelList.add(tpmSalesVolumeChannel);
            SalesVolumeChannelLogEventDto logEventDto = new SalesVolumeChannelLogEventDto();
            TpmSalesVolumeChannelVo oldVo = (TpmSalesVolumeChannelVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, TpmSalesVolumeChannelVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            logEventDto.setOriginal(oldVo);
            TpmSalesVolumeChannelDto tpmSalesVolumeChannelDto = (TpmSalesVolumeChannelDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, TpmSalesVolumeChannelDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            tpmSalesVolumeChannelDto.setDelFlag(tpmSalesVolumeChannel.getDelFlag());
            logEventDto.setNewest(tpmSalesVolumeChannelDto);
            SerializableBiConsumer & Serializable onDelete = SalesVolumeChannelEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SalesVolumeChannelEventListener.class, (SerializableBiConsumer)onDelete);
        });
        this.salesVolumeChannelTransService.updateDataList(tpmSalesVolumeChannelList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(TpmDataListDto dto) {
        this.createValidate(dto);
        List tpmSalesVolumeChannelDtos = dto.getTpmSalesVolumeChannelDtos();
        String tenantCode = TenantUtils.getTenantCode();
        String del = DelFlagStatusEnum.NORMAL.getCode();
        String code = EnableStatusEnum.ENABLE.getCode();
        ArrayList list = new ArrayList();
        List salesVolumeChannelCodeList = this.generateCodeService.generateCode("SVC", tpmSalesVolumeChannelDtos.size(), Integer.valueOf(5), 2L, TimeUnit.DAYS);
        AtomicInteger index = new AtomicInteger();
        tpmSalesVolumeChannelDtos.forEach(tpmSalesVolumeChannelDto -> {
            tpmSalesVolumeChannelDto.setSalesVolumeChannelCode((String)salesVolumeChannelCodeList.get(index.getAndIncrement()));
            tpmSalesVolumeChannelDto.setTenantCode(tenantCode);
            tpmSalesVolumeChannelDto.setDelFlag(del);
            tpmSalesVolumeChannelDto.setEnableStatus(code);
            list.add(tpmSalesVolumeChannelDto);
            SalesVolumeChannelLogEventDto logEventDto = new SalesVolumeChannelLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(tpmSalesVolumeChannelDto);
            SerializableBiConsumer & Serializable onCreate = SalesVolumeChannelEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SalesVolumeChannelEventListener.class, (SerializableBiConsumer)onCreate);
        });
        List tpmSalesVolumeChannels = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, TpmSalesVolumeChannelDto.class, TpmSalesVolumeChannel.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.salesVolumeChannelTransService.saveDataList(tpmSalesVolumeChannels);
    }

    public Page<TpmSalesVolumeChannelVo> findByConditions(Pageable pageable, TpmSalesVolumeChannelDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new TpmSalesVolumeChannelDto();
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getCustomerCode())) {
            List customerVoList = this.customerVoService.findByCustomerCodes(Arrays.asList(dto.getCustomerCode()));
            if (!CollectionUtils.isEmpty((Collection)customerVoList)) {
                dto.setPlatformCode(((CustomerVo)customerVoList.get(0)).getEstorePlatform());
            } else {
                return new Page();
            }
        }
        return this.tpmSalesVolumeChannelRepository.findByConditions(pageable, dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(TpmSalesVolumeChannelDto dto) {
        this.updateValidate(dto);
        TpmSalesVolumeChannelVo oldVo = this.findById(dto.getId());
        TpmSalesVolumeChannel tpmSalesVolumeChannel = (TpmSalesVolumeChannel)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmSalesVolumeChannel.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.tpmSalesVolumeChannelRepository.saveOrUpdate((Object)tpmSalesVolumeChannel);
        SalesVolumeChannelLogEventDto logEventDto = new SalesVolumeChannelLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onUpdate = SalesVolumeChannelEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SalesVolumeChannelEventListener.class, (SerializableBiConsumer)onUpdate);
    }

    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List tpmSalesVolumeChannelList = this.tpmSalesVolumeChannelRepository.listByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)tpmSalesVolumeChannelList) ? 1 : 0) != 0, (String)"\u542f\u7528\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList<TpmSalesVolumeChannel> activityContractConfigList = new ArrayList<TpmSalesVolumeChannel>();
        tpmSalesVolumeChannelList.forEach(item -> {
            TpmSalesVolumeChannel tpmSalesVolumeChannel = new TpmSalesVolumeChannel();
            tpmSalesVolumeChannel.setId(item.getId());
            tpmSalesVolumeChannel.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            activityContractConfigList.add(tpmSalesVolumeChannel);
            SalesVolumeChannelLogEventDto logEventDto = new SalesVolumeChannelLogEventDto();
            TpmSalesVolumeChannelVo oldVo = (TpmSalesVolumeChannelVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, TpmSalesVolumeChannelVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            logEventDto.setOriginal(oldVo);
            TpmSalesVolumeChannelDto tpmSalesVolumeChannelDto = (TpmSalesVolumeChannelDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, TpmSalesVolumeChannelDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            tpmSalesVolumeChannelDto.setEnableStatus(tpmSalesVolumeChannel.getEnableStatus());
            logEventDto.setNewest(tpmSalesVolumeChannelDto);
            SerializableBiConsumer & Serializable onEnable = SalesVolumeChannelEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SalesVolumeChannelEventListener.class, (SerializableBiConsumer)onEnable);
        });
        this.salesVolumeChannelTransService.updateDataList(activityContractConfigList);
    }

    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List tpmSalesVolumeChannelList = this.tpmSalesVolumeChannelRepository.listByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)tpmSalesVolumeChannelList) ? 1 : 0) != 0, (String)"\u7981\u7528\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList<TpmSalesVolumeChannel> activityContractConfigList = new ArrayList<TpmSalesVolumeChannel>();
        tpmSalesVolumeChannelList.forEach(item -> {
            TpmSalesVolumeChannel tpmSalesVolumeChannel = new TpmSalesVolumeChannel();
            tpmSalesVolumeChannel.setId(item.getId());
            tpmSalesVolumeChannel.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            activityContractConfigList.add(tpmSalesVolumeChannel);
            SalesVolumeChannelLogEventDto logEventDto = new SalesVolumeChannelLogEventDto();
            TpmSalesVolumeChannelVo oldVo = (TpmSalesVolumeChannelVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, TpmSalesVolumeChannelVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            logEventDto.setOriginal(oldVo);
            TpmSalesVolumeChannelDto tpmSalesVolumeChannelDto = (TpmSalesVolumeChannelDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, TpmSalesVolumeChannelDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            tpmSalesVolumeChannelDto.setEnableStatus(tpmSalesVolumeChannel.getEnableStatus());
            logEventDto.setNewest(tpmSalesVolumeChannelDto);
            SerializableBiConsumer & Serializable onDisable = SalesVolumeChannelEventListener::onDisable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SalesVolumeChannelEventListener.class, (SerializableBiConsumer)onDisable);
        });
        this.salesVolumeChannelTransService.updateDataList(activityContractConfigList);
    }

    public void importSave(List<TpmSalesVolumeChannelDto> importList) {
        if (CollectionUtils.isEmpty(importList)) {
            return;
        }
        TpmDataListDto tpmDataListDto = new TpmDataListDto();
        tpmDataListDto.setTpmSalesVolumeChannelDtos(importList);
        this.createValidate(tpmDataListDto);
        Collection entities = this.nebulaToolkitService.copyCollectionByWhiteList(importList, TpmSalesVolumeChannelDto.class, TpmSalesVolumeChannel.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        ArrayList entityList = Lists.newArrayList((Iterable)entities);
        String tenantCode = TenantUtils.getTenantCode();
        for (int i = 0; i < importList.size(); ++i) {
            TpmSalesVolumeChannel e = (TpmSalesVolumeChannel)((Object)entityList.get(i));
            String salesVolumeChannelCode = (String)this.generateCodeService.generateCode("SVC", 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
            e.setSalesVolumeChannelCode(salesVolumeChannelCode);
            e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            e.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            e.setTenantCode(tenantCode);
        }
        this.salesVolumeChannelTransService.saveDataList(entityList);
        importList.forEach(dto -> {
            SalesVolumeChannelLogEventDto logEventDto = new SalesVolumeChannelLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = SalesVolumeChannelEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SalesVolumeChannelEventListener.class, (SerializableBiConsumer)onCreate);
        });
    }

    public List<TpmSalesVolumeChannelVo> findByCodeList(List<String> codeList) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tpmSalesVolumeChannelRepository.lambdaQuery().in(TpmSalesVolumeChannel::getSalesVolumeChannelCode, codeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
        return list == null ? new ArrayList<TpmSalesVolumeChannelVo>() : new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, TpmSalesVolumeChannel.class, TpmSalesVolumeChannelVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
    }

    private void createValidate(TpmDataListDto dto) {
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List tpmSalesVolumeChannelDtos = dto.getTpmSalesVolumeChannelDtos();
        Validate.notNull((Object)tpmSalesVolumeChannelDtos, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        tpmSalesVolumeChannelDtos.forEach(tpmSalesVolumeChannelDto -> {
            tpmSalesVolumeChannelDto.setId(null);
            String platformName = tpmSalesVolumeChannelDto.getPlatformName();
            Validate.notBlank((CharSequence)platformName, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            String salesVolumeChannel = tpmSalesVolumeChannelDto.getSalesVolumeChannel();
            Validate.notBlank((CharSequence)salesVolumeChannel, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9500\u91cf\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)tpmSalesVolumeChannelDto.getStatisticsOfSales(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u662f\u5426\u53ef\u4ee5\u7edf\u8ba1\u9500\u552e\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((boolean)this.repeatValidate((TpmSalesVolumeChannelDto)tpmSalesVolumeChannelDto), (String)("\u6570\u636e\u5e93\u5b58\u5728\u5e73\u53f0\u4e3a\uff1a" + platformName + "\u9500\u91cf\u6e20\u9053\u4e3a\uff1a" + salesVolumeChannel + "\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01"), (Object[])new Object[0]);
        });
    }

    private void updateValidate(TpmSalesVolumeChannelDto dto) {
        Validate.notNull((Object)dto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSalesVolumeChannelCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPlatformName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSalesVolumeChannel(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9500\u91cf\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getStatisticsOfSales(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u662f\u5426\u53ef\u4ee5\u7edf\u8ba1\u9500\u552e\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private Boolean repeatValidate(TpmSalesVolumeChannelDto dto) {
        return this.tpmSalesVolumeChannelRepository.repeatValidate(dto);
    }
}

