package com.biz.crm.tpm.business.scheme.forecast.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanPassMqTagConstant;
import com.biz.crm.tpm.business.detailed.forecast.sdk.constant.DeatailedForecastConstants;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.SchemeForecastEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.repository.SchemeForecastRepository;
import com.biz.crm.tpm.business.scheme.forecast.local.util.ActivityDetailPlanPassSchemeForecastUtil;
import com.biz.crm.tpm.business.scheme.forecast.sdk.constants.SchemeForecastConstants;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.service.SchemeForecastService;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.SchemeForecastVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @author wanghaojia
 * @date 2023/1/16 19:59
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = ActivityPlanConstant.TPM_ACTIVITY_PLAN_PROCESS_PASS_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = ActivityPlanPassMqTagConstant.SCHEME_FORECAST_REFRESH,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = ActivityPlanPassMqTagConstant.SCHEME_FORECAST_REFRESH + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class ActivityDetailPlanPassSchemeForecastRefreshConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private ActivityDetailPlanPassSchemeForecastUtil activityDetailPlanPassSchemeForecastUtil;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private SchemeForecastRepository schemeForecastRepository;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("方案预测表更新 order mq message received  : {}", message);
        if (Objects.isNull(message)
                || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }
        try {
            Object o = redisService.hGet(SchemeForecastConstants.REFRESH_IDS_KEY, message.getMsgBody());
            if (Objects.isNull(o) || StringUtils.isEmpty(o.toString())) {
                return "缓存ids已过期!";
            }

            List<String> ids = JSON.parseArray(o.toString(), String.class);
            List<SchemeForecastEntity> entityList = schemeForecastRepository.findByIds(ids);
            if (CollectionUtils.isEmpty(entityList)) {
                return "消费警告. 消费对象数据查询为空！";
            }
            UserIdentity loginUser = loginUserService.getLoginUser();
            entityList.forEach(entity -> {
                try {
                    activityDetailPlanPassSchemeForecastUtil.refreshUpdate(entity, loginUser);
                } catch (Exception e) {
                    log.error("方案编码[{}]方案明细编码[{}]方案预测刷新计算失败：{}", entity.getSchemeCode(), entity.getSchemeItemCode(), e.getMessage());
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            log.error("方案预测表更新处理失败" + e.getMessage(), e);
            return "消费失败." + e.getMessage();
        }
        return "消费成功.";
    }

    public void handleMessageTest(MqMessageVo vo) {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        redisService.hSet(SchemeForecastConstants.REFRESH_IDS_KEY, uuid, vo.getMsgBody(), 60 * 60 * 48);//定时任务每天跑，缓存2天够了
        vo.setMsgBody(uuid);
        this.handleMessage(vo);
    }
}
