package com.biz.crm.tpm.business.scheme.forecast.local.consumer;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.constant.DictConstant;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgLevelTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgAllParentVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanPassMqTagConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanPassMqTagEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanStrategyVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.enums.MarketingStrategyTypeEnum;
import com.biz.crm.tpm.business.scheme.forecast.local.service.internal.TpmHeadSchemeForecastAsync;
import com.biz.crm.tpm.business.scheme.forecast.local.util.TpmHeadSchemeForecastUtil;
import com.biz.crm.tpm.business.scheme.forecast.local.util.TpmHeadSchemeForecastBuilder;
import com.biz.crm.tpm.business.scheme.forecast.sdk.constants.TpmHeadSchemeForecastConstants;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmHeadSchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmHeadSchemeForecastDto;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author wanghaojia
 * @date 2023/1/16 19:59
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = ActivityPlanConstant.TPM_ACTIVITY_PLAN_PROCESS_PASS_TOPIC + "${rocketmq.environment}",
        /**
         * tag 可用 || 监听多个tag： "tag1 || tag2 || tag3" 请把tag 定义在 *** 内 需要统一维护
        */
        selectorExpression = ActivityPlanPassMqTagConstant.PASS_TPM_HEAD_SCHEME_FORECAST,
        /**
         * 相同分组下 consumer 可自动负载均衡 请把consumerGroup 定义在 *** 内 需要统一维护
        */
        consumerGroup = ActivityPlanPassMqTagConstant.PASS_TPM_HEAD_SCHEME_FORECAST + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant 可以设置 ConsumeMode.ORDERLY 使用广播消费 也可使用集群模式模拟广播模式： 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.ORDERLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class ActivityPlanPassTpmHeadSchemeForecastConsumer extends AbstractRocketMqConsumer {


    @Autowired(required = false)
    private ActivityPlanSdkService activityPlanSdkService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Autowired(required = false)
    private TpmHeadSchemeForecastAsync tpmHeadSchemeForecastAsync;

    @Autowired(required = false)
    private TpmHeadSchemeForecastUtil tpmHeadSchemeForecastUtil;

    @Override
    public Object handleMessage(MqMessageVo message) {
        log.info("活动方案审批通过推送主体方案预测 order mq message received  : {}", message);
        if (Objects.isNull(message) || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }
        deal:try {
            List<String> businessNoList = JSON.parseArray(message.getMsgBody(), String.class);
            UserIdentity loginUser = loginUserService.getLoginUser();
            List<ActivityPlanDto> dtoList = activityPlanSdkService.findPlanDtoListByCodeList(businessNoList);
            if (CollectionUtil.isEmpty(dtoList)) {
                break deal;
            }
            //先过滤一遍，只生成主体大区方案，
            Iterator<ActivityPlanDto> iterator = dtoList.iterator();
            while (iterator.hasNext()){
                ActivityPlanDto activityPlanDto = iterator.next();
                if (!StringUtils.equals(ActivityPlanTypeEnum.region.getCode(), activityPlanDto.getPlanType())) {
                    //只有大区方案生成
                    log.info("主体：非大区方案不生成主体方案预测");
                    iterator.remove();
                    continue ;
                }

                if (!StringUtils.equals(BusinessUnitEnum.HEADQUARTERS.getCode(), activityPlanDto.getBusinessUnitCode())) {
                    log.info("主体：非主体方案不生成主体方案预测");
                    //只有主体方案生成
                    iterator.remove();
                    continue ;
                }
            }
            if (CollectionUtil.isEmpty(dtoList)) {
                break deal;
            }
            //1035362 【全环境-主体方案预测表】BUG
            businessNoList = dtoList.stream().map(ActivityPlanDto::getPlanCode).collect(Collectors.toList());
            List<ActivityPlanStrategyVo> activityPlanStrategyVoList = activityPlanSdkService.findActivityPlanStrategyVoList(businessNoList);
            Map<String, List<ActivityPlanStrategyVo>> strategyMap = activityPlanStrategyVoList.stream().collect(Collectors.groupingBy(ActivityPlanStrategyVo::getPlanCode));
            iterator = dtoList.iterator();
            while (iterator.hasNext()){
                ActivityPlanDto activityPlanDto = iterator.next();
                if (!strategyMap.containsKey(activityPlanDto.getPlanCode())){
                    continue ;
                }
                List<ActivityPlanStrategyVo> activityPlanStrategyVos = strategyMap.get(activityPlanDto.getPlanCode());
                for (ActivityPlanStrategyVo activityPlanStrategyVo : activityPlanStrategyVos) {
                    if (MarketingStrategyTypeEnum.Region_strategy.getCode().equals(activityPlanStrategyVo.getStrategyType())){
                        iterator.remove();
                        break;
                    }
                }
            }
            if (CollectionUtil.isEmpty(dtoList)) {
                break deal;
            }
            businessNoList = dtoList.stream().map(ActivityPlanDto::getPlanCode).collect(Collectors.toList());
            //过滤完了再组装方案明细数据
            List<ActivityPlanItemDto> itemList = activityPlanSdkService.findItemDtoAndAttachListByPlanCodeList(businessNoList);
            Map<String, List<ActivityPlanItemDto>> planItemMap = itemList.stream().collect(Collectors.groupingBy(ActivityPlanItemDto::getPlanCode));
            for (ActivityPlanDto planDto : dtoList) {
                if (planItemMap.containsKey(planDto.getPlanCode())){
                    planDto.setItemList(planItemMap.get(planDto.getPlanCode()));
                }
            }

            Map<String, String> regionMap = dictToolkitService.findMapByDictTypeCode(DictConstant.MDM_CUSTOMIZE_ORG);
                dtoList.forEach(activityPlanDto -> {
                    if (Objects.isNull(activityPlanDto) || CollectionUtil.isEmpty(activityPlanDto.getItemList())) {
                        return;
                    }
                    List<String> cusCodes = activityPlanDto.getItemList().stream()
                            .filter(e -> StringUtils.isNotEmpty(e.getCustomerCode())).map(ActivityPlanItemDto::getCustomerCode).distinct().collect(Collectors.toList());
                    Map<String, CustomerVo> customerVoMap = new HashMap<>();
                    if (!org.springframework.util.CollectionUtils.isEmpty(cusCodes)) {
                        //指标有的表里面没有客户拼接后编码，强校验了erp编码
                        List<CustomerVo> customerVos = customerVoService.findBaseByCustomerCodes(cusCodes);
                        if (!org.springframework.util.CollectionUtils.isEmpty(customerVos)) {
                            customerVoMap.putAll(
                                    customerVos.stream()
                                            .filter(e -> StringUtils.isNotEmpty(e.getErpCode()))
                                            .collect(Collectors.toMap(CustomerVo::getCustomerCode, v -> v)));
                        }
                    }

                    List<String> salesOrgCodes = activityPlanDto.getItemList().stream().filter(e -> StringUtils.isNotEmpty(e.getActivityOrgCode())).map(ActivityPlanItemDto::getActivityOrgCode).distinct().collect(Collectors.toList());
                    List<String> allRegionCodes = salesOrgCodes.stream().filter(e -> StringUtils.equals(TpmHeadSchemeForecastConstants.all_region_code, e)).collect(Collectors.toList());
                    Map<String, Set<String>> allReginMap = new HashMap<>();
                    if (CollectionUtils.isNotEmpty(allRegionCodes)) {
                        List<SalesOrgVo> allChildrenVos = salesOrgVoService.findAllChildrenBySalesOrgCodes(allRegionCodes);
                        if (CollectionUtils.isNotEmpty(allChildrenVos)) {
                            Map<String, Set<String>> map = allChildrenVos.stream()
                                    .filter(e -> StringUtils.equals(SalesOrgLevelTypeEnum.DEPARTMENT.getCode(), e.getSalesOrgType()))
                                    .collect(Collectors.groupingBy(SalesOrgVo::getParentCode,
                                            Collectors.mapping(SalesOrgVo::getSalesOrgCode, Collectors.toSet())));
                            allReginMap.putAll(map);
                            for (Set<String> values : allReginMap.values()) {
                                salesOrgCodes.addAll(Lists.newArrayList(values));
                            }
                        }
                    }

                    Map<String, SalesOrgAllParentVo> salesOrgVoMap = new HashMap<>();
                    if (CollectionUtils.isNotEmpty(salesOrgCodes)) {
                        List<SalesOrgAllParentVo> list = salesOrgVoService.findSalesOrgIncludeAllParentByCodes(salesOrgCodes);
                        salesOrgVoMap.putAll(
                                list.stream().collect(Collectors.toMap(SalesOrgAllParentVo::getCurrSalesOrgCode, v -> v, (v1, v2) -> v2)));
                    }

                    activityPlanDto.getItemList().forEach(item -> {
                        CustomerVo customerVo = null;
                        if (StringUtils.isNotEmpty(item.getCustomerCode())) {
                            customerVo = customerVoMap.get(item.getCustomerCode());
                        }
                        List<TpmHeadSchemeForecastDto> schemeForecastDtoList = tpmHeadSchemeForecastUtil.buildDtoList(activityPlanDto, item, regionMap, allReginMap, customerVo, salesOrgVoMap);
                        //主体
                        try {
                            //先删掉历史数据
                            tpmHeadSchemeForecastAsync.deleteBySchemeItemCode(item.getPlanItemCode());
                            for (TpmHeadSchemeForecastDto schemeForecastDto : schemeForecastDtoList) {
                                tpmHeadSchemeForecastAsync.createData(schemeForecastDto, item, loginUser);
                            }
                        } catch (Exception e) {
                            log.error("方案编码[{}]方案明细编码[{}]方案预测生成失败：{}", item.getPlanCode(), item.getPlanItemCode(), e.getMessage());
                        }
                    });
                });
        } catch (Exception e) {
            log.error(ActivityPlanPassMqTagEnum.PASS_TPM_HEAD_SCHEME_FORECAST.getName() + "处理失败" + e.getMessage(), e);
            return "消费失败." + e.getMessage();
        }
        return "消费成功.";
    }
}
