package com.biz.crm.tpm.business.scheme.forecast.local.consumer;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.constant.DictConstant;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgAllParentVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanPassMqTagConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanPassMqTagEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanTemplateSdkService;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.scheme.forecast.local.service.internal.TpmVerticalSchemeForecastAsync;
import com.biz.crm.tpm.business.scheme.forecast.local.util.ActivityDetailPlanPassSchemeForecastUtil;
import com.biz.crm.tpm.business.scheme.forecast.local.util.ActivitySchemePlanPassSchemeForecastBuilder;
import com.biz.crm.tpm.business.scheme.forecast.local.util.TpmVerticalSchemeForecastBuilder;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmVerticalSchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.service.SchemeForecastService;
import com.biz.crm.tpm.business.variable.sdk.service.VariableService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author wanghaojia
 * @date 2023/1/16 19:59
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = ActivityPlanConstant.TPM_ACTIVITY_PLAN_PROCESS_PASS_TOPIC + "${rocketmq.environment}",
        /**
         * tag 可用 || 监听多个tag： "tag1 || tag2 || tag3" 请把tag 定义在 *** 内 需要统一维护
        */
        selectorExpression = ActivityPlanPassMqTagConstant.PASS_TPM_VERTICAL_SCHEME_FORECAST,
        /**
         * 相同分组下 consumer 可自动负载均衡 请把consumerGroup 定义在 *** 内 需要统一维护
        */
        consumerGroup = ActivityPlanPassMqTagConstant.PASS_TPM_VERTICAL_SCHEME_FORECAST + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant 可以设置 ConsumeMode.ORDERLY 使用广播消费 也可使用集群模式模拟广播模式： 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class ActivityPlanPassTpmVerticalSchemeForecastConsumer extends AbstractRocketMqConsumer {


    @Autowired(required = false)
    private ActivityPlanSdkService activityPlanSdkService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Autowired(required = false)
    private TpmVerticalSchemeForecastAsync tpmVerticalSchemeForecastAsync;

    @Override
    public Object handleMessage(MqMessageVo message) {
        log.info("活动方案审批通过推送垂直大区方案兑付 order mq message received  : {}", message);
        if (Objects.isNull(message) || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }
        try {
            List<String> businessNoList = JSON.parseArray(message.getMsgBody(), String.class);
            UserIdentity loginUser = loginUserService.getLoginUser();
            List<ActivityPlanDto> dtoList = activityPlanSdkService.buildActivityPlanParms(businessNoList);
            if (CollectionUtil.isNotEmpty(dtoList)) {
                Map<String, String> regionMap = dictToolkitService.findMapByDictTypeCode(DictConstant.MDM_CUSTOMIZE_ORG);
                dtoList.forEach(activityPlanDto -> {
                    if (Objects.isNull(activityPlanDto) || CollectionUtil.isEmpty(activityPlanDto.getItemList())) {
                        return;
                    }

                    if (!StringUtils.equals(ActivityPlanTypeEnum.headquarters.getCode(), activityPlanDto.getPlanType())) {
                        //只有总部方案生成
                        return;
                    }

                    if (!StringUtils.equals(BusinessUnitEnum.VERTICAL.getCode(), activityPlanDto.getBusinessUnitCode())) {
                        //只有垂直方案生成
                        return;
                    }

                    List<String> cusCodes = activityPlanDto.getItemList().stream()
                            .filter(e -> StringUtils.isNotEmpty(e.getCustomerCode())).map(ActivityPlanItemDto::getCustomerCode).distinct().collect(Collectors.toList());
                    Map<String, CustomerVo> customerVoMap = new HashMap<>();
                    if (!org.springframework.util.CollectionUtils.isEmpty(cusCodes)) {
                        //指标有的表里面没有客户拼接后编码，强校验了erp编码
                        List<CustomerVo> customerVos = customerVoService.findBaseByCustomerCodes(cusCodes);
                        if (!org.springframework.util.CollectionUtils.isEmpty(customerVos)) {
                            customerVoMap.putAll(
                                    customerVos.stream()
                                            .filter(e -> StringUtils.isNotEmpty(e.getErpCode()))
                                            .collect(Collectors.toMap(CustomerVo::getCustomerCode, v -> v)));
                        }
                    }

                    List<String> salesOrgCodes = activityPlanDto.getItemList().stream().filter(e -> StringUtils.isNotEmpty(e.getActivityOrgCode())).map(ActivityPlanItemDto::getActivityOrgCode).distinct().collect(Collectors.toList());
                    Map<String, SalesOrgAllParentVo> salesOrgVoMap = new HashMap<>();
                    if (CollectionUtils.isNotEmpty(salesOrgCodes)) {
                        List<SalesOrgAllParentVo> list = salesOrgVoService.findSalesOrgIncludeAllParentByCodes(salesOrgCodes);
                        salesOrgVoMap.putAll(
                                list.stream().collect(Collectors.toMap(SalesOrgAllParentVo::getCurrSalesOrgCode, v -> v, (v1, v2) -> v2)));
                    }

                    activityPlanDto.getItemList().forEach(item -> {
                        SalesOrgAllParentVo salesOrgAllParentVo = null;
                        CustomerVo customerVo = null;
                        if (StringUtils.isNotEmpty(item.getCustomerCode())) {
                            customerVo = customerVoMap.get(item.getCustomerCode());
                        }
                        if (StringUtils.isNotEmpty(item.getActivityOrgCode())) {
                            salesOrgAllParentVo = salesOrgVoMap.get(item.getActivityOrgCode());
                        }
                        List<TpmVerticalSchemeForecastDto> schemeForecastDtoList = TpmVerticalSchemeForecastBuilder.buildDtoList(activityPlanDto, item, regionMap, customerVo, salesOrgAllParentVo);
                        //垂直
                        try {
                            for (TpmVerticalSchemeForecastDto schemeForecastDto : schemeForecastDtoList) {
                                tpmVerticalSchemeForecastAsync.createData(schemeForecastDto, item, loginUser);
                            }
                        } catch (Exception e) {
                            log.error("方案编码[{}]方案明细编码[{}]方案预测生成失败：{}", item.getPlanCode(), item.getPlanItemCode(), e.getMessage());
                            e.printStackTrace();
                        }
                    });
                });
            }
        } catch (Exception e) {
            log.error(ActivityPlanPassMqTagEnum.PASS_TPM_VERTICAL_SCHEME_FORECAST.getName() + "处理失败" + e.getMessage(), e);
            return "消费失败." + e.getMessage();
        }
        return "消费成功.";
    }
}
