package com.biz.crm.tpm.business.scheme.forecast.local.consumer;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.constant.DictConstant;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgLevelTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgAllParentVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanPassMqTagConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanPassMqTagEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanStrategyVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.enums.MarketingStrategyTypeEnum;
import com.biz.crm.tpm.business.scheme.forecast.local.service.internal.TpmHeadSchemeForecastAsync;
import com.biz.crm.tpm.business.scheme.forecast.local.util.TpmHeadSchemeForecastUtil;
import com.biz.crm.tpm.business.scheme.forecast.sdk.constants.TpmHeadSchemeForecastConstants;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmHeadSchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.service.TpmHeadSchemeForecastService;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 主体方案预测跟踪表更新核销扣减差额
 * @author wanghaojia
 * @date 2023/1/16 19:59
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = ActivityPlanConstant.TPM_ACTIVITY_PLAN_PROCESS_PASS_TOPIC + "${rocketmq.environment}",
        /**
         * tag 可用 || 监听多个tag： "tag1 || tag2 || tag3" 请把tag 定义在 *** 内 需要统一维护
        */
        selectorExpression = ActivityPlanPassMqTagConstant.TPM_HEAD_SCHEME_FORECAST_REFRESH_AUDIT_REDUCE,
        /**
         * 相同分组下 consumer 可自动负载均衡 请把consumerGroup 定义在 *** 内 需要统一维护
        */
        consumerGroup = ActivityPlanPassMqTagConstant.TPM_HEAD_SCHEME_FORECAST_REFRESH_AUDIT_REDUCE + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant 可以设置 ConsumeMode.ORDERLY 使用广播消费 也可使用集群模式模拟广播模式： 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class TpmHeadSchemeForecastRefreshAuditDeduceConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private TpmHeadSchemeForecastService tpmHeadSchemeForecastService;

    @Override
    public Object handleMessage(MqMessageVo message) {
        log.info("核销上账成功更新主体方案预测跟踪表核销扣减金额 order mq message received  : {}", message);
        if (Objects.isNull(message) || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }
        try{
            List<String> detailPlanItemCodeList = JSON.parseArray(message.getMsgBody(), String.class);
            tpmHeadSchemeForecastService.updateAuditReduceAmount(detailPlanItemCodeList);
        } catch (Exception e) {
            log.error("核销上账成功更新主体方案预测跟踪表核销扣减金额处理失败" + e.getMessage(), e);
            return "消费失败." + e.getMessage();
        }
        return "消费成功.";
    }
}
