package com.biz.crm.tpm.business.scheme.forecast.local.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanPassMqTagConstant;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastInitDto;
import com.biz.crm.tpm.business.scheme.forecast.local.consumer.ActivityDetailPlanPassSchemeForecastRefreshConsumer;
import com.biz.crm.tpm.business.scheme.forecast.local.consumer.ActivityPlanPassSchemeForecastConsumer;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemePushSchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.service.SchemeForecastService;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.SchemeForecastVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Objects;

/**
 * @author youjun
 * @date 2022年11月10日 14:53
 */
@RestController
@RequestMapping("/v1/scheme/forecast")
@Slf4j
@Api(tags = "方案预测")
public class SchemeForecastController {

    /**
     * 服务对象
     */
    @Autowired
    private SchemeForecastService schemeForecastService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Autowired(required = false)
    private ActivityDetailPlanPassSchemeForecastRefreshConsumer activityDetailPlanPassSchemeForecastRefreshConsumer;

    /**
     * 分页查询所有数据
     *
     * @param pageable          分页对象
     * @param schemeForecastDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByForecasts")
    public Result<Page<SchemeForecastVo>> findByForecasts(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                          @ApiParam(name = "schemeForecastDto", value = "方案预测表") SchemeForecastDto schemeForecastDto) {
        try {
            Page<SchemeForecastVo> page = this.schemeForecastService.findByForecasts(pageable, schemeForecastDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增细案预测数据
     *
     * @param schemeForecastDto 实体对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping("create")
    public Result<?> create(@ApiParam(name = "schemeForecastDto", value = "方案预测表") @RequestBody SchemeForecastDto schemeForecastDto) {
        try {
            this.schemeForecastService.create(schemeForecastDto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 修改数据
     *
     * @param schemeForecastDto 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping
    public Result<?> update(@ApiParam(name = "schemeForecastDto", value = "方案预测表") @RequestBody SchemeForecastDto schemeForecastDto) {
        try {
            this.schemeForecastService.update(schemeForecastDto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 批量更新(重新计算预估可核销金额)
     *
     * @param idList 主键列表
     * @return 修改结果
     */
    @ApiOperation(value = "批量更新(重新计算预估可核销金额)")
    @PatchMapping("updateAuditAmount")
    public Result<?> updateAuditAmount(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
        try {
            this.schemeForecastService.updateAuditAmount(idList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 批量确认
     *
     * @param idList 主键列表
     * @return 修改结果
     */
    @ApiOperation(value = "确认")
    @PatchMapping("confirm")
    public Result<?> confirm(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
        try {
            this.schemeForecastService.confirm(idList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @PostMapping("delete")
    public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
        try {
            this.schemeForecastService.delete(idList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("{id}")
    public Result<SchemeForecastVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id", required = true) String id) {
        try {
            SchemeForecastVo schemeForecastVo = this.schemeForecastService.findById(id);
            return Result.ok(schemeForecastVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新数据不覆盖
     *
     * @param schemeForecastDto 主键
     * @return 更新数据不覆盖
     */
    @ApiOperation(value = "更新不覆盖数据")
    @PostMapping("updateSchemeForecast")
    public Result<?> updateDetailedForecast(@ApiParam(name = "schemeForecastDto", value = "方案预测表") @RequestBody SchemeForecastDto schemeForecastDto) {
        try {
            this.schemeForecastService.updateDetailedForecast(schemeForecastDto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("手动推送-活动方案推预测")
    @PostMapping("pushSchemeForecast")
    public Result pushSchemeForecast(@RequestBody SchemePushSchemeForecastDto dto) {
        Validate.notBlank(dto.getBusinessUnitCode(), "业务单元为空！");
        try {
            int pageNumber = 1;
            int pageSize = 50;
            while (true) {
                Page<String> page = new Page<>(pageNumber, pageSize);
                Page<String> pageList = null;
                if (BusinessUnitEnum.isDefaultBusinessUnit(dto.getBusinessUnitCode()) || BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                    pageList = schemeForecastService.findHeadVerticalCodeList(page, dto);
                } else {
                    throw new RuntimeException("手动推送-活动方案推预测=====>未定义该业务单元[" + dto.getBusinessUnitCode() + "]处理逻辑");
                }
                if (Objects.isNull(pageList) || CollectionUtils.isEmpty(pageList.getRecords())) {
                    break;
                }
                log.info("手动推送-活动方案推预测=====>{}, {}, {}", pageNumber, pageList.getRecords().size(), pageList.getTotal());
                MqMessageVo vo = new MqMessageVo();
                if (BusinessUnitEnum.isDefaultBusinessUnit(dto.getBusinessUnitCode()) || BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                    vo.setTopic(ActivityPlanConstant.TPM_ACTIVITY_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
                    vo.setTag(ActivityPlanPassMqTagConstant.PASS_SCHEME_FORECAST);
                    log.info("手动推送-活动方案推预测=====>{}", dto.getBusinessUnitCode());
                }
                vo.setMsgBody(JSONObject.toJSONString(pageList.getRecords()));
                log.info("手动推送-活动方案推预测=====>{}", JSONObject.toJSON(vo));
                rocketMqProducer.sendMqMsg(vo);
                Thread.sleep(200);
                pageNumber++;
            }
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("测试方案预测表更新")
    @PostMapping("testSchemeRefresh")
    public Result testRefresh(@RequestBody List<String> codeList) {
        try {
            MqMessageVo vo = new MqMessageVo();
            vo.setMsgBody(JSONObject.toJSONString(codeList));
            activityDetailPlanPassSchemeForecastRefreshConsumer.handleMessageTest(vo);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
