package com.biz.crm.tpm.business.scheme.forecast.local.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanPassMqTagConstant;
import com.biz.crm.tpm.business.scheme.forecast.local.util.TpmHeadSchemeForecastUtil;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemePushSchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmHeadSchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmHeadSchemeForecastSubmitDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmHeadSchemeForecastUploadFileDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.enums.TpmHeadSchemeWorkflowTypeEnum;
import com.biz.crm.tpm.business.scheme.forecast.sdk.service.SchemeForecastService;
import com.biz.crm.tpm.business.scheme.forecast.sdk.service.TpmHeadSchemeForecastService;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmHeadSchemeForecastActivityDetailPlanVo;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmHeadSchemeForecastUploadFileVo;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmHeadSchemeForecastVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-06-09
 */
@RestController
@RequestMapping("/v1/head/scheme/forecast")
@Slf4j
@Api(tags = "主体方案预测")
public class TpmHeadSchemeForecastController {

    @Autowired(required = false)
    private TpmHeadSchemeForecastService tpmHeadSchemeForecastService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private TpmHeadSchemeForecastUtil tpmHeadSchemeForecastUtil;

    /**
     * 服务对象
     */
    @Autowired
    private SchemeForecastService schemeForecastService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByForecasts")
    public Result<Page<TpmHeadSchemeForecastVo>> findByForecasts(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                 @ApiParam(name = "dto", value = "方案预测表") TpmHeadSchemeForecastDto dto) {
        try {
            Page<TpmHeadSchemeForecastVo> page = this.tpmHeadSchemeForecastService.findByForecasts(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "详情")
    @GetMapping("findById")
    public Result<TpmHeadSchemeForecastVo> findByForecasts(@RequestParam("id") String id) {
        try {
            return Result.ok(this.tpmHeadSchemeForecastService.findById(id));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "细案详情")
    @GetMapping("findActivityDetailPlanById")
    public Result<List<TpmHeadSchemeForecastActivityDetailPlanVo>> findActivityDetailPlanById(@RequestParam("id") String id) {
        try {
            return Result.ok(this.tpmHeadSchemeForecastService.findActivityDetailPlanById(id));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "资料详情")
    @GetMapping("findFileById")
    public Result<TpmHeadSchemeForecastUploadFileVo> findFileById(@RequestParam("id") String id) {
        try {
            return Result.ok(this.tpmHeadSchemeForecastService.findFileById(id));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "批量更新(重新计算预估可核销金额)")
    @PostMapping("updateAuditAmount")
    public Result<?> updateAuditAmount(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
        Validate.notNull(idList, "请选择数据");
        List<String> lockKeys = new ArrayList<>();
        try {
            lockKeys = tpmHeadSchemeForecastUtil.operateLock(idList);
            Validate.isTrue(idList.size() == lockKeys.size(), "数据正在被其他人操作，请稍后...");
            this.tpmHeadSchemeForecastService.updateAuditAmount(idList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        } finally {
            lockKeys.forEach(lockKey -> {
                redisLockService.unlock(lockKey);
            });
        }
    }

    @ApiOperation(value = "确认")
    @PostMapping("confirm")
    public Result<?> confirm(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
        Validate.notNull(idList, "请选择数据");
        List<String> lockKeys = new ArrayList<>();
        try {
            lockKeys = tpmHeadSchemeForecastUtil.operateLock(idList);
            Validate.isTrue(idList.size() == lockKeys.size(), "数据正在被其他人操作，请稍后...");
            this.tpmHeadSchemeForecastService.confirm(idList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        } finally {
            lockKeys.forEach(lockKey -> {
                redisLockService.unlock(lockKey);
            });
        }
    }

    @ApiOperation(value = "删除数据")
    @PostMapping("delete")
    public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
        Validate.notNull(idList, "请选择数据");
        List<String> lockKeys = new ArrayList<>();
        try {
            lockKeys = tpmHeadSchemeForecastUtil.operateLock(idList);
            Validate.isTrue(idList.size() == lockKeys.size(), "数据正在被其他人操作，请稍后...");
            this.tpmHeadSchemeForecastService.delete(idList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        } finally {
            lockKeys.forEach(lockKey -> {
                redisLockService.unlock(lockKey);
            });
        }
    }

    @ApiOperation(value = "上传资料")
    @PostMapping("uploadFile")
    public Result<?> uploadFile(@ApiParam(name = "dto", value = "提交对象") @RequestBody TpmHeadSchemeForecastUploadFileDto dto) {
        Validate.notBlank(dto.getId(), "请选择数据");
        List<String> lockKeys = new ArrayList<>();
        try {
            lockKeys = tpmHeadSchemeForecastUtil.operateLock(Lists.newArrayList(dto.getId()));
            Validate.notEmpty(lockKeys, "数据正在被其他人操作，请稍后...");
            this.tpmHeadSchemeForecastService.uploadFile(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        } finally {
            lockKeys.forEach(lockKey -> {
                redisLockService.unlock(lockKey);
            });
        }
    }

    @ApiOperation(value = "编辑")
    @PostMapping("edit")
    public Result<?> edit(@ApiParam(name = "dto", value = "提交对象") @RequestBody TpmHeadSchemeForecastDto dto) {
        Validate.notBlank(dto.getId(), "请选择数据");
        List<String> lockKeys = new ArrayList<>();
        try {
            lockKeys = tpmHeadSchemeForecastUtil.operateLock(Lists.newArrayList(dto.getId()));
            Validate.notEmpty(lockKeys, "数据正在被其他人操作，请稍后...");
            this.tpmHeadSchemeForecastService.edit(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        } finally {
            lockKeys.forEach(lockKey -> {
                redisLockService.unlock(lockKey);
            });
        }
    }

    @ApiOperation(value = "编辑扣减预算编码")
    @PostMapping("editMonthBudgetCodeDeduction")
    public Result<?> editMonthBudgetCodeDeduction(@ApiParam(name = "dto", value = "提交对象") @RequestBody TpmHeadSchemeForecastDto dto) {
        Validate.notBlank(dto.getId(), "请选择数据");
        List<String> lockKeys = new ArrayList<>();
        try {
            lockKeys = tpmHeadSchemeForecastUtil.operateLock(Lists.newArrayList(dto.getId()));
            Validate.notEmpty(lockKeys, "数据正在被其他人操作，请稍后...");
            this.tpmHeadSchemeForecastService.editMonthBudgetCodeDeduction(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        } finally {
            lockKeys.forEach(lockKey -> {
                redisLockService.unlock(lockKey);
            });
        }
    }

    @ApiOperation(value = "提交流程(总部)")
    @PostMapping("submitHead")
    public Result<?> submitHead(@ApiParam(name = "dto", value = "提交对象") @RequestBody TpmHeadSchemeForecastSubmitDto dto) {
        Validate.notNull(dto.getIdList(), "请选择数据");
        List<String> lockKeys = new ArrayList<>();
        try {
            lockKeys = tpmHeadSchemeForecastUtil.operateLock(dto.getIdList());
            Validate.isTrue(dto.getIdList().size() == lockKeys.size(), "数据正在被其他人操作，请稍后...");
            this.tpmHeadSchemeForecastService.submit(dto, TpmHeadSchemeWorkflowTypeEnum.HEAD);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        } finally {
            lockKeys.forEach(lockKey -> {
                redisLockService.unlock(lockKey);
            });
        }
    }

    @ApiOperation(value = "提交流程(大区)")
    @PostMapping("submitRegion")
    public Result<?> submitRegion(@ApiParam(name = "dto", value = "提交对象") @RequestBody TpmHeadSchemeForecastSubmitDto dto) {
        Validate.notNull(dto.getIdList(), "请选择数据");
        List<String> lockKeys = new ArrayList<>();
        try {
            lockKeys = tpmHeadSchemeForecastUtil.operateLock(dto.getIdList());
            Validate.isTrue(dto.getIdList().size() == lockKeys.size(), "数据正在被其他人操作，请稍后...");
            this.tpmHeadSchemeForecastService.submit(dto, TpmHeadSchemeWorkflowTypeEnum.REGION);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        } finally {
            lockKeys.forEach(lockKey -> {
                redisLockService.unlock(lockKey);
            });
        }
    }

    @ApiOperation("手动推送-活动方案推预测")
    @PostMapping("pushSchemeForecast")
    public Result pushSchemeForecast(@RequestBody SchemePushSchemeForecastDto dto) {
        Validate.notBlank(dto.getBusinessUnitCode(), "业务单元为空！");
        try {
            int pageNumber = 1;
            int pageSize = 50;
            while (true) {
                Page<String> page = new Page<>(pageNumber, pageSize);
                Page<String> pageList = null;
                if (BusinessUnitEnum.isDefaultBusinessUnit(dto.getBusinessUnitCode())) {
                    pageList = schemeForecastService.findHeadVerticalCodeList(page, dto);
                } else {
                    throw new RuntimeException("手动推送-主体方案推预测=====>未定义该业务单元[" + dto.getBusinessUnitCode() + "]处理逻辑");
                }
                if (Objects.isNull(pageList) || CollectionUtils.isEmpty(pageList.getRecords())) {
                    break;
                }
                log.info("手动推送-主体方案推预测=====>{}, {}, {}", pageNumber, pageList.getRecords().size(), pageList.getTotal());
                MqMessageVo vo = new MqMessageVo();
                if (BusinessUnitEnum.isDefaultBusinessUnit(dto.getBusinessUnitCode()) || BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                    vo.setTopic(ActivityPlanConstant.TPM_ACTIVITY_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
                    vo.setTag(ActivityPlanPassMqTagConstant.PASS_TPM_HEAD_SCHEME_FORECAST);
                    log.info("手动推送-主体方案推预测=====>{}", dto.getBusinessUnitCode());
                }
                vo.setMsgBody(JSONObject.toJSONString(pageList.getRecords()));
                log.info("手动推送-主体方案推预测=====>{}", JSONObject.toJSON(vo));
                rocketMqProducer.sendMqMsg(vo);
                Thread.sleep(200);
                pageNumber++;
            }
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
