package com.biz.crm.tpm.business.scheme.forecast.local.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

@ApiModel(value = "TpmHeadSchemeForecastFileEntity", description = "主体方案预测资料")
@TableName("tpm_head_scheme_forecast_file")
@Getter
@Setter
@Entity(name = "tpm_head_scheme_forecast_file")
@org.hibernate.annotations.Table(appliesTo = "tpm_head_scheme_forecast_file", comment = "主体方案预测资料")
@Table(name = "tpm_head_scheme_forecast_file", indexes = {
        @Index(name = "tpm_head_scheme_forecast_file_index1", columnList = "scheme_forecast_id"),
        @Index(name = "tpm_head_scheme_forecast_file_index2", columnList = "scheme_forecast_code"),
        @Index(name = "tpm_head_scheme_forecast_file_index3", columnList = "scheme_code"),
        @Index(name = "tpm_head_scheme_forecast_file_index4", columnList = "scheme_item_code")
})
public class TpmHeadSchemeForecastFileEntity extends FileEntity {

    @ApiModelProperty(name = "schemeForecastId", notes = "方案预测id")
    @Column(name = "scheme_forecast_id", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案预测id '")
    private String schemeForecastId;

    @ApiModelProperty(name = "schemeForecastCode", notes = "方案预测编码")
    @Column(name = "scheme_forecast_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案预测编码 '")
    private String schemeForecastCode;

    @ApiModelProperty(name = "schemeCode", notes = "方案编码")
    @Column(name = "scheme_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案编码 '")
    private String schemeCode;

    @ApiModelProperty(name = "schemeItemCode", notes = "方案明细编码")
    @Column(name = "scheme_item_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案明细编码 '")
    private String schemeItemCode;

    @Column(name = "year_month_str", columnDefinition = "VARCHAR(64) COMMENT '年月'")
    private String yearMonthStr;

    @ApiModelProperty("年月（datetime）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "year_month_ly", length = 20, columnDefinition = "datetime COMMENT '年月（datetime） '")
    private Date yearMonthLy;
}
