package com.biz.crm.tpm.business.scheme.forecast.local.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

@ApiModel(value = "TpmHeadSchemeForecastFormulaEntity", description = "TPM-主体方案预测-公式扩展表")
@TableName("tpm_head_scheme_forecast_formula")
@Getter
@Setter
@Entity(name = "tpm_head_scheme_forecast_formula")
@org.hibernate.annotations.Table(appliesTo = "tpm_head_scheme_forecast_formula", comment = "TPM-主体方案预测-公式扩展表")
@Table(
        name = "tpm_head_scheme_forecast_formula",
        indexes = {
                @Index(name = "tpm_head_scheme_forecast_formula_index1", columnList = "scheme_forecast_id"),
                @Index(name = "tpm_head_scheme_forecast_formula_index2", columnList = "scheme_forecast_code"),
                @Index(name = "tpm_head_scheme_forecast_formula_index3", columnList = "scheme_code"),
                @Index(name = "tpm_head_scheme_forecast_formula_index4", columnList = "scheme_item_code")
        }
)
public class TpmHeadSchemeForecastFormulaEntity extends TenantEntity {

    @ApiModelProperty(name = "schemeForecastId", notes = "方案预测id")
    @Column(name = "scheme_forecast_id", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案预测id '")
    private String schemeForecastId;

    @ApiModelProperty(name = "schemeForecastCode", notes = "方案预测编码")
    @Column(name = "scheme_forecast_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案预测编码 '")
    private String schemeForecastCode;

    @ApiModelProperty(name = "schemeCode", notes = "方案编码")
    @Column(name = "scheme_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案编码 '")
    private String schemeCode;

    @ApiModelProperty(name = "schemeItemCode", notes = "方案明细编码")
    @Column(name = "scheme_item_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案明细编码 '")
    private String schemeItemCode;

    @ApiModelProperty("年月（datetime）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "year_month_ly", length = 20, columnDefinition = "datetime COMMENT '年月（datetime） '")
    private Date yearMonthLy;

    @ApiModelProperty(name = "writeOffConditions", notes = "核销条件")
    @Column(name = "write_off_conditions", nullable = true, columnDefinition = "text COMMENT '核销条件 '")
    private String writeOffConditions;

    @ApiModelProperty(name = "writeOffFormula", notes = "核销公式")
    @Column(name = "write_off_formula", nullable = true, columnDefinition = "text COMMENT '核销公式 '")
    private String writeOffFormula;

    @ApiModelProperty(name = "writeOffConditionValue", notes = "核销条件取值")
    @Column(name = "write_off_condition_value", nullable = true,  columnDefinition = "text COMMENT '核销条件取值 '")
    private String writeOffConditionValue;

    @ApiModelProperty(name = "writeOffFormulaValue", notes = "核销公式取值")
    @Column(name = "write_off_formula_value", nullable = true, columnDefinition = "text COMMENT '核销公式取值 '")
    private String writeOffFormulaValue;

    @Column(name = "cal_param", columnDefinition = "text COMMENT '公式计算参数'")
    private String calParam;

    @Column(name = "cal_ex", columnDefinition = "VARCHAR(500) COMMENT '公式计算异常'")
    private String calEx;
}
