package com.biz.crm.tpm.business.scheme.forecast.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value = "TpmHeadSchemeForecastWorkflowEntity", description = "TPM-主体方案预测")
@TableName("tpm_head_scheme_forecast_workflow")
@Getter
@Setter
@Entity(name = "tpm_head_scheme_forecast_workflow")
@org.hibernate.annotations.Table(appliesTo = "tpm_head_scheme_forecast_workflow", comment = "TPM-主体方案预测")
@Table(
        name = "tpm_head_scheme_forecast_workflow",
        indexes = {
                @Index(name = "tpm_head_scheme_forecast_workflow_index1", columnList = "scheme_forecast_id"),
                @Index(name = "tpm_head_scheme_forecast_workflow_index2", columnList = "scheme_forecast_code"),
                @Index(name = "tpm_head_scheme_forecast_workflow_index3", columnList = "scheme_code"),
                @Index(name = "tpm_head_scheme_forecast_workflow_index4", columnList = "scheme_item_code"),
                @Index(name = "tpm_head_scheme_forecast_workflow_index5", columnList = "process_no")
        }
)
public class TpmHeadSchemeForecastWorkflowEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "schemeForecastId", notes = "方案预测id")
    @Column(name = "scheme_forecast_id", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案预测id '")
    private String schemeForecastId;

    @ApiModelProperty(name = "schemeForecastCode", notes = "方案预测编码")
    @Column(name = "scheme_forecast_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案预测编码 '")
    private String schemeForecastCode;

    @ApiModelProperty(name = "schemeCode", notes = "方案编码")
    @Column(name = "scheme_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案编码 '")
    private String schemeCode;

    @ApiModelProperty(name = "schemeItemCode", notes = "方案明细编码")
    @Column(name = "scheme_item_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案明细编码 '")
    private String schemeItemCode;

    @Column(name = "year_month_str", columnDefinition = "VARCHAR(64) COMMENT '年月'")
    private String yearMonthStr;

    @ApiModelProperty("年月（datetime）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "year_month_ly", length = 20, columnDefinition = "datetime COMMENT '年月（datetime） '")
    private Date yearMonthLy;

    @ApiModelProperty(name = "businessNo", notes = "业务编码")
    @Column(name = "business_no", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务编码 '")
    private String businessNo;

    @ApiModelProperty(name = "workflowType", notes = "发起对象类型")
    @Column(name = "workflow_type", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '发起对象类型 '")
    private String workflowType;

    @ApiModelProperty(name = "审批编码", notes = "")
    @Column(name = "process_no", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '审批编码 '")
    private String processNo;

    @ApiModelProperty("审批状态")
    @Column(name = "process_status", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '审批状态'")
    private String processStatus;
}
