package com.biz.crm.tpm.business.scheme.forecast.local.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value = "TpmVerticalSchemeForecastBudgetCashEntity", description = "TPM-垂直方案预测-预算兑付明细")
@TableName("tpm_vertical_scheme_forecast_budget_cash")
@Getter
@Setter
@Entity(name = "tpm_vertical_scheme_forecast_budget_cash")
@org.hibernate.annotations.Table(appliesTo = "tpm_vertical_scheme_forecast_budget_cash", comment = "TPM-垂直方案预测-产品扩展表")
@Table(
        name = "tpm_vertical_scheme_forecast_budget_cash",
        indexes = {
                @Index(name = "tpm_vertical_scheme_forecast_budget_cash_index1", columnList = "scheme_forecast_id"),
                @Index(name = "tpm_vertical_scheme_forecast_budget_cash_index2", columnList = "scheme_forecast_code"),
                @Index(name = "tpm_vertical_scheme_forecast_budget_cash_index3", columnList = "scheme_code"),
                @Index(name = "tpm_vertical_scheme_forecast_budget_cash_index4", columnList = "scheme_item_code"),
                @Index(name = "tpm_vertical_scheme_forecast_budget_cash_index5", columnList = "detail_code")
        }
)
public class TpmVerticalSchemeForecastBudgetCashEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "schemeForecastId", notes = "方案预测id")
    @Column(name = "scheme_forecast_id", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案预测id '")
    private String schemeForecastId;

    @ApiModelProperty(name = "schemeForecastCode", notes = "方案预测编码")
    @Column(name = "scheme_forecast_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案预测编码 '")
    private String schemeForecastCode;

    @ApiModelProperty(name = "schemeCode", notes = "方案编码")
    @Column(name = "scheme_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案编码 '")
    private String schemeCode;

    @ApiModelProperty(name = "schemeItemCode", notes = "方案明细编码")
    @Column(name = "scheme_item_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案明细编码 '")
    private String schemeItemCode;

    @ApiModelProperty(name = "detailCode", notes = "明细编码")
    @Column(name = "detail_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '明细编码 '")
    private String detailCode;

    @ApiModelProperty("年月（datetime）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "year_month_ly", length = 20, columnDefinition = "datetime COMMENT '年月（datetime） '")
    private Date yearMonthLy;

    @ApiModelProperty("预算项目编码")
    @Column(name = "budget_item_code", length = 128, columnDefinition = " varchar(128) COMMENT '预算项目编码'")
    private String budgetItemCode;

    @ApiModelProperty("预算项目名称")
    @Column(name = "budget_item_name", length = 128, columnDefinition = " varchar(128) COMMENT '预算项目名称'")
    private String budgetItemName;

    @ApiModelProperty("预算编码")
    @Column(name = "budget_code", length = 128, columnDefinition = " varchar(128) COMMENT '预算编码'")
    private String budgetCode;

    @ApiModelProperty(name = "confirmAmount",notes = "确认金额")
    @Column(name = "confirm_amount", columnDefinition = "decimal(24,6) COMMENT '确认金额'")
    private BigDecimal confirmAmount;

    @ApiModelProperty(name = "usedAmount",notes = "已使用金额")
    @Column(name = "used_amount", columnDefinition = "decimal(24,6) COMMENT '已使用金额'")
    private BigDecimal usedAmount;

    @ApiModelProperty(name = "balanceAmount",notes = "剩余可使用金额")
    @Column(name = "balance_amount", columnDefinition = "decimal(24,6) COMMENT '剩余可使用金额'")
    private BigDecimal balanceAmount;

    @ApiModelProperty(name = "actFrozenAmount",notes = "申请时冻结金额")
    @Column(name = "act_frozen_amount", columnDefinition = "decimal(24,6) COMMENT '申请时冻结金额'")
    private BigDecimal actFrozenAmount;

    @ApiModelProperty(name = "overFrozenAmount",notes = "补冻结金额")
    @Column(name = "over_frozen_amount", columnDefinition = "decimal(24,6) COMMENT '补冻结金额'")
    private BigDecimal overFrozenAmount;
}
