package com.biz.crm.tpm.business.scheme.forecast.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value = "TpmVerticalSchemeForecastEntity", description = "TPM-垂直方案预测")
@TableName("tpm_vertical_scheme_forecast")
@Getter
@Setter
@Entity(name = "tpm_vertical_scheme_forecast")
@org.hibernate.annotations.Table(appliesTo = "tpm_vertical_scheme_forecast", comment = "TPM-垂直方案预测")
@Table(
        name = "tpm_vertical_scheme_forecast",
        indexes = {
                @Index(name = "tpm_vertical_scheme_forecast_index1", columnList = "scheme_forecast_code"),
                @Index(name = "tpm_vertical_scheme_forecast_index2", columnList = "scheme_code"),
                @Index(name = "tpm_vertical_scheme_forecast_index3", columnList = "scheme_item_code"),
                @Index(name = "tpm_vertical_scheme_forecast_index4", columnList = "only_key", unique = true)
        }
)
public class TpmVerticalSchemeForecastEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "onlyKey", notes = "唯一key")
    @Column(name = "only_key", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '唯一key '")
    private String onlyKey;

    /**
     * 状态[数据字典:tpm_vertical_scheme_status]
     */
    @ApiModelProperty(name = "status", notes = "状态")
    @Column(name = "status", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '状态 '")
    private String status;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "businessFormatCode", notes = "业态")
    @Column(name = "business_format_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元")
    @Column(name = "business_unit_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    @ApiModelProperty(name = "schemeForecastCode", notes = "方案预测编码")
    @Column(name = "scheme_forecast_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案预测编码 '")
    private String schemeForecastCode;

    @ApiModelProperty(name = "schemeCode", notes = "方案编码")
    @Column(name = "scheme_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案编码 '")
    private String schemeCode;

    @ApiModelProperty(name = "schemeItemCode", notes = "方案明细编码")
    @Column(name = "scheme_item_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案明细编码 '")
    private String schemeItemCode;

    @ApiModelProperty(name = "schemeName", notes = "方案名称")
    @Column(name = "scheme_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案名称 '")
    private String schemeName;

    @ApiModelProperty("活动类型编码")
    @Column(name = "activity_type_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动类型编码 '")
    private String activityTypeCode;

    @ApiModelProperty("活动类型名称")
    @Column(name = "activity_type_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动类型名称 '")
    private String activityTypeName;

    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    @Column(name = "activity_form_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式编码'")
    private String activityFormCode;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    @Column(name = "activity_form_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动形式名称'")
    private String activityFormName;

    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "activityStartTime", notes = "活动开始时间")
    @Column(name = "activity_start_time", columnDefinition = "datetime COMMENT '活动开始时间 '")
    private Date activityStartTime;

    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "activityEndTime", notes = "活动结束时间")
    @Column(name = "activity_end_time", columnDefinition = "datetime COMMENT '活动结束时间 '")
    private Date activityEndTime;

    @ApiModelProperty("方案范围编码")
    @Column(name = "plan_org_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '方案范围编码'")
    private String planOrgCode;

    @ApiModelProperty("方案范围名称")
    @Column(name = "plan_org_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '方案范围名称'")
    private String planOrgName;

    @ApiModelProperty(name = "customerCode", notes = "客户编码")
    @Column(name = "customer_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户编码 '")
    private String customerCode;

    @Column(name = "customer_erp_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户erpCode '")
    private String customerErpCode;

    @ApiModelProperty(name = "customerName", notes = "客户")
    @Column(name = "customer_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户 '")
    private String customerName;

    @ApiModelProperty(name = "rtmMode", notes = "客户rtm模式")
    @Column(name = "rtm_mode", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户rtm模式 '")
    private String rtmMode;

    @ApiModelProperty(name = "auditType", notes = "核销类型")
    @Column(name = "audit_type", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '核销类型 '")
    private String auditType;

    @ApiModelProperty(name = "auditFormulaCode", notes = "核销公式编码")
    @Column(name = "audit_formula_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '核销公式编码 '")
    private String auditFormulaCode;

    @ApiModelProperty("核销方式")
    @Column(name = "write_off_method", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '核销方式'")
    private String writeOffMethod;

    @ApiModelProperty("所属销售机构ERP编码")
    @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售机构ERP编码'")
    private String salesInstitutionErpCode;

    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    @Column(name = "sales_institution_code", length = 64, columnDefinition = " varchar(64) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty(name = "salesInstitutionName", value = "销售机构名称", notes = "销售机构名称")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = " varchar(128) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售大区ERP编码")
    @Column(name = "sales_region_erp_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售大区ERP编码'")
    private String salesRegionErpCode;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_code", length = 64, columnDefinition = " varchar(64) COMMENT '所属销售大区编码'")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区名称")
    @Column(name = "sales_region_name", length = 128, columnDefinition = " varchar(128) COMMENT '所属销售大区名称'")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)ERP编码")
    @Column(name = "sales_group_erp_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售组织(组)ERP编码'")
    private String salesGroupErpCode;

    @ApiModelProperty("所属销售组织(组)编码")
    @Column(name = "sales_group_code", length = 64, columnDefinition = " varchar(64) COMMENT '所属销售组织(组)编码'")
    private String salesGroupCode;

    @ApiModelProperty("所属销售组织(组)名称")
    @Column(name = "sales_group_name", length = 128, columnDefinition = " varchar(128) COMMENT '所属销售组织(组)编码'")
    private String salesGroupName;

    @ApiModelProperty("所属销售组织ERP编码")
    @Column(name = "sales_org_erp_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售组织ERP编码'")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织编码")
    @Column(name = "sales_org_code", length = 64, columnDefinition = " varchar(64) COMMENT '所属销售组织编码'")
    private String salesOrgCode;

    @ApiModelProperty("所属销售组织名称")
    @Column(name = "sales_org_name", length = 128, columnDefinition = " varchar(128) COMMENT '所属销售组织名称'")
    private String salesOrgName;

    @Column(name = "region", columnDefinition = "VARCHAR(255) COMMENT '区域'")
    private String region;

    @Column(name = "region_name", columnDefinition = "VARCHAR(128) COMMENT '区域'")
    private String regionName;

    @Column(name = "system_code", columnDefinition = "VARCHAR(128) COMMENT '零售商编码'")
    private String systemCode;

    @Column(name = "system_name", columnDefinition = "VARCHAR(128) COMMENT '零售商名称'")
    private String systemName;

    @Column(name = "channel_code", columnDefinition = "VARCHAR(128) COMMENT '渠道编码'")
    private String channelCode;

    @Column(name = "channel_name", columnDefinition = "VARCHAR(128) COMMENT '渠道名称'")
    private String channelName;

    @Column(name = "year_month_str", columnDefinition = "VARCHAR(64) COMMENT '年月'")
    private String yearMonthStr;

    @ApiModelProperty("年月（datetime）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "year_month_ly", length = 20, columnDefinition = "datetime COMMENT '年月（datetime） '")
    private Date yearMonthLy;

    @Column(name = "product_brand_code", columnDefinition = "VARCHAR(255) COMMENT '品牌编码'")
    private String productBrandCode;

    @Column(name = "product_brand_name", columnDefinition = "VARCHAR(255) COMMENT '品牌名称'")
    private String productBrandName;

    @Column(name = "product_category_code", columnDefinition = "VARCHAR(255) COMMENT '品类编码'")
    private String productCategoryCode;

    @Column(name = "product_category_name", columnDefinition = "VARCHAR(255) COMMENT '品类名称'")
    private String productCategoryName;

    @Column(name = "product_item_code", columnDefinition = "VARCHAR(255) COMMENT '品项编码'")
    private String productItemCode;

    @Column(name = "product_item_name", columnDefinition = "VARCHAR(255) COMMENT '品项名称'")
    private String productItemName;

    @Column(name = "relate_plan_item_code", columnDefinition = "VARCHAR(128) COMMENT '上级方案明细编码'")
    private String relatePlanItemCode;

    @ApiModelProperty("一级管理渠道编码")
    @Column(name = "first_channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '一级管理渠道编码'")
    private String firstChannelCode;

    @ApiModelProperty("一级管理渠道名称")
    @Column(name = "first_channel_name", length = 256, columnDefinition = "varchar(256) COMMENT '一级管理渠道名称'")
    private String firstChannelName;

    @ApiModelProperty(name = "二级渠道编码", notes = "二级渠道编码")
    @Column(name = "second_channel_code", columnDefinition = "VARCHAR(128) COMMENT '二级渠道编码'")
    private String secondChannelCode;

    @ApiModelProperty(name = "二级渠道名称", notes = "二级渠道名称")
    @Column(name = "second_channel_name", columnDefinition = "VARCHAR(128) COMMENT '二级渠道名称'")
    private String secondChannelName;

    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "cusCreateTime", notes = "经销商创建时间")
    @Column(name = "cus_create_time", columnDefinition = "datetime COMMENT '经销商创建时间 '")
    private Date cusCreateTime;

    @ApiModelProperty("总部预算项目编码")
    @Column(name = "head_budget_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '总部预算项目编码'")
    private String headBudgetItemCode;

    @ApiModelProperty("预算编码/大区预算编码")
    @Column(name = "month_budget_code", length = 32, columnDefinition = "varchar(32) COMMENT '大区预算编码'")
    private String monthBudgetCode;

    @ApiModelProperty("分销渠道编码")
    @Column(name = "distribution_channel_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '分销渠道编码'")
    private String distributionChannelCode;

    @ApiModelProperty("分销渠道")
    @Column(name = "distribution_channel_name", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '分销渠道'")
    private String distributionChannelName;

    @ApiModelProperty("是否展示")
    @Column(name = "show_flag", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '是否展示'")
    private String showFlag;

    @ApiModelProperty(name = "applyAmount",notes = "申请金额")
    @Column(name = "apply_amount", columnDefinition = "decimal(24,6) COMMENT '申请金额'")
    private BigDecimal applyAmount;

    @ApiModelProperty(name = "estimatedWriteOffAmount",notes = "预估核销金额")
    @Column(name = "estimated_write_off_amount", columnDefinition = "decimal(24,6) COMMENT '预估核销金额'")
    private BigDecimal estimatedWriteOffAmount;

    @ApiModelProperty("大区承担金额")
    @Column(name = "department_fee_amount", precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '大区承担金额'")
    private BigDecimal departmentFeeAmount;

    @ApiModelProperty("总部承担金额")
    @Column(name = "head_fee_amount", precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '总部承担金额'")
    private BigDecimal headFeeAmount;

    @ApiModelProperty(name = "审批编码", notes = "")
    @Column(name = "process_no", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '审批编码 '")
    private String processNo;

    @ApiModelProperty("审批状态")
    @Column(name = "process_status", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '审批状态'")
    private String processStatus;

    /**********扩展表公式表字段，当前表不存值**************/

    @ApiModelProperty(name = "writeOffConditions", notes = "核销条件")
    @Column(name = "write_off_conditions", nullable = true, columnDefinition = "text COMMENT '核销条件 '")
    private String writeOffConditions;

    @ApiModelProperty(name = "writeOffFormula", notes = "核销公式")
    @Column(name = "write_off_formula", nullable = true, columnDefinition = "text COMMENT '核销公式 '")
    private String writeOffFormula;

    @ApiModelProperty(name = "writeOffConditionValue", notes = "核销条件取值")
    @Column(name = "write_off_condition_value", nullable = true,  columnDefinition = "text COMMENT '核销条件取值 '")
    private String writeOffConditionValue;

    @ApiModelProperty(name = "writeOffFormulaValue", notes = "核销公式取值")
    @Column(name = "write_off_formula_value", nullable = true, columnDefinition = "text COMMENT '核销公式取值 '")
    private String writeOffFormulaValue;

    @Column(name = "cal_param", columnDefinition = "text COMMENT '公式计算参数'")
    private String calParam;

    @Column(name = "cal_ex", columnDefinition = "VARCHAR(500) COMMENT '公式计算异常'")
    private String calEx;

    /**********扩展表产品表字段，当前表不存值**************/

    @ApiModelProperty("产品编码")
    @Column(name = "product_code", length = 128, columnDefinition = " varchar(128) COMMENT '产品编码'")
    private String productCode;

    @ApiModelProperty("产品名称")
    @Column(name = "product_name", length = 128, columnDefinition = " varchar(128) COMMENT '产品名称'")
    private String productName;

    /**********扩展表门店表字段，当前表不存值**************/

    @Column(name = "terminal_code", columnDefinition = "VARCHAR(64) COMMENT '门店编码'")
    private String terminalCode;

    @Column(name = "terminal_name", columnDefinition = "VARCHAR(255) COMMENT '门店名称'")
    private String terminalName;

    /**
     * 确认状态
     */
    @Column(name = "confirm_status", columnDefinition = "VARCHAR(1) COMMENT '是否确认，Y是N否'")
    private String confirmStatus;
}
