package com.biz.crm.tpm.business.scheme.forecast.local.listener;

import com.biz.crm.tpm.business.activity.plan.sdk.listener.ActivityPlanQueryHeadSchemeForecastListener;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.dto.ActivityPlanQueryHeadSchemeForecastDto;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.vo.ActivityPlanQueryHeadSchemeForecastResponse;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.vo.ActivityPlanQueryHeadSchemeForecastVo;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.vo.ActivityPlanQuerySchemeForecastCashVo;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmVerticalSchemeForecastBudgetCashDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.service.TpmHeadSchemeForecastService;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmHeadSchemeForecastVo;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmVerticalSchemeForecastBudgetCashVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-06-10
 */
@Slf4j
@Component
public class ActivityPlanQueryHeadSchemeForecastListenerImpl implements ActivityPlanQueryHeadSchemeForecastListener {

    @Autowired(required = false)
    private TpmHeadSchemeForecastService tpmHeadSchemeForecastService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public ActivityPlanQueryHeadSchemeForecastResponse findListByConditions(ActivityPlanQueryHeadSchemeForecastDto dto) {
        ActivityPlanQueryHeadSchemeForecastResponse response = new ActivityPlanQueryHeadSchemeForecastResponse();
        if (CollectionUtils.isEmpty(dto.getPlanItemCodeList())){
            return response;
        }
        List<TpmHeadSchemeForecastVo> headForecastlist = tpmHeadSchemeForecastService.findByPlanItemCodes(dto.getPlanItemCodeList());
        List<ActivityPlanQueryHeadSchemeForecastVo> list = (List<ActivityPlanQueryHeadSchemeForecastVo>) nebulaToolkitService.copyCollectionByWhiteList(headForecastlist,TpmHeadSchemeForecastVo.class, ActivityPlanQueryHeadSchemeForecastVo.class, HashSet.class, ArrayList.class);
        response.setList(list);
        return response;
    }
}
