package com.biz.crm.tpm.business.scheme.forecast.local.listener;

import com.biz.crm.tpm.business.activity.plan.sdk.listener.ActivityPlanQuerySchemeForecastListener;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.dto.ActivityPlanQuerySchemeForecastDto;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.vo.ActivityPlanQuerySchemeForecastResponse;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.vo.ActivityPlanQuerySchemeForecastCashVo;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmVerticalSchemeForecastBudgetCashDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.service.TpmVerticalSchemeForecastService;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmVerticalSchemeForecastBudgetCashVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-06-10
 */
@Slf4j
@Component
public class ActivityPlanQuerySchemeForecastListenerImpl implements ActivityPlanQuerySchemeForecastListener {

    @Autowired(required = false)
    private TpmVerticalSchemeForecastService tpmVerticalSchemeForecastService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public ActivityPlanQuerySchemeForecastResponse findDetailListByConditions(ActivityPlanQuerySchemeForecastDto dto) {
        ActivityPlanQuerySchemeForecastResponse response = new ActivityPlanQuerySchemeForecastResponse();
        if (CollectionUtils.isEmpty(dto.getSchemeForecastDetailCodeList())){
            return response;
        }
        TpmVerticalSchemeForecastBudgetCashDto cashDto = new TpmVerticalSchemeForecastBudgetCashDto();
        cashDto.setDetailCodeList(dto.getSchemeForecastDetailCodeList());
        List<TpmVerticalSchemeForecastBudgetCashVo> detailList = tpmVerticalSchemeForecastService.findDetailListByConditions(cashDto);
        List<ActivityPlanQuerySchemeForecastCashVo> list = (List<ActivityPlanQuerySchemeForecastCashVo>) nebulaToolkitService.copyCollectionByWhiteList(detailList,TpmVerticalSchemeForecastBudgetCashVo.class, ActivityPlanQuerySchemeForecastCashVo.class, HashSet.class, ArrayList.class);
        response.setList(list);
        return response;
    }
}
