package com.biz.crm.tpm.business.scheme.forecast.local.listener;

import com.biz.crm.tpm.business.scheme.forecast.sdk.constants.TpmHeadSchemeForecastConstants;
import com.biz.crm.tpm.business.scheme.forecast.sdk.constants.TpmVerticalSchemeForecastConstants;
import com.biz.crm.tpm.business.scheme.forecast.sdk.service.TpmHeadSchemeForecastService;
import com.biz.crm.tpm.business.scheme.forecast.sdk.service.TpmVerticalSchemeForecastService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-06-10
 */
@Slf4j
@Component
public class TpmHeadSchemeForecastProcessCompleteListener implements ProcessCompleteListener {

    @Autowired(required = false)
    private TpmHeadSchemeForecastService tpmHeadSchemeForecastService;

    @Override
    public String getBusinessCode() {
        return TpmHeadSchemeForecastConstants.PROCESS_NAME_HEAD_SCHEME_FORECAST;
    }


    @Override
    public void onProcessComplete(ProcessStatusDto dto) {
        if (StringUtils.isEmpty(dto.getProcessNo())) {
            return;
        }
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty(dto.getProcessNo(), "流程编码不能为空！");
        Validate.notEmpty(dto.getProcessStatus(), "流程状态不能为空！");
        //审批通过
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            //修改审批状态
            tpmHeadSchemeForecastService.completeCallback(dto.getProcessNo(), ProcessStatusEnum.PASS.getDictCode());
        }
        //审批驳回|流程追回
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) ||
                ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            tpmHeadSchemeForecastService.completeCallback(dto.getProcessNo(), processStatus);
        }
    }
}
