package com.biz.crm.tpm.business.scheme.forecast.local.listener;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.tpm.business.scheme.forecast.sdk.constants.TpmVerticalSchemeForecastConstants;
import com.biz.crm.tpm.business.scheme.forecast.sdk.service.TpmVerticalSchemeForecastService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-06-10
 */
@Slf4j
@Component
public class TpmVerticalSchemeForecastBatchProcessCompleteListener implements ProcessCompleteListener {

    @Autowired(required = false)
    private TpmVerticalSchemeForecastService tpmVerticalSchemeForecastService;

    @Override
    public String getBusinessCode() {
        return TpmVerticalSchemeForecastConstants.PROCESS_NAME_BATCH_VERTICAL_SCHEME_FORECAST;
    }


    @Override
    public void onProcessComplete(ProcessStatusDto dto) {
        if (CollectionUtil.isEmpty(dto.getBusinessNoList())) {
            return;
        }
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty(dto.getProcessNo(), "流程编码不能为空！");
        //审批通过
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            //修改审批状态
            tpmVerticalSchemeForecastService.completeCallbackBatch(dto.getBusinessNoList(), ProcessStatusEnum.PASS.getDictCode());
        }
        //审批驳回|流程追回
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) ||
                ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            tpmVerticalSchemeForecastService.completeCallbackBatch(dto.getBusinessNoList(), processStatus);
        }
    }
}
