package com.biz.crm.tpm.business.scheme.forecast.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoCreateDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoRefreshDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastInitDto;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.SchemeForecastEntity;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemeForecastAutoCreateDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemeForecastAutoRefreshDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemePushSchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.SchemeForecastVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 * 方案预测表(SchemeForecastEntity)表mybatis访问层
 *
 * @author youjun
 * @date 2022年11月10日 15：12
 */
public interface SchemeForecastMapper extends BaseMapper<SchemeForecastEntity> {

    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param schemeForecastDto 查询实体
     * @return 所有数据
     */
    public Page<SchemeForecastVo> findByForecasts(@Param("page") Page<SchemeForecastVo> page, @Param("dto") SchemeForecastDto schemeForecastDto);

    Page<String> findHeadVerticalCodeList(@Param("page") Page<String> page, @Param("dto") SchemePushSchemeForecastDto dto);

    Long findAutoRefreshDataCount(@Param("dto") SchemeForecastAutoRefreshDto dto);

    Page<String> findAutoRefreshDataList(@Param("page") Page<String> page, @Param("dto") SchemeForecastAutoRefreshDto dto);

    List<String> findHeadVerticalAutoCreateDataList(@Param("dto") SchemeForecastAutoCreateDto dto);

    List<String> findHeadAutoUpdateShowFlagDataList( @Param("dto") SchemeForecastAutoCreateDto dto);

    Long autoUpdateShowFLag(@Param("list") List<String> schemeItemCodes);
}
