package com.biz.crm.tpm.business.scheme.forecast.local.model;



import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author youjun
 * @date 2022年11月10日 15:40
 */
@Data
@CrmExcelImport(startRow = 1)
public class SchemeForecastImportsVo extends CrmExcelVo {
    /**
     * 状态
     */
    @ApiModelProperty(name = "detailedPredictionType", notes = "状态")
    private String detailedPredictionType;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "businessFormatCode", notes = "业态")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元")
    private String businessUnitCode;
    /**
     * 方案编码
     */
    @ApiModelProperty(name = "schemeCode", notes = "方案编码")
    private String schemeCode;

    /**
     * 方案名称
     */
    @ApiModelProperty(name = "schemeName", notes = "方案名称")
    private String schemeName;
    /**
     * 活动类型
     */
    @ApiModelProperty(name = "activityType", notes = "活动类型")
    private String activityType;

    /**
     * 活动形式
     */
    @ApiModelProperty(name = "formOfActivity", notes = "活动形式")
    private String formOfActivity;

    /**
     * 活动开始时间
     */
    @ApiModelProperty(name = "activityStartTime", notes = "活动开始时间")
    private Date activityStartTime;

    /**
     * 活动结束时间
     */
    @ApiModelProperty(name = "activityEndTime", notes = "活动结束时间")
    private Date activityEndTime;


    /**
     * 方案范围
     */
    @ApiModelProperty(name = "programmeScope", notes = "方案范围")
    private String programmeScope;

    /**
     * 预算编码
     */
    @ApiModelProperty(name = "budgetCode", notes = "预算编码")
    private String budgetCode;
    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(name = "feeBelongCode", notes = "费用归口")
    private String feeBelongCode;

    /**
     * 核销条件
     */
    @ApiModelProperty(name = "writeOffConditions", notes = "核销条件")
    private String writeOffConditions;

    /**
     * 核销公式
     */
    @ApiModelProperty(name = "writeOffFormula", notes = "核销公式")
    private String writeOffFormula;

    /**
     * 核销条件取值
     */
    @ApiModelProperty(name = "writeOffConditionValue", notes = "核销条件取值")
    private String writeOffConditionValue;

    /**
     * 核销公式取值
     */
    @ApiModelProperty(name = "writeOffFormulaValue", notes = "核销公式取值")
    private String writeOffFormulaValue;
    /**
     * 核销金额
     */
    @ApiModelProperty(name = "writeOffAmount", notes = "核销金额")
    private BigDecimal writeOffAmount;

}
