package com.biz.crm.tpm.business.scheme.forecast.local.notifier.log;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.log.TpmHeadSchemeForecastLogEventDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.event.TpmHeadSchemeForecastLogEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TpmHeadSchemeForecastLogEventListenerImpl implements TpmHeadSchemeForecastLogEventListener {


    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    /**
     * 创建时日志记录
     * @param dto 方案预测单新旧vo对象
     */
    @Override
    public void onCreate(TpmHeadSchemeForecastLogEventDto dto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, dto);
    }

    /**
     * 删除时日志记录
     * @param dto 方案预测单新旧vo对象
     */
    @Override
    public void onDelete(TpmHeadSchemeForecastLogEventDto dto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, dto);
    }

    /**
     * 修改时日志记录
     * @param dto 方案预测单新旧vo对象
     */
    @Override
    public void onUpdate(TpmHeadSchemeForecastLogEventDto dto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, dto);
    }


    /**
     * 构建日志dto
     * @param crmBusinessLogDto 日志dto
     * @param eventDto 方案预测单新旧vo对象
     */
    private void buildCrmBusinessLog(CrmBusinessLogDto crmBusinessLogDto, TpmHeadSchemeForecastLogEventDto eventDto) {
        crmBusinessLogDto.setOnlyKey(eventDto.getNewest().getId());
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(eventDto.getOriginal());
        crmBusinessLogDto.setNewObject(eventDto.getNewest());
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

}
