package com.biz.crm.tpm.business.scheme.forecast.local.process.imports;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.SchemeForecastEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.process.vo.DetailedForecastUpdateImportVo;
import com.biz.crm.tpm.business.scheme.forecast.local.repository.SchemeForecastRepository;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.service.SchemeForecastService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-23
 */
@Component
@Slf4j
public class DetailedForecastUpdateImportProcess implements ImportProcess<DetailedForecastUpdateImportVo> {

    @Autowired(required = false)
    private SchemeForecastRepository schemeForecastRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private SchemeForecastService schemeForecastService;

    @Override
    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, DetailedForecastUpdateImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notNull(data, "导入数据不能为空！");
        Validate.isTrue(data.values().size() <= getBatchCount(), "单次导入数据不能超过%s条", getBatchCount());
        log.info("方案预测更新导入-开始执行大批量导入校验-----------------");
        List<SchemeForecastDto> dtoList = this.val(data);
        log.info("方案预测更新导入-执行大批量导入校验结束-----------------");

        log.info("方案预测更新导入-开始执行大批量导入保存-----------------");
        schemeForecastService.importUpdate(dtoList);
        log.info("方案预测更新导入-结束执行大批量导入保存-----------------");
        return null;
    }

    @Override
    public Class<DetailedForecastUpdateImportVo> findCrmExcelVoClass() {
        return DetailedForecastUpdateImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "DETAILED_FORECAST_UPDATE_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "TPM-细案预测更新导入模板";
    }

    @Override
    public String getBusinessCode() {
        return "DETAILED_FORECAST_UPDATE_IMPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM-细案预测更新导入模板";
    }

    private List<SchemeForecastDto> val(LinkedHashMap<Integer, DetailedForecastUpdateImportVo> data) {
        //根据方案明细编码查方案预测数据
        List<SchemeForecastDto> list = Lists.newArrayList();
        List<String> schemeItemCodeList = data.values().stream().filter(e -> StringUtils.isNotEmpty(e.getSchemeItemCode())).map(DetailedForecastUpdateImportVo::getSchemeItemCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(schemeItemCodeList)) {
            List<SchemeForecastEntity> entityList = this.schemeForecastRepository.lambdaQuery()
                    .eq(SchemeForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                    .eq(SchemeForecastEntity::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
                    .in(SchemeForecastEntity::getSchemeItemCode, schemeItemCodeList)
                    .list();
            list = (List<SchemeForecastDto>) nebulaToolkitService.copyCollectionByWhiteList(entityList, SchemeForecastEntity.class, SchemeForecastDto.class, HashSet.class, ArrayList.class);
        }
        Map<String, List<SchemeForecastDto>> listMap = list.stream().collect(Collectors.groupingBy(SchemeForecastDto::getSchemeItemCode));
        List<SchemeForecastDto> updateList = new ArrayList<>();
        data.forEach((k, value) -> {
            Validate.notBlank(value.getSchemeItemCode(), "第[%s]行，[方案明细编码]不能为空！");
            Validate.notNull(value.getActualWriteOffAmount(), "第[%s]行，[可核销金额]不能为空！");
            Validate.isTrue(listMap.containsKey(value.getSchemeItemCode()), "第[%s]行，方案明细编码[%s]对应方案预测数据不存在！");
            List<SchemeForecastDto> forecastDtoList = listMap.get(value.getSchemeItemCode());
            Validate.isTrue(forecastDtoList.size() == 1, "第[%s]行，方案明细编码[%s]对应对跳方案预测数据！");
            SchemeForecastDto forecastDto = forecastDtoList.get(0);
            //TODO 确认逻辑不明
//            Validate.isTrue(!StringUtils.equals("009", forecastEntity.getDetailedPredictionType()), "第[%s]行，方案明细编码[%s]已确认，不允许更新！");
            forecastDto.setActualWriteOffAmount(value.getActualWriteOffAmount());
            updateList.add(forecastDto);
        });
        return updateList;
    }
}
