package com.biz.crm.tpm.business.scheme.forecast.local.process.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TPM-细案预测更新导入vo")
@CrmExcelImport(startRow = 1)
public class DetailedForecastUpdateImportVo extends CrmExcelVo {

    @CrmExcelColumn(value = "状态", order = 1)
    private String detailedPredictionType;

    @CrmExcelColumn(value = "业态", order = 2)
    private String businessFormatCode;

    @CrmExcelColumn(value = "业务单元", order = 3)
    private String businessUnitCode;

    @CrmExcelColumn(value = "方案明细编码", order = 4)
    private String schemeItemCode;

    @CrmExcelColumn(value = "方案编码", order = 5)
    private String schemeCode;

    @CrmExcelColumn(value = "方案名称", order = 6)
    private String schemeName;

    @CrmExcelColumn(value = "活动分类编码", order = 7)
    private String activityTypeCode;

    @CrmExcelColumn(value = "活动分类名称", order = 8)
    private String activityTypeName;

    @CrmExcelColumn(value = "活动形式编码", order = 9)
    private String activityFormCode;

    @CrmExcelColumn(value = "活动形式名称", order = 10)
    private String activityFormName;

    @CrmExcelColumn(value = "活动开始时间", order = 11)
    private String activityStartTime;

    @CrmExcelColumn(value = "活动结束时间", order = 12)
    private String activityEndTime;

    @CrmExcelColumn(value = "可核销金额", order = 13)
    private BigDecimal actualWriteOffAmount;
}
