package com.biz.crm.tpm.business.scheme.forecast.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 方案预测单(AuditFee)数据视图注册器
 *
 * @author wanghaojia
 * @since 2022-11-11 10:31:00
 */
@Component
public class SchemeForecastDataViewRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_scheme_forecast_data_view";
    }

    @Override
    public String desc() {
        return "TPM-方案预测单";
    }

    @Override
    public String buildSql() {
        return "select t.*," +
                "t1.write_off_conditions as write_off_conditions_ex,t1.write_off_formula as write_off_formula_ex, " +
                "t1.write_off_condition_value as write_off_condition_value_ex,t1.write_off_formula_value as write_off_formula_value_ex, " +
                "t1.write_off_premise as write_off_premise_ex,t1.cal_ex as cal_ex_ex,t1.over_budget_remark as over_budget_remark_ex " +
                "from tpm_scheme_forecast t " +
                "left join  tpm_scheme_forecast_formula t1 " +
                "on t.scheme_item_code = t1.scheme_item_code " +
                "where t.tenant_code = :tenantCode " +
                "and t.show_flag = 'Y' " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }
}
