package com.biz.crm.tpm.business.scheme.forecast.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import com.bizunited.nebula.europa.database.register.sdk.service.MnDataviewRegister;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import org.springframework.stereotype.Component;

/**
 * 垂直方案预测单(tpm_vertical_scheme_forecast)数据视图注册器
 *
 * @author chenshuang
 * @since 2023-06-08 17:31:00
 */
@Component
public class TpmVerticalSchemeForecastDataViewRegister implements MnDataviewRegister {

    @Override
    public String code() {
        return "tpm_vertical_scheme_forecast_data_view";
    }

    @Override
    public String desc() {
        return "TPM-垂直方案预测单";
    }

    @Override
    public String buildSql() {
        return "select t.*," +
                "t1.write_off_conditions as write_off_conditions_ex,t1.write_off_formula as write_off_formula_ex, " +
                "t1.write_off_condition_value as write_off_condition_value_ex,t1.write_off_formula_value as write_off_formula_value_ex, " +
                "t1.cal_ex as cal_ex_ex, " +
                "GROUP_CONCAT(t2.product_code) as product_code_ex,GROUP_CONCAT(t2.product_name) as product_name_ex, " +
                "GROUP_CONCAT(t3.terminal_code) as terminal_code_ex,GROUP_CONCAT(t3.terminal_name) as terminal_name_ex " +
                "from tpm_vertical_scheme_forecast t " +
                "left join  tpm_vertical_scheme_forecast_formula t1 " +
                "on t.id = t1.id " +
                "left join tpm_vertical_scheme_forecast_product t2 " +
                "on t.id = t2.scheme_forecast_id " +
                "left join tpm_vertical_scheme_forecast_terminal t3 " +
                "on t.id = t3.scheme_forecast_id " +
                "where t.tenant_code = :tenantCode " +
                "and t.show_flag = 'Y' " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
                "group by t.id ";
    }

    @Override
    public Object customBindingFieldValue(ExecuteParameter executeParameter, DatabaseExecuteExternalRequest databaseExecuteExternalRequest) {
        return null;
    }

    @Override
    public String buildCountSql() {
        return "select t.id " +
                "from tpm_vertical_scheme_forecast t " +
                "where t.tenant_code = :tenantCode " +
                "and t.show_flag = 'Y' " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
                "group by t.id ";
    }
}
