package com.biz.crm.tpm.business.scheme.forecast.local.repository;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.detailed.forecast.sdk.constant.DetailedPredictionTypeEnum;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.SchemeForecastEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.SchemeForecastFormulaEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.mapper.SchemeForecastMapper;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemeForecastAutoCreateDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemeForecastAutoRefreshDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemePushSchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.SchemeForecastVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 细案预测表(DetailedForecastEntity)表数据库访问层
 *
 * @author youjun
 * @date 2022年11月09日 13:03
 */
@Component
public class SchemeForecastRepository extends ServiceImpl<SchemeForecastMapper, SchemeForecastEntity> {

    @Autowired(required = false)
    private SchemeForecastMapper schemeForecastMapper;

    @Autowired(required = false)
    private SchemeForecastFormulaRepository schemeForecastFormulaRepository;
    /**
     * 分页查询数据
     * @param pageable 分页对象
     * @param schemeForecastDto 实体对象
     * @return
     */
    public Page<SchemeForecastVo> findByForecasts(Pageable pageable, SchemeForecastDto schemeForecastDto) {
        Page<SchemeForecastVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<SchemeForecastVo> pageList = this.schemeForecastMapper.findByForecasts(page, schemeForecastDto);
        return pageList;
    }

    public List<SchemeForecastEntity> findByIds(List<String> ids) {
        return this.lambdaQuery().eq(SchemeForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .in(UuidEntity::getId,ids).list();
    }

    /**
     * 根据方案编码查询
     *
     * @param codes
     * @return
     */
    public List<SchemeForecastEntity> findByCodes(Set<String> codes) {
        return this.lambdaQuery().eq(SchemeForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(SchemeForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(SchemeForecastEntity::getSchemeCode,codes).list();
    }

    //扩展表
    //组装公式表字段
    public List<SchemeForecastEntity> loadFormula(List<SchemeForecastEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        List<String> idList = list.stream().map(SchemeForecastEntity::getId).collect(Collectors.toList());
        List<SchemeForecastFormulaEntity> formulaList = schemeForecastFormulaRepository.listByIds(idList);
        Map<String, SchemeForecastFormulaEntity> formulaMap = formulaList.stream().collect(Collectors.toMap(SchemeForecastFormulaEntity::getId, v -> v));
        String[] ignoreFieldArr = SchemeForecastFormulaRepository.excludeFieldList.toArray(new String[]{});
        for (SchemeForecastEntity entity : list) {
            if (!formulaMap.containsKey(entity.getId())) {
                continue;
            }
            BeanUtils.copyProperties(formulaMap.get(entity.getId()), entity, ignoreFieldArr);
        }
        return list;
    }

    public List<SchemeForecastEntity> clearFormula(List<SchemeForecastEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        for (SchemeForecastEntity forecastEntity : list) {
            forecastEntity.setWriteOffConditions(null);
            forecastEntity.setWriteOffFormula(null);
            forecastEntity.setWriteOffConditionValue(null);
            forecastEntity.setWriteOffFormulaValue(null);
            forecastEntity.setWriteOffPremise(null);
            forecastEntity.setCalParam(null);
            forecastEntity.setCalEx(null);
            forecastEntity.setOverBudgetRemark(null);
        }
        return list;
    }

    public List<SchemeForecastEntity> list(QueryWrapper<SchemeForecastEntity> queryWrapper) {
        List<SchemeForecastEntity> list = super.list(queryWrapper);
        return this.loadFormula(list);
    }

    @Override
    public SchemeForecastEntity getById(Serializable id) {
        SchemeForecastEntity entity = super.getById(id);
        if (Objects.isNull(entity)) {
            return null;
        }
        return this.loadFormula(Lists.newArrayList(entity)).get(0);
    }

    @Override
    public boolean save(SchemeForecastEntity entity) {
        SchemeForecastFormulaEntity extendEntity = BeanUtil.copyProperties(entity, SchemeForecastFormulaEntity.class);
        entity = this.clearFormula(Lists.newArrayList(entity)).get(0);
        boolean save = super.save(entity);
        extendEntity.setId(entity.getId());
        //保存下副表
        schemeForecastFormulaRepository.save(extendEntity);
        return save;
    }

    @Override
    public boolean updateById(SchemeForecastEntity entity) {
        SchemeForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, SchemeForecastFormulaEntity.class);
        entity = this.clearFormula(Lists.newArrayList(entity)).get(0);
        boolean result = super.updateById(entity);

        //保存下副表
        schemeForecastFormulaRepository.saveOrUpdate(formulaEntity);
        return result;
    }

    @Override
    public boolean saveOrUpdate(SchemeForecastEntity entity, Wrapper<SchemeForecastEntity> updateWrapper) {
        SchemeForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, SchemeForecastFormulaEntity.class);

        entity = this.clearFormula(Lists.newArrayList(entity)).get(0);
        boolean result = super.saveOrUpdate(entity, updateWrapper);

        //保存下副表
        schemeForecastFormulaRepository.saveOrUpdate(formulaEntity);
        return result;
    }

    @Override
    public boolean saveBatch(Collection<SchemeForecastEntity> entityList, int batchSize) {
        List<SchemeForecastFormulaEntity> formulaEntityList = Lists.newArrayList();
        for (SchemeForecastEntity entity : entityList) {
            entity.setId(UUID.randomUUID().toString().replace("-", ""));
            SchemeForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, SchemeForecastFormulaEntity.class);
            formulaEntityList.add(formulaEntity);
        }
        entityList = this.clearFormula(Lists.newArrayList(entityList));
        boolean result = super.saveBatch(entityList, batchSize);
        if (!CollectionUtils.isEmpty(formulaEntityList)) {
            //保存下副表
            schemeForecastFormulaRepository.saveBatch(formulaEntityList, batchSize);
        }

        return result;
    }

    @Override
    public boolean saveOrUpdateBatch(Collection<SchemeForecastEntity> entityList, int batchSize) {
        List<SchemeForecastFormulaEntity> formulaEntityList = Lists.newArrayList();
        for (SchemeForecastEntity entity : entityList) {
            entity.setId(UUID.randomUUID().toString().replace("-", ""));
            SchemeForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, SchemeForecastFormulaEntity.class);
            formulaEntityList.add(formulaEntity);
        }

        entityList = this.clearFormula(Lists.newArrayList(entityList));
        boolean result = super.saveOrUpdateBatch(entityList, batchSize);
        //保存下副表
        schemeForecastFormulaRepository.saveOrUpdateBatch(formulaEntityList, batchSize);

        return result;
    }

    @Override
    public boolean updateBatchById(Collection<SchemeForecastEntity> entityList, int batchSize) {

        List<SchemeForecastFormulaEntity> formulaEntityList = Lists.newArrayList();
        for (SchemeForecastEntity entity : entityList) {
            SchemeForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, SchemeForecastFormulaEntity.class);
            formulaEntityList.add(formulaEntity);
        }

        entityList = this.clearFormula(Lists.newArrayList(entityList));
        boolean result = super.updateBatchById(entityList, batchSize);

        //保存下副表
        schemeForecastFormulaRepository.updateBatchById(formulaEntityList, batchSize);
        return result;
    }

    @Override
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return true;
        }
        boolean result = super.removeByIds(idList);
        boolean formulaResult = this.schemeForecastFormulaRepository.removeByIds(idList);
        return result && formulaResult;
    }

    public Page<String> findHeadVerticalCodeList(Page<String> page, SchemePushSchemeForecastDto dto) {
        return schemeForecastMapper.findHeadVerticalCodeList(page, dto);
    }

    public Long findAutoRefreshDataCount(SchemeForecastAutoRefreshDto dto) {
        return this.schemeForecastMapper.findAutoRefreshDataCount(dto);
    }

    public List<String> findAutoRefreshDataList(Pageable pageable, SchemeForecastAutoRefreshDto dto) {
        Page<String> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<String> pageList = this.schemeForecastMapper.findAutoRefreshDataList(page, dto);
        return pageList.getRecords();
    }

    public List<String>  findAutoCreateDataList(SchemeForecastAutoCreateDto dto) {
        if (BusinessUnitEnum.isDefaultBusinessUnit(dto.getBusinessUnitCode()) || BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
            return this.schemeForecastMapper.findHeadVerticalAutoCreateDataList(dto);
        }
        return null;
    }

    public List<String>  findAutoUpdateShowFlagDataList(SchemeForecastAutoCreateDto dto) {
        if (BusinessUnitEnum.isDefaultBusinessUnit(dto.getBusinessUnitCode())) {
            return this.schemeForecastMapper.findHeadAutoUpdateShowFlagDataList(dto);
        }
        return null;
    }

    public Long autoUpdateShowFLag(List<String> schemeItemCodes) {
        return schemeForecastMapper.autoUpdateShowFLag(schemeItemCodes);
    }

    public List<SchemeForecastEntity> findByPlanItemCodes(Set<String> planItemCodes) {
        if(CollectionUtils.isEmpty(planItemCodes)){
            return Lists.newArrayList();
        }
        return this.lambdaQuery().in(SchemeForecastEntity::getSchemeItemCode, planItemCodes)
                .eq(SchemeForecastEntity::getDetailedPredictionType, DetailedPredictionTypeEnum.CONFIRMED.getDictCode())
                .eq(SchemeForecastEntity::getSchemeItemCode, DelFlagStatusEnum.NORMAL.getCode())
                .eq(SchemeForecastEntity::getTenantCode, TenantUtils.getTenantCode()).list();
    }
}
