package com.biz.crm.tpm.business.scheme.forecast.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmHeadSchemeForecastEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmHeadSchemeForecastProductEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.mapper.TpmHeadSchemeForecastProductMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import liquibase.util.StringUtil;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Component
public class TpmHeadSchemeForecastProductRepository extends ServiceImpl<TpmHeadSchemeForecastProductMapper, TpmHeadSchemeForecastProductEntity> {

    @Autowired(required = false)
    private TpmHeadSchemeForecastProductMapper tpmHeadSchemeForecastProductMapper;

    private static final String property_schemeForecastId = "schemeForecastCodeId";
    private static final String property_schemeForecastCode = "schemeForecastCode";
    private static final String property_detailedCaseCode = "detailedCaseCode";
    private static final String property_activityDetailItemCode = "activityDetailItemCode";
    private static final String property_yearMonthLy = "yearMonthLy";

    public static final List<String> excludeFieldList = Lists.newArrayList();

    static {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(TenantEntity.class);
        excludeFieldList.addAll(Arrays.stream(propertyDescriptors).map(PropertyDescriptor::getName).collect(Collectors.toList()));
        excludeFieldList.add(property_schemeForecastId);
        excludeFieldList.add(property_schemeForecastCode);
        excludeFieldList.add(property_detailedCaseCode);
        excludeFieldList.add(property_activityDetailItemCode);
        excludeFieldList.add(property_yearMonthLy);
    }

    //判断下是否所有属性都为空
    public boolean hasNotEmptyProperty(TpmHeadSchemeForecastProductEntity entity) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(TpmHeadSchemeForecastProductEntity.class);
        boolean hasNotEmptyProperty = false;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (excludeFieldList.contains(propertyDescriptor.getName())) {
                continue;
            }
            try {
                Object invoke = propertyDescriptor.getReadMethod().invoke(entity);
                if (null != invoke && StringUtil.isNotEmpty(invoke.toString())) {
                    hasNotEmptyProperty = true;
                    break;
                }
            } catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return hasNotEmptyProperty;
    }

    public List<TpmHeadSchemeForecastProductEntity> buildEntityList(TpmHeadSchemeForecastEntity entity) {
        List<TpmHeadSchemeForecastProductEntity> productEntityList = new ArrayList<>();
        if (!StringUtils.isEmpty(entity.getProductCode())) {
            String[] productCodes = entity.getProductCode().split(",");
            List<String> productNames = Lists.newArrayList();
            if (!StringUtils.isEmpty(entity.getProductName())) {
                productNames = Arrays.asList(entity.getProductName().split(","));
            }
            for (int i = 0; i < productCodes.length; i++) {
                TpmHeadSchemeForecastProductEntity productEntity = new TpmHeadSchemeForecastProductEntity();
                productEntity.setProductCode(productCodes[i]);
                if (i < productNames.size()) {
                    productEntity.setProductName(productNames.get(i));
                }
                productEntity.setTenantCode(TenantUtils.getTenantCode());
                productEntity.setSchemeForecastId(entity.getId());
                productEntity.setSchemeForecastCode(entity.getSchemeForecastCode());
                productEntity.setSchemeCode(entity.getSchemeCode());
                productEntity.setSchemeItemCode(entity.getSchemeItemCode());
                productEntity.setYearMonthLy(entity.getYearMonthLy());
                productEntityList.add(productEntity);
            }
        }
        return productEntityList;
    }

    public boolean removeByForecastIds(List<String> forecastIds) {
        return this.lambdaUpdate()
                .eq(TpmHeadSchemeForecastProductEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(TpmHeadSchemeForecastProductEntity::getSchemeForecastId, forecastIds).remove();
    }

    public List<TpmHeadSchemeForecastProductEntity> findByForecastIds(List<String> forecastIds) {
        return this.lambdaQuery()
                .eq(TpmHeadSchemeForecastProductEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(TpmHeadSchemeForecastProductEntity::getSchemeForecastId, forecastIds).list();
    }
}
