package com.biz.crm.tpm.business.scheme.forecast.local.repository;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmHeadSchemeForecastEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmHeadSchemeForecastFormulaEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmHeadSchemeForecastProductEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmHeadSchemeForecastTerminalEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.mapper.TpmHeadSchemeForecastMapper;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmHeadSchemeForecastAutoCreateDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmHeadSchemeForecastAutoRefreshDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmHeadSchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.enums.TpmHeadSchemeStatusEnum;
import com.biz.crm.tpm.business.scheme.forecast.sdk.enums.TpmHeadSchemeWorkflowTypeEnum;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmHeadSchemeForecastVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;


@Component
public class TpmHeadSchemeForecastRepository extends ServiceImpl<TpmHeadSchemeForecastMapper, TpmHeadSchemeForecastEntity> {

    @Autowired(required = false)
    private TpmHeadSchemeForecastMapper tpmHeadSchemeForecastMapper;

    @Autowired(required = false)
    private TpmHeadSchemeForecastFormulaRepository tpmHeadSchemeForecastFormulaRepository;

    @Autowired(required = false)
    private TpmHeadSchemeForecastProductRepository tpmHeadSchemeForecastProductRepository;

    @Autowired(required = false)
    private TpmHeadSchemeForecastTerminalRepository tpmHeadSchemeForecastTerminalRepository;

    public Page<TpmHeadSchemeForecastVo> findByForecasts(Pageable pageable, TpmHeadSchemeForecastDto dto) {
        Page<TpmHeadSchemeForecastVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<TpmHeadSchemeForecastVo> pageList = this.tpmHeadSchemeForecastMapper.findByForecasts(page, dto);
        return pageList;
    }

    public List<TpmHeadSchemeForecastEntity> findByIds(List<String> ids) {
        List<TpmHeadSchemeForecastEntity> list = this.lambdaQuery()
                .eq(TpmHeadSchemeForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmHeadSchemeForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(UuidEntity::getId, ids)
                .list();
        return this.loadExtend(list);
    }

    public List<TpmHeadSchemeForecastEntity> findByProcessNo(String processNo, String workflowType) {
        List<TpmHeadSchemeForecastEntity> list = this.lambdaQuery()
                .eq(TpmHeadSchemeForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmHeadSchemeForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(StringUtils.equals(TpmHeadSchemeWorkflowTypeEnum.HEAD.getCode(), workflowType) ,TpmHeadSchemeForecastEntity::getHeadProcessNo, processNo)
                .eq(StringUtils.equals(TpmHeadSchemeWorkflowTypeEnum.REGION.getCode(), workflowType) ,TpmHeadSchemeForecastEntity::getRegionProcessNo, processNo)
                .list();
        return this.loadExtend(list);
    }

    public List<TpmHeadSchemeForecastEntity> findByDetailCodes(List<String> schemeCodes) {
        List<TpmHeadSchemeForecastEntity> list = this.lambdaQuery()
                .eq(TpmHeadSchemeForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmHeadSchemeForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(TpmHeadSchemeForecastEntity::getSchemeCode, schemeCodes)
                .list();
        return this.loadExtend(list);
    }

    public Long findAutoRefreshDataCount(TpmHeadSchemeForecastAutoRefreshDto dto) {
        return this.tpmHeadSchemeForecastMapper.findAutoRefreshDataCount(dto);
    }

    public List<String> findAutoRefreshDataList(Pageable pageable, TpmHeadSchemeForecastAutoRefreshDto dto) {
        Page<String> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<String> pageList = this.tpmHeadSchemeForecastMapper.findAutoRefreshDataList(page, dto);
        return pageList.getRecords();
    }

    public List<String> findAutoCreateDataList(TpmHeadSchemeForecastAutoCreateDto dto) {
        return this.tpmHeadSchemeForecastMapper.findAutoCreateDataList(dto);
    }

    public List<String> findAutoUpdateShowFlagDataList(TpmHeadSchemeForecastAutoCreateDto dto) {
        return this.tpmHeadSchemeForecastMapper.findAutoUpdateShowFlagDataList(dto);
    }

    public Long autoUpdateShowFLag(List<String> schemeItemCodes) {
        return tpmHeadSchemeForecastMapper.autoUpdateShowFLag(schemeItemCodes);
    }

    @Transactional
    public void updateProcessStatus(String processStatus,
                                    String processNo,
                                    String workflowType, List<String> ids) {
        this.lambdaUpdate()
                .in(TpmHeadSchemeForecastEntity::getId, ids)
                .eq(TpmHeadSchemeForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmHeadSchemeForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .set(StringUtils.equals(TpmHeadSchemeWorkflowTypeEnum.HEAD.getCode(), workflowType) ,TpmHeadSchemeForecastEntity::getHeadProcessStatus, processStatus)
                .set(StringUtils.equals(TpmHeadSchemeWorkflowTypeEnum.HEAD.getCode(), workflowType) ,TpmHeadSchemeForecastEntity::getHeadProcessNo, processNo)
                .set(StringUtils.equals(TpmHeadSchemeWorkflowTypeEnum.REGION.getCode(), workflowType) ,TpmHeadSchemeForecastEntity::getRegionProcessStatus, processStatus)
                .set(StringUtils.equals(TpmHeadSchemeWorkflowTypeEnum.REGION.getCode(), workflowType) ,TpmHeadSchemeForecastEntity::getRegionProcessNo, processNo)
                .update();
    }

    //扩展表
    //组装公式表字段
    public List<TpmHeadSchemeForecastEntity> loadExtend(List<TpmHeadSchemeForecastEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        List<String> idList = list.stream().map(TpmHeadSchemeForecastEntity::getId).collect(Collectors.toList());

        //公式扩展
        List<TpmHeadSchemeForecastFormulaEntity> formulaList = tpmHeadSchemeForecastFormulaRepository.listByIds(idList);
        Map<String, TpmHeadSchemeForecastFormulaEntity> formulaMap = formulaList.stream().collect(Collectors.toMap(TpmHeadSchemeForecastFormulaEntity::getId, v -> v));

        //产品扩展
        List<TpmHeadSchemeForecastProductEntity> productList = tpmHeadSchemeForecastProductRepository.findByForecastIds(idList);
        Map<String, List<TpmHeadSchemeForecastProductEntity>> productListMap = productList.stream().collect(Collectors.groupingBy(TpmHeadSchemeForecastProductEntity::getSchemeForecastId));

        String[] formulaIgnoreFieldArr = TpmHeadSchemeForecastProductRepository.excludeFieldList.toArray(new String[]{});
        for (TpmHeadSchemeForecastEntity entity : list) {
            if (formulaMap.containsKey(entity.getId())) {
                BeanUtils.copyProperties(formulaMap.get(entity.getId()), entity, formulaIgnoreFieldArr);
            }
            if (productListMap.containsKey(entity.getId())) {
                List<TpmHeadSchemeForecastProductEntity> productEntityList = productListMap.get(entity.getId());
                productEntityList.sort(Comparator.comparing(TpmHeadSchemeForecastProductEntity::getProductCode));
                List<String> productCodeList = productEntityList.stream().map(TpmHeadSchemeForecastProductEntity::getProductCode).collect(Collectors.toList());
                List<String> productNameList = productEntityList.stream().map(TpmHeadSchemeForecastProductEntity::getProductName).collect(Collectors.toList());
                entity.setProductCode(String.join(",", productCodeList));
                entity.setProductName(String.join(",", productNameList));
            }
        }
        return list;
    }

    public List<TpmHeadSchemeForecastEntity> clearExtend(List<TpmHeadSchemeForecastEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        for (TpmHeadSchemeForecastEntity forecastEntity : list) {
            forecastEntity.setWriteOffConditions(null);
            forecastEntity.setWriteOffFormula(null);
            forecastEntity.setWriteOffConditionValue(null);
            forecastEntity.setWriteOffFormulaValue(null);
            forecastEntity.setCalParam(null);
            forecastEntity.setCalEx(null);
            forecastEntity.setProductCode(null);
            forecastEntity.setProductName(null);
        }
        return list;
    }

    public List<TpmHeadSchemeForecastEntity> list(QueryWrapper<TpmHeadSchemeForecastEntity> queryWrapper) {
        List<TpmHeadSchemeForecastEntity> list = super.list(queryWrapper);
        return this.loadExtend(list);
    }

    public TpmHeadSchemeForecastEntity getByIdOrCode(String id, String code) {
        TpmHeadSchemeForecastEntity entity = this.lambdaQuery()
                .eq(TpmHeadSchemeForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmHeadSchemeForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(StringUtils.isNotEmpty(id), TpmHeadSchemeForecastEntity::getId, id)
                .eq(StringUtils.isNotEmpty(code),TpmHeadSchemeForecastEntity::getSchemeForecastCode, code)
                .one();
        if (Objects.isNull(entity)) {
            return null;
        }
        return this.loadExtend(Lists.newArrayList(entity)).get(0);
    }

    @Override
    public TpmHeadSchemeForecastEntity getById(Serializable id) {
        TpmHeadSchemeForecastEntity entity = super.getById(id);
        if (Objects.isNull(entity)) {
            return null;
        }
        return this.loadExtend(Lists.newArrayList(entity)).get(0);
    }

    @Override
    public boolean save(TpmHeadSchemeForecastEntity entity) {
        TpmHeadSchemeForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, TpmHeadSchemeForecastFormulaEntity.class);
        List<TpmHeadSchemeForecastProductEntity> productEntityList = tpmHeadSchemeForecastProductRepository.buildEntityList(entity);
        List<TpmHeadSchemeForecastTerminalEntity> terminalEntityList = tpmHeadSchemeForecastTerminalRepository.buildEntityList(entity);

        entity = this.clearExtend(Lists.newArrayList(entity)).get(0);
        boolean save = super.save(entity);
        //保存下公式扩展表
        formulaEntity.setId(entity.getId());
        tpmHeadSchemeForecastFormulaRepository.save(formulaEntity);
        //保存下产品扩展表
        for (TpmHeadSchemeForecastProductEntity productEntity : productEntityList) {
            productEntity.setSchemeForecastId(entity.getId());
        }
        tpmHeadSchemeForecastProductRepository.saveBatch(productEntityList);
        //保存下门店扩展表
        for (TpmHeadSchemeForecastTerminalEntity terminalEntity : terminalEntityList) {
            terminalEntity.setSchemeForecastId(entity.getId());
        }
        tpmHeadSchemeForecastTerminalRepository.saveBatch(terminalEntityList);
        return save;
    }

    @Override
    public boolean updateById(TpmHeadSchemeForecastEntity entity) {
        TpmHeadSchemeForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, TpmHeadSchemeForecastFormulaEntity.class);
        List<TpmHeadSchemeForecastProductEntity> productEntityList = tpmHeadSchemeForecastProductRepository.buildEntityList(entity);
        List<TpmHeadSchemeForecastTerminalEntity> terminalEntityList = tpmHeadSchemeForecastTerminalRepository.buildEntityList(entity);

        entity = this.clearExtend(Lists.newArrayList(entity)).get(0);
        boolean result = super.updateById(entity);

        //保存下公式扩展表
        tpmHeadSchemeForecastFormulaRepository.saveOrUpdate(formulaEntity);
        //保存下产品扩展表
        for (TpmHeadSchemeForecastProductEntity productEntity : productEntityList) {
            productEntity.setSchemeForecastId(entity.getId());
        }
        tpmHeadSchemeForecastProductRepository.removeByForecastIds(Lists.newArrayList(entity.getId()));
        tpmHeadSchemeForecastProductRepository.saveBatch(productEntityList);
        //保存下门店扩展表
        for (TpmHeadSchemeForecastTerminalEntity terminalEntity : terminalEntityList) {
            terminalEntity.setSchemeForecastId(entity.getId());
        }
        tpmHeadSchemeForecastTerminalRepository.removeByForecastIds(Lists.newArrayList(entity.getId()));
        tpmHeadSchemeForecastTerminalRepository.saveBatch(terminalEntityList);
        return result;
    }

    @Override
    public boolean saveOrUpdate(TpmHeadSchemeForecastEntity entity, Wrapper<TpmHeadSchemeForecastEntity> updateWrapper) {
        TpmHeadSchemeForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, TpmHeadSchemeForecastFormulaEntity.class);
        List<TpmHeadSchemeForecastProductEntity> productEntityList = tpmHeadSchemeForecastProductRepository.buildEntityList(entity);
        List<TpmHeadSchemeForecastTerminalEntity> terminalEntityList = tpmHeadSchemeForecastTerminalRepository.buildEntityList(entity);

        entity = this.clearExtend(Lists.newArrayList(entity)).get(0);
        boolean result = super.saveOrUpdate(entity, updateWrapper);

        //保存下公式扩展表
        tpmHeadSchemeForecastFormulaRepository.saveOrUpdate(formulaEntity);
        //保存下产品扩展表
        for (TpmHeadSchemeForecastProductEntity productEntity : productEntityList) {
            productEntity.setSchemeForecastId(entity.getId());
        }
        tpmHeadSchemeForecastProductRepository.removeByForecastIds(Lists.newArrayList(entity.getId()));
        tpmHeadSchemeForecastProductRepository.saveBatch(productEntityList);
        //保存下门店扩展表
        for (TpmHeadSchemeForecastTerminalEntity terminalEntity : terminalEntityList) {
            terminalEntity.setSchemeForecastId(entity.getId());
        }
        tpmHeadSchemeForecastTerminalRepository.removeByForecastIds(Lists.newArrayList(entity.getId()));
        tpmHeadSchemeForecastTerminalRepository.saveBatch(terminalEntityList);
        return result;
    }

    @Override
    public boolean saveBatch(Collection<TpmHeadSchemeForecastEntity> entityList, int batchSize) {
        List<TpmHeadSchemeForecastFormulaEntity> formulaEntityList = Lists.newArrayList();
        List<TpmHeadSchemeForecastProductEntity> productEntityList = new ArrayList<>();
        List<TpmHeadSchemeForecastTerminalEntity> terminalEntityList = new ArrayList<>();
        for (TpmHeadSchemeForecastEntity entity : entityList) {
            entity.setId(UUID.randomUUID().toString().replace("-", ""));

            TpmHeadSchemeForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, TpmHeadSchemeForecastFormulaEntity.class);
            formulaEntityList.add(formulaEntity);

            List<TpmHeadSchemeForecastProductEntity> productList = tpmHeadSchemeForecastProductRepository.buildEntityList(entity);
            for (TpmHeadSchemeForecastProductEntity productEntity : productList) {
                productEntity.setSchemeForecastId(entity.getId());
            }
            productEntityList.addAll(productList);

            List<TpmHeadSchemeForecastTerminalEntity> terminalList = tpmHeadSchemeForecastTerminalRepository.buildEntityList(entity);
            for (TpmHeadSchemeForecastTerminalEntity terminalEntity : terminalList) {
                terminalEntity.setSchemeForecastId(entity.getId());
            }
            terminalEntityList.addAll(terminalList);
        }
        entityList = this.clearExtend(Lists.newArrayList(entityList));
        boolean result = super.saveBatch(entityList, batchSize);
        //保存下公式扩展表
        tpmHeadSchemeForecastFormulaRepository.saveBatch(formulaEntityList, batchSize);
        //保存下产品扩展表
        tpmHeadSchemeForecastProductRepository.removeByForecastIds(entityList.stream().map(TpmHeadSchemeForecastEntity::getId).collect(Collectors.toList()));
        tpmHeadSchemeForecastProductRepository.saveBatch(productEntityList);
        //保存下门店扩展表
        tpmHeadSchemeForecastTerminalRepository.removeByForecastIds(entityList.stream().map(TpmHeadSchemeForecastEntity::getId).collect(Collectors.toList()));
        tpmHeadSchemeForecastTerminalRepository.saveBatch(terminalEntityList);

        return result;
    }

    @Override
    public boolean saveOrUpdateBatch(Collection<TpmHeadSchemeForecastEntity> entityList, int batchSize) {
        List<TpmHeadSchemeForecastFormulaEntity> formulaEntityList = Lists.newArrayList();
        List<TpmHeadSchemeForecastProductEntity> productEntityList = new ArrayList<>();
        List<TpmHeadSchemeForecastTerminalEntity> terminalEntityList = new ArrayList<>();
        for (TpmHeadSchemeForecastEntity entity : entityList) {
            entity.setId(UUID.randomUUID().toString().replace("-", ""));

            TpmHeadSchemeForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, TpmHeadSchemeForecastFormulaEntity.class);
            formulaEntityList.add(formulaEntity);

            List<TpmHeadSchemeForecastProductEntity> productList = tpmHeadSchemeForecastProductRepository.buildEntityList(entity);
            for (TpmHeadSchemeForecastProductEntity productEntity : productList) {
                productEntity.setSchemeForecastId(entity.getId());
            }
            productEntityList.addAll(productList);

            List<TpmHeadSchemeForecastTerminalEntity> terminalList = tpmHeadSchemeForecastTerminalRepository.buildEntityList(entity);
            for (TpmHeadSchemeForecastTerminalEntity terminalEntity : terminalList) {
                terminalEntity.setSchemeForecastId(entity.getId());
            }
            terminalEntityList.addAll(terminalList);
        }

        entityList = this.clearExtend(Lists.newArrayList(entityList));
        boolean result = super.saveOrUpdateBatch(entityList, batchSize);
        //保存下公式扩展表
        tpmHeadSchemeForecastFormulaRepository.saveOrUpdateBatch(formulaEntityList, batchSize);
        //保存下产品扩展表
        tpmHeadSchemeForecastProductRepository.removeByForecastIds(entityList.stream().map(TpmHeadSchemeForecastEntity::getId).collect(Collectors.toList()));
        tpmHeadSchemeForecastProductRepository.saveBatch(productEntityList);
        //保存下门店扩展表
        tpmHeadSchemeForecastTerminalRepository.removeByForecastIds(entityList.stream().map(TpmHeadSchemeForecastEntity::getId).collect(Collectors.toList()));
        tpmHeadSchemeForecastTerminalRepository.saveBatch(terminalEntityList);
        return result;
    }

    @Override
    public boolean updateBatchById(Collection<TpmHeadSchemeForecastEntity> entityList, int batchSize) {
        List<TpmHeadSchemeForecastFormulaEntity> formulaEntityList = Lists.newArrayList();
        List<TpmHeadSchemeForecastProductEntity> productEntityList = new ArrayList<>();
        List<TpmHeadSchemeForecastTerminalEntity> terminalEntityList = new ArrayList<>();
        for (TpmHeadSchemeForecastEntity entity : entityList) {
            TpmHeadSchemeForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, TpmHeadSchemeForecastFormulaEntity.class);
            formulaEntityList.add(formulaEntity);

            List<TpmHeadSchemeForecastProductEntity> productList = tpmHeadSchemeForecastProductRepository.buildEntityList(entity);
            for (TpmHeadSchemeForecastProductEntity productEntity : productList) {
                productEntity.setSchemeForecastId(entity.getId());
            }
            productEntityList.addAll(productList);

            List<TpmHeadSchemeForecastTerminalEntity> terminalList = tpmHeadSchemeForecastTerminalRepository.buildEntityList(entity);
            for (TpmHeadSchemeForecastTerminalEntity terminalEntity : terminalList) {
                terminalEntity.setSchemeForecastId(entity.getId());
            }
            terminalEntityList.addAll(terminalList);
        }

        entityList = this.clearExtend(Lists.newArrayList(entityList));
        boolean result = super.updateBatchById(entityList, batchSize);

        //保存下公式扩展表
        tpmHeadSchemeForecastFormulaRepository.updateBatchById(formulaEntityList, batchSize);
        //保存下产品扩展表
        tpmHeadSchemeForecastProductRepository.removeByForecastIds(entityList.stream().map(TpmHeadSchemeForecastEntity::getId).collect(Collectors.toList()));
        tpmHeadSchemeForecastProductRepository.saveBatch(productEntityList);
        //保存下门店扩展表
        tpmHeadSchemeForecastTerminalRepository.removeByForecastIds(entityList.stream().map(TpmHeadSchemeForecastEntity::getId).collect(Collectors.toList()));
        tpmHeadSchemeForecastTerminalRepository.saveBatch(terminalEntityList);
        return result;
    }

    @Override
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return true;
        }
        List<String> ids = idList.stream().map(Object::toString).collect(Collectors.toList());
        boolean result = super.removeByIds(idList);
        boolean formulaResult = this.tpmHeadSchemeForecastFormulaRepository.removeByIds(idList);
        boolean productResult = this.tpmHeadSchemeForecastProductRepository.removeByForecastIds(ids);
        boolean terminalResult = this.tpmHeadSchemeForecastTerminalRepository.removeByForecastIds(ids);
        return result && formulaResult && productResult && terminalResult;
    }

    public List<TpmHeadSchemeForecastEntity> findByActivityDetailItemCodes(Set<String> schemeItemCodes) {
        return this.lambdaQuery()
                .eq(TpmHeadSchemeForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmHeadSchemeForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(TpmHeadSchemeForecastEntity::getSchemeItemCode, schemeItemCodes)
                .list();
    }

    public List<TpmHeadSchemeForecastEntity> findByPlanItemCodes(List<String> planItemCodes) {
        if(CollectionUtils.isEmpty(planItemCodes)){
            return Lists.newArrayList();
        }

        return this.lambdaQuery()
                .eq(TpmHeadSchemeForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmHeadSchemeForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(TpmHeadSchemeForecastEntity::getSchemeItemCode, planItemCodes)
                .eq(TpmHeadSchemeForecastEntity::getStatus, TpmHeadSchemeStatusEnum.CONFIRMED.getCode())
                .isNull(TpmHeadSchemeForecastEntity::getMonthBudgetCodeDeduction)
                .list();
    }

    public List<TpmHeadSchemeForecastEntity> findByPlanItemCodesHasBudget(List<String> planItemCodes) {
        if(CollectionUtils.isEmpty(planItemCodes)){
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(TpmHeadSchemeForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmHeadSchemeForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(TpmHeadSchemeForecastEntity::getSchemeItemCode, planItemCodes)
                .eq(TpmHeadSchemeForecastEntity::getStatus, TpmHeadSchemeStatusEnum.CONFIRMED.getCode())
                .isNotNull(TpmHeadSchemeForecastEntity::getMonthBudgetCodeDeduction)
                .list();
    }

    public void deleteBySchemeItemCode(String planItemCode) {
        this.lambdaUpdate()
                .eq(TpmHeadSchemeForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmHeadSchemeForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(TpmHeadSchemeForecastEntity::getSchemeItemCode, planItemCode)
                .remove();
    }
}
