package com.biz.crm.tpm.business.scheme.forecast.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmHeadSchemeForecastTerminalEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmHeadSchemeForecastEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmHeadSchemeForecastTerminalEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.mapper.TpmHeadSchemeForecastTerminalMapper;
import com.biz.crm.tpm.business.scheme.forecast.local.mapper.TpmHeadSchemeForecastTerminalMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import liquibase.util.StringUtil;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Component
public class TpmHeadSchemeForecastTerminalRepository extends ServiceImpl<TpmHeadSchemeForecastTerminalMapper, TpmHeadSchemeForecastTerminalEntity> {

    @Autowired(required = false)
    private TpmHeadSchemeForecastTerminalMapper tpmHeadSchemeForecastTerminalMapper;

    private static final String property_schemeForecastId = "schemeForecastCodeId";
    private static final String property_schemeForecastCode = "schemeForecastCode";
    private static final String property_schemeCode = "schemeCode";
    private static final String property_schemeItemCode = "schemeItemCode";
    private static final String property_yearMonthLy = "yearMonthLy";

    public static final List<String> excludeFieldList = Lists.newArrayList();

    static {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(TenantEntity.class);
        excludeFieldList.addAll(Arrays.stream(propertyDescriptors).map(PropertyDescriptor::getName).collect(Collectors.toList()));
        excludeFieldList.add(property_schemeForecastId);
        excludeFieldList.add(property_schemeForecastCode);
        excludeFieldList.add(property_schemeCode);
        excludeFieldList.add(property_schemeItemCode);
        excludeFieldList.add(property_yearMonthLy);
    }

    //判断下是否所有属性都为空
    public boolean hasNotEmptyProperty(TpmHeadSchemeForecastTerminalEntity entity) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(TpmHeadSchemeForecastTerminalEntity.class);
        boolean hasNotEmptyProperty = false;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (excludeFieldList.contains(propertyDescriptor.getName())) {
                continue;
            }
            try {
                Object invoke = propertyDescriptor.getReadMethod().invoke(entity);
                if (null != invoke && StringUtil.isNotEmpty(invoke.toString())) {
                    hasNotEmptyProperty = true;
                    break;
                }
            } catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return hasNotEmptyProperty;
    }

    public List<TpmHeadSchemeForecastTerminalEntity> buildEntityList(TpmHeadSchemeForecastEntity entity) {
        List<TpmHeadSchemeForecastTerminalEntity> terminalEntityList = new ArrayList<>();
        if (!StringUtils.isEmpty(entity.getTerminalCode())) {
            String[] codes = entity.getTerminalCode().split(",");
            List<String> names = Lists.newArrayList();
            if (!StringUtils.isEmpty(entity.getTerminalName())) {
                names = Arrays.asList(entity.getTerminalName().split(","));
            }
            for (int i = 0; i < codes.length; i++) {
                TpmHeadSchemeForecastTerminalEntity terminalEntity = new TpmHeadSchemeForecastTerminalEntity();
                terminalEntity.setTerminalCode(codes[i]);
                if (i < names.size()) {
                    terminalEntity.setTerminalName(names.get(i));
                }
                terminalEntity.setTenantCode(TenantUtils.getTenantCode());
                terminalEntity.setSchemeForecastId(entity.getId());
                terminalEntity.setSchemeForecastCode(entity.getSchemeForecastCode());
                terminalEntity.setSchemeCode(entity.getSchemeCode());
                terminalEntity.setSchemeItemCode(entity.getSchemeItemCode());
                terminalEntity.setYearMonthLy(entity.getYearMonthLy());
                terminalEntityList.add(terminalEntity);
            }
        }
        return terminalEntityList;
    }

    public boolean removeByForecastIds(List<String> forecastIds) {
        return this.lambdaUpdate()
                .eq(TpmHeadSchemeForecastTerminalEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(TpmHeadSchemeForecastTerminalEntity::getSchemeForecastId, forecastIds).remove();
    }

    public List<TpmHeadSchemeForecastTerminalEntity> findByForecastIds(List<String> forecastIds) {
        return this.lambdaQuery()
                .eq(TpmHeadSchemeForecastTerminalEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(TpmHeadSchemeForecastTerminalEntity::getSchemeForecastId, forecastIds).list();
    }
}
