package com.biz.crm.tpm.business.scheme.forecast.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmHeadSchemeForecastEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmHeadSchemeForecastWorkflowEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmVerticalSchemeForecastBudgetCashEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.mapper.TpmHeadSchemeForecastWorkflowMapper;
import com.biz.crm.tpm.business.scheme.forecast.local.mapper.TpmVerticalSchemeForecastBudgetCashMapper;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmVerticalSchemeForecastBudgetCashQueryDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.enums.TpmHeadSchemeWorkflowTypeEnum;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmVerticalSchemeForecastBudgetCashVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
public class TpmHeadSchemeForecastWorkflowRepository extends ServiceImpl<TpmHeadSchemeForecastWorkflowMapper, TpmHeadSchemeForecastWorkflowEntity> {

    @Autowired(required = false)
    private TpmHeadSchemeForecastWorkflowMapper tpmHeadSchemeForecastWorkflowMapper;

    public List<TpmHeadSchemeForecastWorkflowEntity> findByForecastId(List<String> schemeForecastIdList, String workflowType) {
        if (CollectionUtils.isEmpty(schemeForecastIdList)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(TpmHeadSchemeForecastWorkflowEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmHeadSchemeForecastWorkflowEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(StringUtils.isNotEmpty(workflowType), TpmHeadSchemeForecastWorkflowEntity::getWorkflowType, workflowType)
                .in(TpmHeadSchemeForecastWorkflowEntity::getSchemeForecastId, schemeForecastIdList)
                .list();
    }


    /**
     * 通过方案预测id移除所有流程明细
     *
     * @param schemeForecastIdList
     */
    public void removeByForecastId(List<String> schemeForecastIdList) {
        this.lambdaUpdate()
                .eq(TpmHeadSchemeForecastWorkflowEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmHeadSchemeForecastWorkflowEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(TpmHeadSchemeForecastWorkflowEntity::getSchemeForecastId, schemeForecastIdList)
                .remove();
    }

    /**
     * 根据方案预测id+流程状态查询对应流程数量
     *
     * @param schemeForecastIdList
     * @param processStatus
     * @return
     */
    public Map<String, Long> countPassNum(List<String> schemeForecastIdList, String processStatus) {
        List<TpmHeadSchemeForecastWorkflowEntity> list = this.lambdaQuery()
                .eq(TpmHeadSchemeForecastWorkflowEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmHeadSchemeForecastWorkflowEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(TpmHeadSchemeForecastWorkflowEntity::getProcessStatus, processStatus)
                .in(TpmHeadSchemeForecastWorkflowEntity::getSchemeForecastId, schemeForecastIdList)
                .select(TpmHeadSchemeForecastWorkflowEntity::getSchemeForecastId)
                .list();

        return list.stream().collect(Collectors.groupingBy(TpmHeadSchemeForecastWorkflowEntity::getSchemeForecastId, Collectors.counting()));
    }

    /**
     * 根据流程编码查询流程数据
     *
     * @param processNo
     * @return
     */
    public List<TpmHeadSchemeForecastWorkflowEntity> findByProcessNo(String processNo) {
        return this.lambdaQuery()
                .eq(TpmHeadSchemeForecastWorkflowEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmHeadSchemeForecastWorkflowEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(TpmHeadSchemeForecastWorkflowEntity::getProcessNo, processNo)
                .list();
    }

    @Transactional
    public void updateProcessStatus(String processStatus,
                                    String processNo,
                                    String workflowType) {
        this.lambdaUpdate()
                .eq(TpmHeadSchemeForecastWorkflowEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmHeadSchemeForecastWorkflowEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(TpmHeadSchemeForecastWorkflowEntity::getWorkflowType, workflowType)
                .eq(TpmHeadSchemeForecastWorkflowEntity::getProcessNo, processNo)
                .set(TpmHeadSchemeForecastWorkflowEntity::getProcessStatus, processStatus)
                .update();
    }
}
