package com.biz.crm.tpm.business.scheme.forecast.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmVerticalSchemeForecastBudgetCashEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmVerticalSchemeForecastEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmVerticalSchemeForecastProductEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.mapper.TpmVerticalSchemeForecastBudgetCashMapper;
import com.biz.crm.tpm.business.scheme.forecast.local.mapper.TpmVerticalSchemeForecastProductMapper;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmVerticalSchemeForecastBudgetCashDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmVerticalSchemeForecastBudgetCashQueryDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmVerticalSchemeForecastBudgetCashVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import liquibase.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

@Component
public class TpmVerticalSchemeForecastBudgetCashRepository extends ServiceImpl<TpmVerticalSchemeForecastBudgetCashMapper, TpmVerticalSchemeForecastBudgetCashEntity> {

    @Autowired(required = false)
    private TpmVerticalSchemeForecastBudgetCashMapper tpmVerticalSchemeForecastBudgetCashMapper;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 通过方案预测参数查询预算兑付明细
     *
     * @param schemeForecastId
     * @param schemeForecastCode
     * @param schemeCode
     * @param schemeItemCode
     * @return
     */
    public List<TpmVerticalSchemeForecastBudgetCashEntity> findByForecastCondition(String schemeForecastId,
                                                                                   String schemeForecastCode,
                                                                                   String schemeCode,
                                                                                   String schemeItemCode) {
        return findByForecastCondition(schemeForecastId,schemeForecastCode,schemeCode,schemeItemCode,null);
    }

    public List<TpmVerticalSchemeForecastBudgetCashEntity> findByForecastCondition(String schemeForecastId,
                                                                                   String schemeForecastCode,
                                                                                   String schemeCode,
                                                                                   String schemeItemCode,
                                                                                   List<String> schemeForecastIdList) {
        if (StringUtils.isEmpty(schemeForecastId)
                && StringUtils.isEmpty(schemeForecastCode)
                && StringUtils.isEmpty(schemeCode)
                && StringUtils.isEmpty(schemeItemCode)
                && CollectionUtils.isEmpty(schemeForecastIdList)) {
            return Lists.newArrayList();
        }
        LambdaQueryChainWrapper<TpmVerticalSchemeForecastBudgetCashEntity> wrapper = this.lambdaQuery()
                .eq(TpmVerticalSchemeForecastBudgetCashEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmVerticalSchemeForecastBudgetCashEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(StringUtils.isNotEmpty(schemeForecastId), TpmVerticalSchemeForecastBudgetCashEntity::getSchemeForecastId, schemeForecastId)
                .eq(StringUtils.isNotEmpty(schemeForecastCode), TpmVerticalSchemeForecastBudgetCashEntity::getSchemeForecastCode, schemeForecastCode)
                .eq(StringUtils.isNotEmpty(schemeCode), TpmVerticalSchemeForecastBudgetCashEntity::getSchemeCode, schemeCode)
                .eq(StringUtils.isNotEmpty(schemeItemCode), TpmVerticalSchemeForecastBudgetCashEntity::getSchemeItemCode, schemeItemCode);
        if (!CollectionUtils.isEmpty(schemeForecastIdList)){
            wrapper.in(TpmVerticalSchemeForecastBudgetCashEntity::getSchemeForecastId,schemeForecastIdList);
        }
        return wrapper
                .orderByAsc(TpmVerticalSchemeForecastBudgetCashEntity::getBudgetCode)
                .list();

    }

    public List<TpmVerticalSchemeForecastBudgetCashVo> findDetailListByConditions(TpmVerticalSchemeForecastBudgetCashDto cashDto) {
        LambdaQueryChainWrapper<TpmVerticalSchemeForecastBudgetCashEntity> wrapper = this.lambdaQuery()
                .eq(TpmVerticalSchemeForecastBudgetCashEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmVerticalSchemeForecastBudgetCashEntity::getTenantCode, TenantUtils.getTenantCode());
        boolean hasCondition = false;
        if (!CollectionUtils.isEmpty(cashDto.getDetailCodeList())){
            hasCondition = true;
            wrapper.in(TpmVerticalSchemeForecastBudgetCashEntity::getDetailCode,cashDto.getDetailCodeList());
        }
        if (!hasCondition){
            return Lists.newArrayList();
        }
        List<TpmVerticalSchemeForecastBudgetCashEntity> list = wrapper.list();
        return (List<TpmVerticalSchemeForecastBudgetCashVo>) nebulaToolkitService.copyCollectionByWhiteList(list,TpmVerticalSchemeForecastBudgetCashEntity.class,TpmVerticalSchemeForecastBudgetCashVo.class, HashSet.class,ArrayList.class);
    }

    /**
     * 通过方案预测id移除所有兑付明细
     *
     * @param schemeForecastId
     */
    public void removeByForecastId(String schemeForecastId) {
        this.lambdaUpdate()
                .eq(TpmVerticalSchemeForecastBudgetCashEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmVerticalSchemeForecastBudgetCashEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(TpmVerticalSchemeForecastBudgetCashEntity::getSchemeForecastId, schemeForecastId)
                .remove();
    }

    /**
     * 通过方案明细编码查关联的预算
     *
     * @param planItemCode
     * @return
     */
    public List<TpmVerticalSchemeForecastBudgetCashVo> findBudgetListByPlanItemCode(String planItemCode) {
        if (StringUtils.isEmpty(planItemCode)) {
            return Lists.newArrayList();
        }
        return tpmVerticalSchemeForecastBudgetCashMapper.findBudgetListByPlanItemCode(Lists.newArrayList(planItemCode));
    }

    /**
     * 通过方案明细编码查关联的预算
     * @return
     */
    public List<TpmVerticalSchemeForecastBudgetCashVo> findBudgetListByPlanItemCode(List<String> planItemCodeList) {
        if (CollectionUtils.isEmpty(planItemCodeList)) {
            return Lists.newArrayList();
        }
        return tpmVerticalSchemeForecastBudgetCashMapper.findBudgetListByPlanItemCode(planItemCodeList);
    }

    /**
     * 通过明细编码查询
     *
     * @param detailCodeList
     * @return
     */
    public List<TpmVerticalSchemeForecastBudgetCashEntity> findBudgetListByDetailCodes(List<String> detailCodeList) {
        if (CollectionUtils.isEmpty(detailCodeList)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(TpmVerticalSchemeForecastBudgetCashEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmVerticalSchemeForecastBudgetCashEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(TpmVerticalSchemeForecastBudgetCashEntity::getDetailCode, detailCodeList)
                .list();
    }

    public Page<TpmVerticalSchemeForecastBudgetCashVo> findCashPage(Pageable pageable, TpmVerticalSchemeForecastBudgetCashQueryDto dto) {
        Page<TpmVerticalSchemeForecastBudgetCashQueryDto> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return tpmVerticalSchemeForecastBudgetCashMapper.findCashPage(page, dto);
    }
}
