package com.biz.crm.tpm.business.scheme.forecast.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmHeadSchemeForecastFileEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmHeadSchemeForecastWorkflowEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.mapper.TpmHeadSchemeForecastFileMapper;
import com.biz.crm.tpm.business.scheme.forecast.local.mapper.TpmHeadSchemeForecastWorkflowMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
public class TpmVerticalSchemeForecastFileRepository extends ServiceImpl<TpmHeadSchemeForecastFileMapper, TpmHeadSchemeForecastFileEntity> {

    @Autowired(required = false)
    private TpmHeadSchemeForecastFileMapper tpmHeadSchemeForecastFileMapper;

    /**
     * 通过方案预测id移除所有流程明细
     *
     * @param schemeForecastIdList
     */
    public void removeByForecastId(List<String> schemeForecastIdList) {
        this.lambdaUpdate()
                .eq(TpmHeadSchemeForecastFileEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(TpmHeadSchemeForecastFileEntity::getSchemeForecastId, schemeForecastIdList)
                .remove();
    }

    /**
     * 通过方案预测id查询
     *
     * @param id
     * @return
     */
    public List<TpmHeadSchemeForecastFileEntity> findBySchemeForecastId(String id) {
        return lambdaQuery().eq(TpmHeadSchemeForecastFileEntity::getSchemeForecastId, id).list();
    }
}
