package com.biz.crm.tpm.business.scheme.forecast.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmVerticalSchemeForecastFormulaEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.mapper.SchemeForecastFormulaMapper;
import com.biz.crm.tpm.business.scheme.forecast.local.mapper.TpmVerticalSchemeForecastFormulaMapper;
import liquibase.util.StringUtil;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;


@Component
public class TpmVerticalSchemeForecastFormulaRepository extends ServiceImpl<TpmVerticalSchemeForecastFormulaMapper, TpmVerticalSchemeForecastFormulaEntity> {

    @Autowired(required = false)
    private TpmVerticalSchemeForecastFormulaMapper tpmVerticalSchemeForecastFormulaMapper;

    private static final String property_schemeForecastCode = "schemeForecastCode";
    private static final String property_schemeCode = "schemeCode";
    private static final String property_schemeItemCode = "schemeItemCode";

    public static final List<String> excludeFieldList = Lists.newArrayList();

    static {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(TenantEntity.class);
        excludeFieldList.addAll(Arrays.stream(propertyDescriptors).map(PropertyDescriptor::getName).collect(Collectors.toList()));
        excludeFieldList.add(property_schemeForecastCode);
        excludeFieldList.add(property_schemeCode);
        excludeFieldList.add(property_schemeItemCode);
    }

    //判断下是否所有属性都为空
    public boolean hasNotEmptyProperty(TpmVerticalSchemeForecastFormulaEntity entity){
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(TpmVerticalSchemeForecastFormulaEntity.class);
        boolean hasNotEmptyProperty = false;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (excludeFieldList.contains(propertyDescriptor.getName())){
                continue;
            }
            try {
                Object invoke = propertyDescriptor.getReadMethod().invoke(entity);
                if (null != invoke && StringUtil.isNotEmpty(invoke.toString())){
                    hasNotEmptyProperty = true;
                    break;
                }
            } catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return hasNotEmptyProperty;
    }
}
