package com.biz.crm.tpm.business.scheme.forecast.local.repository;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.third.system.ecrm.sdk.enumeration.PushECRMStatusEnum;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.DetailedForecastRequestVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.constant.DetailedPredictionTypeEnum;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoCreateDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoRefreshDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastFeeLedgerDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastFeeLedgerResultVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastFeeLedgerVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.*;
import com.biz.crm.tpm.business.scheme.forecast.local.mapper.SchemeForecastMapper;
import com.biz.crm.tpm.business.scheme.forecast.local.mapper.TpmVerticalSchemeForecastMapper;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.*;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.SchemeForecastVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;


@Component
public class TpmVerticalSchemeForecastRepository extends ServiceImpl<TpmVerticalSchemeForecastMapper, TpmVerticalSchemeForecastEntity> {

    @Autowired(required = false)
    private TpmVerticalSchemeForecastMapper tpmVerticalSchemeForecastMapper;

    @Autowired(required = false)
    private TpmVerticalSchemeForecastFormulaRepository tpmVerticalSchemeForecastFormulaRepository;

    @Autowired(required = false)
    private TpmVerticalSchemeForecastProductRepository tpmVerticalSchemeForecastProductRepository;

    @Autowired(required = false)
    private TpmVerticalSchemeForecastTerminalRepository tpmVerticalSchemeForecastTerminalRepository;

    public List<TpmVerticalSchemeForecastEntity> findByIds(List<String> ids) {
        List<TpmVerticalSchemeForecastEntity> list = this.lambdaQuery()
                .eq(TpmVerticalSchemeForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmVerticalSchemeForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(UuidEntity::getId, ids)
                .list();
        return this.loadExtend(list);
    }

    public List<TpmVerticalSchemeForecastEntity> findByDetailCodes(List<String> schemeCodes) {
        List<TpmVerticalSchemeForecastEntity> list = this.lambdaQuery()
                .eq(TpmVerticalSchemeForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmVerticalSchemeForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(TpmVerticalSchemeForecastEntity::getSchemeCode, schemeCodes)
                .list();
        return this.loadExtend(list);
    }

    public List<TpmVerticalSchemeForecastEntity> findBySchemeForecastCodes(List<String> schemeForecastCodes) {
        List<TpmVerticalSchemeForecastEntity> list = this.lambdaQuery()
                .eq(TpmVerticalSchemeForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmVerticalSchemeForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(TpmVerticalSchemeForecastEntity::getSchemeForecastCode, schemeForecastCodes)
                .list();
        return this.loadExtend(list);
    }

    public List<TpmVerticalSchemeForecastEntity> getDetailedForecastByParams(TpmVerticalSchemeForecastDto dto) {

        List<TpmVerticalSchemeForecastEntity> list = this.baseMapper.selectList(Wrappers.lambdaQuery(TpmVerticalSchemeForecastEntity.class)
                .eq(TpmVerticalSchemeForecastEntity::getSchemeItemCode, dto.getSchemeItemCode())
                .orderByDesc(TpmVerticalSchemeForecastEntity::getCreateTime).last("limit 1"));

        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return this.loadExtend(list);
    }

    public Long findAutoRefreshDataCount(TpmVerticalSchemeForecastAutoRefreshDto dto) {
        return this.tpmVerticalSchemeForecastMapper.findAutoRefreshDataCount(dto);
    }

    public List<String> findAutoRefreshDataList(Pageable pageable, TpmVerticalSchemeForecastAutoRefreshDto dto) {
        Page<String> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<String> pageList = this.tpmVerticalSchemeForecastMapper.findAutoRefreshDataList(page, dto);
        return pageList.getRecords();
    }

    public List<String> findAutoCreateDataList(TpmVerticalSchemeForecastAutoCreateDto dto) {
        return this.tpmVerticalSchemeForecastMapper.findAutoCreateDataList(dto);
    }

    public List<String> findAutoUpdateShowFlagDataList(TpmVerticalSchemeForecastAutoCreateDto dto) {
        return this.tpmVerticalSchemeForecastMapper.findAutoUpdateShowFlagDataList(dto);
    }

    public Long autoUpdateShowFLag(List<String> schemeItemCodes) {
        return tpmVerticalSchemeForecastMapper.autoUpdateShowFLag(schemeItemCodes);
    }

    @Transactional
    public void updateProcessStatus(String schemeForecastCode, String processStatus, String processNo, String status) {
        this.lambdaUpdate()
                .eq(TpmVerticalSchemeForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmVerticalSchemeForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(TpmVerticalSchemeForecastEntity::getSchemeForecastCode, schemeForecastCode)
                .set(TpmVerticalSchemeForecastEntity::getProcessStatus, processStatus)
                .set(StringUtils.isNotEmpty(processNo), TpmVerticalSchemeForecastEntity::getProcessNo, processNo)
                .set(StringUtils.isNotEmpty(status), TpmVerticalSchemeForecastEntity::getStatus, status)
                .update();
    }

    @Transactional
    public void updateProcessStatus(List<String> schemeForecastCodeList, String processStatus, String processNo, String status) {
        this.lambdaUpdate()
                .eq(TpmVerticalSchemeForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmVerticalSchemeForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(TpmVerticalSchemeForecastEntity::getSchemeForecastCode, schemeForecastCodeList)
                .set(TpmVerticalSchemeForecastEntity::getProcessStatus, processStatus)
                .set(StringUtils.isNotEmpty(processNo), TpmVerticalSchemeForecastEntity::getProcessNo, processNo)
                .set(StringUtils.isNotEmpty(status), TpmVerticalSchemeForecastEntity::getStatus, status)
                .update();
    }

    //扩展表
    //组装公式表字段
    public List<TpmVerticalSchemeForecastEntity> loadExtend(List<TpmVerticalSchemeForecastEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        List<String> idList = list.stream().map(TpmVerticalSchemeForecastEntity::getId).collect(Collectors.toList());

        //公式扩展
        List<TpmVerticalSchemeForecastFormulaEntity> formulaList = tpmVerticalSchemeForecastFormulaRepository.listByIds(idList);
        Map<String, TpmVerticalSchemeForecastFormulaEntity> formulaMap = formulaList.stream().collect(Collectors.toMap(TpmVerticalSchemeForecastFormulaEntity::getId, v -> v));

        //产品扩展
        List<TpmVerticalSchemeForecastProductEntity> productList = tpmVerticalSchemeForecastProductRepository.findByForecastIds(idList);
        Map<String, List<TpmVerticalSchemeForecastProductEntity>> productListMap = productList.stream().collect(Collectors.groupingBy(TpmVerticalSchemeForecastProductEntity::getSchemeForecastId));

        String[] formulaIgnoreFieldArr = TpmVerticalSchemeForecastProductRepository.excludeFieldList.toArray(new String[]{});
        for (TpmVerticalSchemeForecastEntity entity : list) {
            if (formulaMap.containsKey(entity.getId())) {
                BeanUtils.copyProperties(formulaMap.get(entity.getId()), entity, formulaIgnoreFieldArr);
            }
            if (productListMap.containsKey(entity.getId())) {
                List<TpmVerticalSchemeForecastProductEntity> productEntityList = productListMap.get(entity.getId());
                productEntityList.sort(Comparator.comparing(TpmVerticalSchemeForecastProductEntity::getProductCode));
                List<String> productCodeList = productEntityList.stream().map(TpmVerticalSchemeForecastProductEntity::getProductCode).collect(Collectors.toList());
                List<String> productNameList = productEntityList.stream().map(TpmVerticalSchemeForecastProductEntity::getProductName).collect(Collectors.toList());
                entity.setProductCode(String.join(",", productCodeList));
                entity.setProductName(String.join(",", productNameList));
            }
        }
        return list;
    }

    public List<TpmVerticalSchemeForecastEntity> clearExtend(List<TpmVerticalSchemeForecastEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        for (TpmVerticalSchemeForecastEntity forecastEntity : list) {
            forecastEntity.setWriteOffConditions(null);
            forecastEntity.setWriteOffFormula(null);
            forecastEntity.setWriteOffConditionValue(null);
            forecastEntity.setWriteOffFormulaValue(null);
            forecastEntity.setCalParam(null);
            forecastEntity.setCalEx(null);
            forecastEntity.setProductCode(null);
            forecastEntity.setProductName(null);
        }
        return list;
    }

    public List<TpmVerticalSchemeForecastEntity> list(QueryWrapper<TpmVerticalSchemeForecastEntity> queryWrapper) {
        List<TpmVerticalSchemeForecastEntity> list = super.list(queryWrapper);
        return this.loadExtend(list);
    }

    public TpmVerticalSchemeForecastEntity getByIdOrCode(String id, String code) {
        TpmVerticalSchemeForecastEntity entity = this.lambdaQuery()
                .eq(TpmVerticalSchemeForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmVerticalSchemeForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(StringUtils.isNotEmpty(id), TpmVerticalSchemeForecastEntity::getId, id)
                .eq(StringUtils.isNotEmpty(code),TpmVerticalSchemeForecastEntity::getSchemeForecastCode, code)
                .one();
        if (Objects.isNull(entity)) {
            return null;
        }
        return this.loadExtend(Lists.newArrayList(entity)).get(0);
    }

    @Override
    public TpmVerticalSchemeForecastEntity getById(Serializable id) {
        TpmVerticalSchemeForecastEntity entity = super.getById(id);
        if (Objects.isNull(entity)) {
            return null;
        }
        return this.loadExtend(Lists.newArrayList(entity)).get(0);
    }

    @Override
    public boolean save(TpmVerticalSchemeForecastEntity entity) {
        TpmVerticalSchemeForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, TpmVerticalSchemeForecastFormulaEntity.class);
        List<TpmVerticalSchemeForecastProductEntity> productEntityList = tpmVerticalSchemeForecastProductRepository.buildEntityList(entity);
        List<TpmVerticalSchemeForecastTerminalEntity> terminalEntityList = tpmVerticalSchemeForecastTerminalRepository.buildEntityList(entity);

        entity = this.clearExtend(Lists.newArrayList(entity)).get(0);
        boolean save = super.save(entity);
        //保存下公式扩展表
        formulaEntity.setId(entity.getId());
        tpmVerticalSchemeForecastFormulaRepository.save(formulaEntity);
        //保存下产品扩展表
        for (TpmVerticalSchemeForecastProductEntity productEntity : productEntityList) {
            productEntity.setSchemeForecastId(entity.getId());
        }
        tpmVerticalSchemeForecastProductRepository.saveBatch(productEntityList);
        //保存下门店扩展表
        for (TpmVerticalSchemeForecastTerminalEntity terminalEntity : terminalEntityList) {
            terminalEntity.setSchemeForecastId(entity.getId());
        }
        tpmVerticalSchemeForecastTerminalRepository.saveBatch(terminalEntityList);
        return save;
    }

    @Override
    public boolean updateById(TpmVerticalSchemeForecastEntity entity) {
        TpmVerticalSchemeForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, TpmVerticalSchemeForecastFormulaEntity.class);
        List<TpmVerticalSchemeForecastProductEntity> productEntityList = tpmVerticalSchemeForecastProductRepository.buildEntityList(entity);
        List<TpmVerticalSchemeForecastTerminalEntity> terminalEntityList = tpmVerticalSchemeForecastTerminalRepository.buildEntityList(entity);

        entity = this.clearExtend(Lists.newArrayList(entity)).get(0);
        boolean result = super.updateById(entity);

        //保存下公式扩展表
        tpmVerticalSchemeForecastFormulaRepository.saveOrUpdate(formulaEntity);
        //保存下产品扩展表
        for (TpmVerticalSchemeForecastProductEntity productEntity : productEntityList) {
            productEntity.setSchemeForecastId(entity.getId());
        }
        tpmVerticalSchemeForecastProductRepository.removeByForecastIds(Lists.newArrayList(entity.getId()));
        tpmVerticalSchemeForecastProductRepository.saveBatch(productEntityList);
        //保存下门店扩展表
        for (TpmVerticalSchemeForecastTerminalEntity terminalEntity : terminalEntityList) {
            terminalEntity.setSchemeForecastId(entity.getId());
        }
        tpmVerticalSchemeForecastTerminalRepository.removeByForecastIds(Lists.newArrayList(entity.getId()));
        tpmVerticalSchemeForecastTerminalRepository.saveBatch(terminalEntityList);
        return result;
    }

    @Override
    public boolean saveOrUpdate(TpmVerticalSchemeForecastEntity entity, Wrapper<TpmVerticalSchemeForecastEntity> updateWrapper) {
        TpmVerticalSchemeForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, TpmVerticalSchemeForecastFormulaEntity.class);
        List<TpmVerticalSchemeForecastProductEntity> productEntityList = tpmVerticalSchemeForecastProductRepository.buildEntityList(entity);
        List<TpmVerticalSchemeForecastTerminalEntity> terminalEntityList = tpmVerticalSchemeForecastTerminalRepository.buildEntityList(entity);

        entity = this.clearExtend(Lists.newArrayList(entity)).get(0);
        boolean result = super.saveOrUpdate(entity, updateWrapper);

        //保存下公式扩展表
        tpmVerticalSchemeForecastFormulaRepository.saveOrUpdate(formulaEntity);
        //保存下产品扩展表
        for (TpmVerticalSchemeForecastProductEntity productEntity : productEntityList) {
            productEntity.setSchemeForecastId(entity.getId());
        }
        tpmVerticalSchemeForecastProductRepository.removeByForecastIds(Lists.newArrayList(entity.getId()));
        tpmVerticalSchemeForecastProductRepository.saveBatch(productEntityList);
        //保存下门店扩展表
        for (TpmVerticalSchemeForecastTerminalEntity terminalEntity : terminalEntityList) {
            terminalEntity.setSchemeForecastId(entity.getId());
        }
        tpmVerticalSchemeForecastTerminalRepository.removeByForecastIds(Lists.newArrayList(entity.getId()));
        tpmVerticalSchemeForecastTerminalRepository.saveBatch(terminalEntityList);
        return result;
    }

    @Override
    public boolean saveBatch(Collection<TpmVerticalSchemeForecastEntity> entityList, int batchSize) {
        List<TpmVerticalSchemeForecastFormulaEntity> formulaEntityList = Lists.newArrayList();
        List<TpmVerticalSchemeForecastProductEntity> productEntityList = new ArrayList<>();
        List<TpmVerticalSchemeForecastTerminalEntity> terminalEntityList = new ArrayList<>();
        for (TpmVerticalSchemeForecastEntity entity : entityList) {
            entity.setId(UUID.randomUUID().toString().replace("-", ""));

            TpmVerticalSchemeForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, TpmVerticalSchemeForecastFormulaEntity.class);
            formulaEntityList.add(formulaEntity);

            List<TpmVerticalSchemeForecastProductEntity> productList = tpmVerticalSchemeForecastProductRepository.buildEntityList(entity);
            for (TpmVerticalSchemeForecastProductEntity productEntity : productList) {
                productEntity.setSchemeForecastId(entity.getId());
            }
            productEntityList.addAll(productList);

            List<TpmVerticalSchemeForecastTerminalEntity> terminalList = tpmVerticalSchemeForecastTerminalRepository.buildEntityList(entity);
            for (TpmVerticalSchemeForecastTerminalEntity terminalEntity : terminalList) {
                terminalEntity.setSchemeForecastId(entity.getId());
            }
            terminalEntityList.addAll(terminalList);
        }
        entityList = this.clearExtend(Lists.newArrayList(entityList));
        boolean result = super.saveBatch(entityList, batchSize);
        //保存下公式扩展表
        tpmVerticalSchemeForecastFormulaRepository.saveBatch(formulaEntityList, batchSize);
        //保存下产品扩展表
        tpmVerticalSchemeForecastProductRepository.removeByForecastIds(entityList.stream().map(TpmVerticalSchemeForecastEntity::getId).collect(Collectors.toList()));
        tpmVerticalSchemeForecastProductRepository.saveBatch(productEntityList);
        //保存下门店扩展表
        tpmVerticalSchemeForecastTerminalRepository.removeByForecastIds(entityList.stream().map(TpmVerticalSchemeForecastEntity::getId).collect(Collectors.toList()));
        tpmVerticalSchemeForecastTerminalRepository.saveBatch(terminalEntityList);

        return result;
    }

    @Override
    public boolean saveOrUpdateBatch(Collection<TpmVerticalSchemeForecastEntity> entityList, int batchSize) {
        List<TpmVerticalSchemeForecastFormulaEntity> formulaEntityList = Lists.newArrayList();
        List<TpmVerticalSchemeForecastProductEntity> productEntityList = new ArrayList<>();
        List<TpmVerticalSchemeForecastTerminalEntity> terminalEntityList = new ArrayList<>();
        for (TpmVerticalSchemeForecastEntity entity : entityList) {
            entity.setId(UUID.randomUUID().toString().replace("-", ""));

            TpmVerticalSchemeForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, TpmVerticalSchemeForecastFormulaEntity.class);
            formulaEntityList.add(formulaEntity);

            List<TpmVerticalSchemeForecastProductEntity> productList = tpmVerticalSchemeForecastProductRepository.buildEntityList(entity);
            for (TpmVerticalSchemeForecastProductEntity productEntity : productList) {
                productEntity.setSchemeForecastId(entity.getId());
            }
            productEntityList.addAll(productList);

            List<TpmVerticalSchemeForecastTerminalEntity> terminalList = tpmVerticalSchemeForecastTerminalRepository.buildEntityList(entity);
            for (TpmVerticalSchemeForecastTerminalEntity terminalEntity : terminalList) {
                terminalEntity.setSchemeForecastId(entity.getId());
            }
            terminalEntityList.addAll(terminalList);
        }

        entityList = this.clearExtend(Lists.newArrayList(entityList));
        boolean result = super.saveOrUpdateBatch(entityList, batchSize);
        //保存下公式扩展表
        tpmVerticalSchemeForecastFormulaRepository.saveOrUpdateBatch(formulaEntityList, batchSize);
        //保存下产品扩展表
        tpmVerticalSchemeForecastProductRepository.removeByForecastIds(entityList.stream().map(TpmVerticalSchemeForecastEntity::getId).collect(Collectors.toList()));
        tpmVerticalSchemeForecastProductRepository.saveBatch(productEntityList);
        //保存下门店扩展表
        tpmVerticalSchemeForecastTerminalRepository.removeByForecastIds(entityList.stream().map(TpmVerticalSchemeForecastEntity::getId).collect(Collectors.toList()));
        tpmVerticalSchemeForecastTerminalRepository.saveBatch(terminalEntityList);
        return result;
    }

    @Override
    public boolean updateBatchById(Collection<TpmVerticalSchemeForecastEntity> entityList, int batchSize) {
        List<TpmVerticalSchemeForecastFormulaEntity> formulaEntityList = Lists.newArrayList();
        List<TpmVerticalSchemeForecastProductEntity> productEntityList = new ArrayList<>();
        List<TpmVerticalSchemeForecastTerminalEntity> terminalEntityList = new ArrayList<>();
        for (TpmVerticalSchemeForecastEntity entity : entityList) {
            TpmVerticalSchemeForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, TpmVerticalSchemeForecastFormulaEntity.class);
            formulaEntityList.add(formulaEntity);

            List<TpmVerticalSchemeForecastProductEntity> productList = tpmVerticalSchemeForecastProductRepository.buildEntityList(entity);
            for (TpmVerticalSchemeForecastProductEntity productEntity : productList) {
                productEntity.setSchemeForecastId(entity.getId());
            }
            productEntityList.addAll(productList);

            List<TpmVerticalSchemeForecastTerminalEntity> terminalList = tpmVerticalSchemeForecastTerminalRepository.buildEntityList(entity);
            for (TpmVerticalSchemeForecastTerminalEntity terminalEntity : terminalList) {
                terminalEntity.setSchemeForecastId(entity.getId());
            }
            terminalEntityList.addAll(terminalList);
        }

        entityList = this.clearExtend(Lists.newArrayList(entityList));
        boolean result = super.updateBatchById(entityList, batchSize);

        //保存下公式扩展表
        tpmVerticalSchemeForecastFormulaRepository.updateBatchById(formulaEntityList, batchSize);
        //保存下产品扩展表
        tpmVerticalSchemeForecastProductRepository.removeByForecastIds(entityList.stream().map(TpmVerticalSchemeForecastEntity::getId).collect(Collectors.toList()));
        tpmVerticalSchemeForecastProductRepository.saveBatch(productEntityList);
        //保存下门店扩展表
        tpmVerticalSchemeForecastTerminalRepository.removeByForecastIds(entityList.stream().map(TpmVerticalSchemeForecastEntity::getId).collect(Collectors.toList()));
        tpmVerticalSchemeForecastTerminalRepository.saveBatch(terminalEntityList);
        return result;
    }

    @Override
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return true;
        }
        List<String> ids = idList.stream().map(Object::toString).collect(Collectors.toList());
        boolean result = super.removeByIds(idList);
        boolean formulaResult = this.tpmVerticalSchemeForecastFormulaRepository.removeByIds(idList);
        boolean productResult = this.tpmVerticalSchemeForecastProductRepository.removeByForecastIds(ids);
        boolean terminalResult = this.tpmVerticalSchemeForecastTerminalRepository.removeByForecastIds(ids);
        return result && formulaResult && productResult && terminalResult;
    }

    public List<TpmVerticalSchemeForecastEntity> findByActivityDetailItemCodes(Set<String> schemeItemCodes) {
        return this.lambdaQuery()
                .eq(TpmVerticalSchemeForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmVerticalSchemeForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(TpmVerticalSchemeForecastEntity::getSchemeItemCode, schemeItemCodes)
                .list();
    }

    public void updateConfirmStatusAndAmount(String id, String confirmStatus, BigDecimal estimatedWriteOffAmount) {
        if (StringUtils.isEmpty(id)){
            return;
        }
        this.update(Wrappers.<TpmVerticalSchemeForecastEntity>lambdaUpdate()
                .set(TpmVerticalSchemeForecastEntity::getConfirmStatus,confirmStatus)
                .set(TpmVerticalSchemeForecastEntity::getEstimatedWriteOffAmount,estimatedWriteOffAmount)
                .eq(TpmVerticalSchemeForecastEntity::getId,id)
        );
    }
}
