package com.biz.crm.tpm.business.scheme.forecast.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmVerticalSchemeForecastEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmVerticalSchemeForecastTerminalEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.mapper.TpmVerticalSchemeForecastTerminalMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import liquibase.util.StringUtil;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Component
public class TpmVerticalSchemeForecastTerminalRepository extends ServiceImpl<TpmVerticalSchemeForecastTerminalMapper, TpmVerticalSchemeForecastTerminalEntity> {

    @Autowired(required = false)
    private TpmVerticalSchemeForecastTerminalMapper tpmVerticalSchemeForecastTerminalMapper;

    private static final String property_schemeForecastId = "schemeForecastCodeId";
    private static final String property_schemeForecastCode = "schemeForecastCode";
    private static final String property_detailedCaseCode = "detailedCaseCode";
    private static final String property_activityDetailItemCode = "activityDetailItemCode";

    public static final List<String> excludeFieldList = Lists.newArrayList();

    static {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(TenantEntity.class);
        excludeFieldList.addAll(Arrays.stream(propertyDescriptors).map(PropertyDescriptor::getName).collect(Collectors.toList()));
        excludeFieldList.add(property_schemeForecastId);
        excludeFieldList.add(property_schemeForecastCode);
        excludeFieldList.add(property_detailedCaseCode);
        excludeFieldList.add(property_activityDetailItemCode);
    }

    //判断下是否所有属性都为空
    public boolean hasNotEmptyProperty(TpmVerticalSchemeForecastTerminalEntity entity) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(TpmVerticalSchemeForecastTerminalEntity.class);
        boolean hasNotEmptyProperty = false;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (excludeFieldList.contains(propertyDescriptor.getName())) {
                continue;
            }
            try {
                Object invoke = propertyDescriptor.getReadMethod().invoke(entity);
                if (null != invoke && StringUtil.isNotEmpty(invoke.toString())) {
                    hasNotEmptyProperty = true;
                    break;
                }
            } catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return hasNotEmptyProperty;
    }

    public List<TpmVerticalSchemeForecastTerminalEntity> buildEntityList(TpmVerticalSchemeForecastEntity entity) {
        List<TpmVerticalSchemeForecastTerminalEntity> terminalEntityList = new ArrayList<>();
        if (!StringUtils.isEmpty(entity.getTerminalCode())) {
            String[] codes = entity.getTerminalCode().split(",");
            List<String> names = Lists.newArrayList();
            if (!StringUtils.isEmpty(entity.getTerminalName())) {
                names = Arrays.asList(entity.getTerminalName().split(","));
            }
            for (int i = 0; i < codes.length; i++) {
                TpmVerticalSchemeForecastTerminalEntity terminalEntity = new TpmVerticalSchemeForecastTerminalEntity();
                terminalEntity.setTerminalCode(codes[i]);
                if (i < names.size()) {
                    terminalEntity.setTerminalName(names.get(i));
                }
                terminalEntity.setTenantCode(TenantUtils.getTenantCode());
                terminalEntity.setSchemeForecastId(entity.getId());
                terminalEntity.setSchemeForecastCode(entity.getSchemeForecastCode());
                terminalEntity.setSchemeCode(entity.getSchemeCode());
                terminalEntity.setSchemeItemCode(entity.getSchemeItemCode());
                terminalEntity.setYearMonthLy(entity.getYearMonthLy());
                terminalEntityList.add(terminalEntity);
            }
        }
        return terminalEntityList;
    }

    public boolean removeByForecastIds(List<String> forecastIds) {
        return this.lambdaUpdate()
                .eq(TpmVerticalSchemeForecastTerminalEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(TpmVerticalSchemeForecastTerminalEntity::getSchemeForecastId, forecastIds).remove();
    }

    public List<TpmVerticalSchemeForecastTerminalEntity> findByForecastIds(List<String> forecastIds) {
        return this.lambdaQuery()
                .eq(TpmVerticalSchemeForecastTerminalEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(TpmVerticalSchemeForecastTerminalEntity::getSchemeForecastId, forecastIds).list();
    }
}
